#!/bin/sh
export PATH='/usr/local/sbin:/usr/local/bin:/usr/bin:/usr/bin/site_perl:/usr/bin/vendor_perl:/usr/bin/core_perl'
echo 'name:                 postgresql-binary
version:              0.12.5
visibility:           public
id:                   postgresql-binary-0.12.5-ISN2EZkSDl87SOHYfpGteA
key:                  postgresql-binary-0.12.5-ISN2EZkSDl87SOHYfpGteA
license:              MIT
copyright:            (c) 2014, Nikita Volkov
maintainer:           Nikita Volkov <nikita.y.volkov@mail.ru>
author:               Nikita Volkov <nikita.y.volkov@mail.ru>
homepage:             https://github.com/nikita-volkov/postgresql-binary 
synopsis:             Encoders and decoders for the PostgreSQL'\''s binary format
description:
    An API for dealing with PostgreSQL'\''s binary data format.

    It can be used to implement performant bindings to Postgres.
    E.g., <http://hackage.haskell.org/package/hasql hasql>
    is based on this library.

    It supports all Postgres versions starting from 8.3
    and is tested against 8.3, 9.3 and 9.5
    with the @integer_datetimes@ setting off and on.

category:             PostgreSQL, Database, Codecs, Parsing
abi:                  4ef98f8f76729beb09d2e74ee8814cd7
exposed:              True
exposed-modules:
    PostgreSQL.Binary.Data PostgreSQL.Binary.Decoding
    PostgreSQL.Binary.Encoding

hidden-modules:
    PostgreSQL.Binary.Encoding.Builders PostgreSQL.Binary.Prelude
    PostgreSQL.Binary.Integral PostgreSQL.Binary.Interval
    PostgreSQL.Binary.Numeric PostgreSQL.Binary.Time
    PostgreSQL.Binary.Inet PostgreSQL.Binary.BuilderPrim

import-dirs:          /usr/lib/ghc-9.0.2/site-local/postgresql-binary-0.12.5
library-dirs:         /usr/lib/ghc-9.0.2/site-local/postgresql-binary-0.12.5
dynamic-library-dirs: /usr/lib
data-dir:             /usr/share/haskell-postgresql-binary
hs-libraries:         HSpostgresql-binary-0.12.5-ISN2EZkSDl87SOHYfpGteA
depends:
    aeson-2.1.2.1-A4BCifdqKBRKymWAxMJ7G4 base-4.15.1.0
    binary-parser-0.5.7.3-1uiDqd0JUy71KjVQsxEy8T bytestring-0.10.12.1
    bytestring-strict-builder-0.4.5.6-Lgpxj6hOiIu1weqgY3wN2N
    containers-0.6.4.1 network-ip-0.3.0.3-CAdDSXtUyJlJ7PIKOkt2qi
    scientific-0.3.7.0-6CvCEFxXBWR5nYRp7k6pyR text-1.2.5.0 time-1.9.3
    transformers-0.5.6.2
    unordered-containers-0.2.19.1-Km0aDxhChoIJJSbiufyazz
    uuid-1.3.15-9nOYqnIK4qDEtoPE3Ovc8E
    vector-0.13.0.0-9fyHsAonVFcGYv9jtLmfSh

haddock-interfaces:
    /usr/share/doc/haskell-postgresql-binary/html/postgresql-binary.haddock

haddock-html:         /usr/share/doc/haskell-postgresql-binary/html
' | '/usr/bin/ghc-pkg' 'update' '--force' '-' '--global' '--no-user-package-db' "$@"

