#!/bin/sh
export PATH='/usr/local/sbin:/usr/local/bin:/usr/bin:/usr/bin/site_perl:/usr/bin/vendor_perl:/usr/bin/core_perl'
echo 'name:                 QuickCheck-safe
version:              0.1.0.6
visibility:           public
id:                   QuickCheck-safe-0.1.0.6-9A7qor1X09J22grdV8V0xv
key:                  QuickCheck-safe-0.1.0.6-9A7qor1X09J22grdV8V0xv
license:              MIT
copyright:            2015,2017 Bertram Felgenhauer
maintainer:           Bertram Felgenhauer <int-e@gmx.de>
author:               Bertram Felgenhauer
synopsis:             Safe reimplementation of QuickCheck'\''s core
description:
    QuickCheck-safe reimplements the quickCheck functionality with a pure
    interface and a very small trusted base (see Test.QuickCheck.Safe.Trusted).

    * uses the existing Arbitrary instances
    * implemented features: testing, result minimization (i.e., shrinking)
    * missing features: expected failures, label frequencies, coverage

    The package is targeted at users who want to leverage SafeHaskell for
    sandboxing.

    >>> putStr $ quickCheck (inventQCGen ()) (\x -> length (x :: [()]) < 10)
    *** Failed! Falsifiable (after 18 tests and 3 shrinks):
    [(),(),(),(),(),(),(),(),(),(),(),(),(),(),()]

category:             Testing
abi:                  bbfbbbaab83e10dcf1441a5d526699c2
exposed:              True
exposed-modules:      Test.QuickCheck.Safe Test.QuickCheck.Safe.Trusted
import-dirs:          /usr/lib/ghc-9.0.2/site-local/QuickCheck-safe-0.1.0.6
library-dirs:         /usr/lib/ghc-9.0.2/site-local/QuickCheck-safe-0.1.0.6
dynamic-library-dirs: /usr/lib
data-dir:             /usr/share/haskell-quickcheck-safe
hs-libraries:         HSQuickCheck-safe-0.1.0.6-9A7qor1X09J22grdV8V0xv
depends:
    QuickCheck-2.14.3-1OE8Tk6Cvw85tkUdApuCR4 base-4.15.1.0
    containers-0.6.4.1

haddock-interfaces:
    /usr/share/doc/haskell-quickcheck-safe/html/QuickCheck-safe.haddock

haddock-html:         /usr/share/doc/haskell-quickcheck-safe/html
' | '/usr/bin/ghc-pkg' 'update' '--force' '-' '--global' '--no-user-package-db' "$@"

