#!/bin/sh
export PATH='/usr/local/sbin:/usr/local/bin:/usr/bin:/usr/bin/site_perl:/usr/bin/vendor_perl:/usr/bin/core_perl'
echo 'name:                 ral
version:              0.2.1
visibility:           public
id:                   ral-0.2.1-95AUey5h2r37QlCQb0c8sc
key:                  ral-0.2.1-95AUey5h2r37QlCQb0c8sc
license:              GPL-2.0-or-later
copyright:            (c) 2019-2021 Oleg Grenrus
maintainer:           Oleg.Grenrus <oleg.grenrus@iki.fi>
author:               Oleg Grenrus <oleg.grenrus@iki.fi>
homepage:             https://github.com/phadej/vec
synopsis:             Random access lists
description:
    This package provides ordinary random access list, '\''RAList'\'', and also
    a length indexed variant, '\''RAVec'\''.

    The data structure allows fast cons-operation (like ordinary list) but also fast random access (like non-functional arrays).

    For @lens@ or @optics@ support see [ral-lens](https://hackage.haskell.org/package/ral-lens) and [ral-optics](https://hackage.haskell.org/package/ral-optics) packages respectively.

    === Similar packages

    These packages don'\''t provide length-indexed variants, and their '\''RAList'\'' has
    opaque structure.

    * https://hackage.haskell.org/package/ralist
    * https://hackage.haskell.org/package/random-access-list

category:             Data, Dependent Types, Singletons
abi:                  9b282e2888a6eeb4dc25be3146fc26fe
exposed:              True
exposed-modules:
    Data.RAList Data.RAList.NonEmpty Data.RAList.Tree Data.RAVec
    Data.RAVec.NonEmpty Data.RAVec.Tree Data.RAVec.Tree.DF

hidden-modules:
    Data.RAList.Internal Data.RAList.NonEmpty.Internal
    Data.RAList.Tree.Internal TrustworthyCompat

import-dirs:          /usr/lib/ghc-9.0.2/site-local/ral-0.2.1
library-dirs:         /usr/lib/ghc-9.0.2/site-local/ral-0.2.1
dynamic-library-dirs: /usr/lib
data-dir:             /usr/share/haskell-ral
hs-libraries:         HSral-0.2.1-95AUey5h2r37QlCQb0c8sc
depends:
    QuickCheck-2.14.3-1OE8Tk6Cvw85tkUdApuCR4
    adjunctions-4.4.2-2vNgNHPGwfiAjRYYNWG4A2 base-4.15.1.0
    bin-0.1.3-J1q6ijwBHnd7TKhJha3Uw8
    boring-0.2.1-A8wgoiDmgwXAhCQHRXaSX4 deepseq-1.4.5.0
    distributive-0.6.2.1-JglHNXXzwPGIzyZMyl4KIx
    fin-0.3-InZwebmfZLj78okgHGpyyr
    hashable-1.4.2.0-8JSq7I7AhyyZ2Q90BxZWW
    indexed-traversable-0.1.2.1-JwIQVWOpW67GVSWDdLo884
    semigroupoids-5.3.7-KA0YT7sGVtk8p8u4maj8I2

haddock-interfaces:   /usr/share/doc/haskell-ral/html/ral.haddock
haddock-html:         /usr/share/doc/haskell-ral/html
' | '/usr/bin/ghc-pkg' 'update' '--force' '-' '--global' '--no-user-package-db' "$@"

