#!/bin/sh
export PATH='/usr/local/sbin:/usr/local/bin:/usr/bin:/usr/bin/site_perl:/usr/bin/vendor_perl:/usr/bin/core_perl'
echo 'name:                 random
version:              1.2.1.1
visibility:           public
id:                   random-1.2.1.1-K0OGGZ2RgxUBJhcMzCddDt
key:                  random-1.2.1.1-K0OGGZ2RgxUBJhcMzCddDt
license:              BSD-3-Clause
maintainer:           core-libraries-committee@haskell.org
synopsis:             Pseudo-random number generation
description:
    This package provides basic pseudo-random number generation, including the
    ability to split random number generators.

    == "System.Random": pure pseudo-random number interface

    In pure code, use '\''System.Random.uniform'\'' and '\''System.Random.uniformR'\'' from
    "System.Random" to generate pseudo-random numbers with a pure pseudo-random
    number generator like '\''System.Random.StdGen'\''.

    As an example, here is how you can simulate rolls of a six-sided die using
    '\''System.Random.uniformR'\'':

    >>> let roll = uniformR (1, 6)        :: RandomGen g => g -> (Word, g)
    >>> let rolls = unfoldr (Just . roll) :: RandomGen g => g -> [Word]
    >>> let pureGen = mkStdGen 42
    >>> take 10 (rolls pureGen)           :: [Word]
    [1,1,3,2,4,5,3,4,6,2]

    See "System.Random" for more details.

    == "System.Random.Stateful": monadic pseudo-random number interface

    In monadic code, use '\''System.Random.Stateful.uniformM'\'' and
    '\''System.Random.Stateful.uniformRM'\'' from "System.Random.Stateful" to generate
    pseudo-random numbers with a monadic pseudo-random number generator, or
    using a monadic adapter.

    As an example, here is how you can simulate rolls of a six-sided die using
    '\''System.Random.Stateful.uniformRM'\'':

    >>> let rollM = uniformRM (1, 6)                 :: StatefulGen g m => g -> m Word
    >>> let pureGen = mkStdGen 42
    >>> runStateGen_ pureGen (replicateM 10 . rollM) :: [Word]
    [1,1,3,2,4,5,3,4,6,2]

    The monadic adapter '\''System.Random.Stateful.runStateGen_'\'' is used here to lift
    the pure pseudo-random number generator @pureGen@ into the
    '\''System.Random.Stateful.StatefulGen'\'' context.

    The monadic interface can also be used with existing monadic pseudo-random
    number generators. In this example, we use the one provided in the
    <https://hackage.haskell.org/package/mwc-random mwc-random> package:

    >>> import System.Random.MWC as MWC
    >>> let rollM = uniformRM (1, 6)       :: StatefulGen g m => g -> m Word
    >>> monadicGen <- MWC.create
    >>> replicateM 10 (rollM monadicGen) :: IO [Word]
    [2,3,6,6,4,4,3,1,5,4]

    See "System.Random.Stateful" for more details.

category:             System
abi:                  95f2fdf675fea1633a0482d8637bc984
exposed:              True
exposed-modules:
    System.Random System.Random.Internal System.Random.Stateful

hidden-modules:       System.Random.GFinite
import-dirs:          /usr/lib/ghc-9.0.2/site-local/random-1.2.1.1
library-dirs:         /usr/lib/ghc-9.0.2/site-local/random-1.2.1.1
dynamic-library-dirs: /usr/lib
data-dir:             /usr/share/haskell-random
hs-libraries:         HSrandom-1.2.1.1-K0OGGZ2RgxUBJhcMzCddDt
depends:
    base-4.15.1.0 bytestring-0.10.12.1 deepseq-1.4.5.0 mtl-2.2.2
    splitmix-0.1.0.4-C7qzaU2AdKXIINiZhLxPNL

haddock-interfaces:   /usr/share/doc/haskell-random/html/random.haddock
haddock-html:         /usr/share/doc/haskell-random/html
' | '/usr/bin/ghc-pkg' 'update' '--force' '-' '--global' '--no-user-package-db' "$@"

