#!/bin/sh
export PATH='/usr/local/sbin:/usr/local/bin:/usr/bin:/usr/bin/site_perl:/usr/bin/vendor_perl:/usr/bin/core_perl'
echo 'name:                 random-source
version:              0.3.0.12
visibility:           public
id:                   random-source-0.3.0.12-2XcZFLm0MsS6BJho16G4l8
key:                  random-source-0.3.0.12-2XcZFLm0MsS6BJho16G4l8
license:              LicenseRef-PublicDomain
maintainer:           James Cook <mokus@deepbondi.net>
author:               James Cook <mokus@deepbondi.net>
stability:            provisional
homepage:             https://github.com/mokus0/random-fu
synopsis:             Generic basis for random number generators
description:
    Random number generation based on entropy sources
    able to produce a small but well-defined set of
    primitive variates.  Also includes facilities for
    \"completing\" partial implementations, making it
    easy to define new entropy sources in a way that
    is naturally forward-compatible.

category:             Math
abi:                  6d324fc3628852a03d393eef8ec5a633
exposed:              True
exposed-modules:
    Data.Random.Internal.Source Data.Random.Internal.Words
    Data.Random.Source Data.Random.Source.DevRandom
    Data.Random.Source.IO Data.Random.Source.MWC
    Data.Random.Source.PureMT Data.Random.Source.Std
    Data.Random.Source.StdGen

hidden-modules:
    Data.Random.Source.Internal.Prim Data.Random.Source.Internal.TH

import-dirs:          /usr/lib/ghc-9.0.2/site-local/random-source-0.3.0.12
library-dirs:         /usr/lib/ghc-9.0.2/site-local/random-source-0.3.0.12
dynamic-library-dirs: /usr/lib
data-dir:             /usr/share/haskell-random-source
hs-libraries:         HSrandom-source-0.3.0.12-2XcZFLm0MsS6BJho16G4l8
depends:
    base-4.15.1.0 flexible-defaults-0.0.3-3k5nXR3qFjHDrcIlltfYUf
    mersenne-random-pure64-0.2.2.0-G3Kqfrb9wzMGQotVCvmK2i mtl-2.2.2
    mwc-random-0.15.0.2-LcgFDXKxrBg3pQAS28VrYq
    primitive-0.7.4.0-8RUdbvjRYjOFHQ1vgzaS7Q
    random-1.2.1.1-K0OGGZ2RgxUBJhcMzCddDt
    stateref-0.3-9u9QCRlvo9dHk1YF6aLbH9
    syb-0.7.2.3-ItYotKJTU3VJfC5cskyLmn template-haskell-2.17.0.0
    th-extras-0.0.0.6-EEs5JOGg7884FiIbUF9u2f

haddock-interfaces:
    /usr/share/doc/haskell-random-source/html/random-source.haddock

haddock-html:         /usr/share/doc/haskell-random-source/html
' | '/usr/bin/ghc-pkg' 'update' '--force' '-' '--global' '--no-user-package-db' "$@"

