#!/bin/sh
export PATH='/usr/local/sbin:/usr/local/bin:/usr/bin:/usr/bin/site_perl:/usr/bin/vendor_perl:/usr/bin/core_perl'
echo 'name:                 recursion-schemes
version:              5.2.2.4
visibility:           public
id:                   recursion-schemes-5.2.2.4-Ffb5c97eUQpDmTuuKkWGO2
key:                  recursion-schemes-5.2.2.4-Ffb5c97eUQpDmTuuKkWGO2
license:              BSD-2-Clause
copyright:            Copyright (C) 2008-2015 Edward A. Kmett
maintainer:
    "Samuel Gélineau" <gelisam@gmail.com>,
    "Ryan Scott" <ryan.gl.scott@gmail.com>,
    "Luc Tielen" <luc.tielen@gmail.com>

author:               Edward A. Kmett
stability:            provisional
homepage:             http://github.com/ekmett/recursion-schemes/
synopsis:
    Representing common recursion patterns as higher-order functions

description:
    Many recursive functions share the same structure, e.g. pattern-match on the input and, depending on the data constructor, either recur on a smaller input or terminate the recursion with the base case. Another one: start with a seed value, use it to produce the first element of an infinite list, and recur on a modified seed in order to produce the rest of the list. Such a structure is called a recursion scheme. Using higher-order functions to implement those recursion schemes makes your code clearer, faster, and safer. See README for details.

category:             Control, Recursion
abi:                  14a6d540156ccd2f99bdf1ec8b3afc0f
exposed:              True
exposed-modules:
    Data.Functor.Base Data.Functor.Foldable Data.Functor.Foldable.TH

hidden-modules:       Paths_recursion_schemes
import-dirs:          /usr/lib/ghc-9.0.2/site-local/recursion-schemes-5.2.2.4
library-dirs:         /usr/lib/ghc-9.0.2/site-local/recursion-schemes-5.2.2.4
dynamic-library-dirs: /usr/lib
data-dir:             /usr/share/haskell-recursion-schemes
hs-libraries:         HSrecursion-schemes-5.2.2.4-Ffb5c97eUQpDmTuuKkWGO2
depends:
    base-4.15.1.0 base-orphans-0.8.7-LhKj0z9LMht22T0DHRHyFW
    comonad-5.0.8-4z7AihQ42OKAJi2EQgp02u containers-0.6.4.1
    data-fix-0.3.2-F5YI9qAj3M1GeOditmsT5l
    free-5.1.10-JIdA28qKKvuIGxHjXb7ZXe template-haskell-2.17.0.0
    th-abstraction-0.4.5.0-CPrpKcr2W2S31K8QsJKgDp transformers-0.5.6.2

haddock-interfaces:
    /usr/share/doc/haskell-recursion-schemes/html/recursion-schemes.haddock

haddock-html:         /usr/share/doc/haskell-recursion-schemes/html
' | '/usr/bin/ghc-pkg' 'update' '--force' '-' '--global' '--no-user-package-db' "$@"

