#!/bin/sh
export PATH='/usr/local/sbin:/usr/local/bin:/usr/bin:/usr/bin/site_perl:/usr/bin/vendor_perl:/usr/bin/core_perl'
echo 'name:                 RSA
version:              2.4.1
visibility:           public
id:                   RSA-2.4.1-K4HtlGfwK56ItYrms1Kuo5
key:                  RSA-2.4.1-K4HtlGfwK56ItYrms1Kuo5
license:              BSD-3-Clause
maintainer:           Adam Wick <awick@galois.com>
author:               Adam Wick <awick@galois.com>
stability:            stable
synopsis:
    Implementation of RSA, using the padding schemes of PKCS#1 v2.1.

description:
    This library implements the RSA encryption and signature
    algorithms for arbitrarily-sized ByteStrings. While the
    implementations work, they are not necessarily the fastest ones
    on the planet. Particularly key generation. The algorithms
    included are based of RFC 3447, or the Public-Key Cryptography
    Standard for RSA, version 2.1 (a.k.a, PKCS#1 v2.1).

category:             Cryptography, Codec
abi:                  f3ae7a035617b17452aa04b8c66dcca4
exposed:              True
exposed-modules:
    Codec.Crypto.RSA Codec.Crypto.RSA.Exceptions Codec.Crypto.RSA.Pure

import-dirs:          /usr/lib/ghc-9.0.2/site-local/RSA-2.4.1
library-dirs:         /usr/lib/ghc-9.0.2/site-local/RSA-2.4.1
dynamic-library-dirs: /usr/lib
data-dir:             /usr/share/haskell-rsa
hs-libraries:         HSRSA-2.4.1-K4HtlGfwK56ItYrms1Kuo5
depends:
    SHA-1.6.4.4-1UNVNO3JXJdDGqRoMkntZx base-4.15.1.0 binary-0.8.8.0
    bytestring-0.10.12.1 crypto-api-0.13.3-EHPdhbKdFzpJPwJ37IaBSu
    crypto-pubkey-types-0.4.3-6tNA4VpVOklKfaoa6AOE1h

haddock-interfaces:   /usr/share/doc/haskell-rsa/html/RSA.haddock
haddock-html:         /usr/share/doc/haskell-rsa/html
' | '/usr/bin/ghc-pkg' 'update' '--force' '-' '--global' '--no-user-package-db' "$@"

