#!/bin/sh
export PATH='/usr/local/sbin:/usr/local/bin:/usr/bin:/usr/bin/site_perl:/usr/bin/vendor_perl:/usr/bin/core_perl'
echo 'name:                 semialign
version:              1.2.0.1
visibility:           public
id:                   semialign-1.2.0.1-L3HiqIPbIDwG6hqCRiIHhY
key:                  semialign-1.2.0.1-L3HiqIPbIDwG6hqCRiIHhY
license:              BSD-3-Clause
maintainer:           Oleg Grenrus <oleg.grenrus@iki.fi>
author:               C. McCann, Oleg Grenrus
homepage:             https://github.com/haskellari/these
synopsis:
    Align and Zip type-classes from the common Semialign ancestor.

description:
    The major use of @These@ of this is provided by the @align@ member of
    @Semialign@ class, representing a generalized notion of "zipping with padding"
    that combines structures without truncating to the size of the smaller input.

    It turns out that @zip@ operation fits well the @Semialign@ class,
    forming lattice-like structure.

category:             Data, These
abi:                  1f4311d75ba3447eaa7db687c61d64cc
exposed:              True
exposed-modules:
    Data.Align Data.Crosswalk Data.Semialign Data.Semialign.Indexed
    Data.Zip

hidden-modules:       Data.Semialign.Internal
import-dirs:          /usr/lib/ghc-9.0.2/site-local/semialign-1.2.0.1
library-dirs:         /usr/lib/ghc-9.0.2/site-local/semialign-1.2.0.1
dynamic-library-dirs: /usr/lib
data-dir:             /usr/share/haskell-semialign
hs-libraries:         HSsemialign-1.2.0.1-L3HiqIPbIDwG6hqCRiIHhY
depends:
    base-4.15.1.0 containers-0.6.4.1
    hashable-1.4.2.0-8JSq7I7AhyyZ2Q90BxZWW
    indexed-traversable-0.1.2.1-JwIQVWOpW67GVSWDdLo884
    indexed-traversable-instances-0.1.1.2-ITg9ZgLh5kL5mJNTLzSwI3
    semigroupoids-5.3.7-KA0YT7sGVtk8p8u4maj8I2
    tagged-0.8.7-8MQxDldL1qw9fJF5LZxnpf
    these-1.1.1.1-Co8qfzI8wtgJaT0RN5FqXo transformers-0.5.6.2
    unordered-containers-0.2.19.1-Km0aDxhChoIJJSbiufyazz
    vector-0.13.0.0-9fyHsAonVFcGYv9jtLmfSh

haddock-interfaces:   /usr/share/doc/haskell-semialign/html/semialign.haddock
haddock-html:         /usr/share/doc/haskell-semialign/html
' | '/usr/bin/ghc-pkg' 'update' '--force' '-' '--global' '--no-user-package-db' "$@"

