#!/bin/sh
export PATH='/usr/local/sbin:/usr/local/bin:/usr/bin:/usr/bin/site_perl:/usr/bin/vendor_perl:/usr/bin/core_perl'
echo 'name:                 servant-swagger
version:              1.1.11
visibility:           public
id:                   servant-swagger-1.1.11-HdKsVwpBvAn4ti5g54pHCp
key:                  servant-swagger-1.1.11-HdKsVwpBvAn4ti5g54pHCp
license:              BSD-3-Clause
copyright:            (c) 2015-2018, Servant contributors
maintainer:           haskell-servant-maintainers@googlegroups.com
author:               Servant Contributors
homepage:
    https://github.com/haskell-servant/servant/tree/master/servant-swagger#readme

synopsis:
    Generate a Swagger/OpenAPI/OAS 2.0 specification for your servant API.

description:
    Swagger is a project used to describe and document RESTful APIs. The core of the
    project is the [OpenAPI Specification (OAS)](https://swagger.io/docs/specification/about/).
    This library implements v2.0 of the spec. Unlike Servant it is language-agnostic and thus is
    quite popular among developers in different languages. It has also existed for a longer time
    and has more helpful tooling.

    This package provides means to generate a Swagger/OAS specification for a Servant API
    and also to partially test whether an API conforms with its specification.

    Generated Swagger specification then can be used for many things such as

    * displaying interactive documentation using [Swagger UI](http://swagger.io/swagger-ui/);

    * generating clients and servers in many languages using [Swagger Codegen](http://swagger.io/swagger-codegen/);

    * and [many others](http://swagger.io/open-source-integrations/).

category:             Web, Servant, Swagger
abi:                  c73444f6a4b0359baa7d6113363d08d0
exposed:              True
exposed-modules:
    Servant.Swagger Servant.Swagger.Internal
    Servant.Swagger.Internal.Orphans Servant.Swagger.Internal.Test
    Servant.Swagger.Internal.TypeLevel
    Servant.Swagger.Internal.TypeLevel.API
    Servant.Swagger.Internal.TypeLevel.Every
    Servant.Swagger.Internal.TypeLevel.TMap Servant.Swagger.Test
    Servant.Swagger.TypeLevel

import-dirs:          /usr/lib/ghc-9.0.2/site-local/servant-swagger-1.1.11
library-dirs:         /usr/lib/ghc-9.0.2/site-local/servant-swagger-1.1.11
dynamic-library-dirs: /usr/lib
data-dir:             /usr/share/haskell-servant-swagger
hs-libraries:         HSservant-swagger-1.1.11-HdKsVwpBvAn4ti5g54pHCp
depends:
    QuickCheck-2.14.3-1OE8Tk6Cvw85tkUdApuCR4
    aeson-2.1.2.1-A4BCifdqKBRKymWAxMJ7G4
    aeson-pretty-0.8.9-5lTV2yokao3rqi6vQJbJu base-4.15.1.0
    base-compat-0.12.2-l1EqrM7Qwu6Pq9d4drKFu bytestring-0.10.12.1
    hspec-2.10.9-5ihXCFT3Zax5sW9xvf8qrc
    http-media-0.8.1.0-DjOMt8xv1TyDtAERH5LZ2T
    insert-ordered-containers-0.2.5.3-fy1ZhoMisy8g1SG1UtVjf
    lens-5.2.2-4uj1AepANiF2ook39zjsmk
    servant-0.19.1-3K8ExXu36yw6Qw9Vmu05LI
    singleton-bool-0.1.7-KoH66ShrwHI5b8sqo23JLo
    swagger2-2.8.7-Cnq1cVZ6cc0KNRoae4I6Zw text-1.2.5.0
    unordered-containers-0.2.19.1-Km0aDxhChoIJJSbiufyazz

haddock-interfaces:
    /usr/share/doc/haskell-servant-swagger/html/servant-swagger.haddock

haddock-html:         /usr/share/doc/haskell-servant-swagger/html
' | '/usr/bin/ghc-pkg' 'update' '--force' '-' '--global' '--no-user-package-db' "$@"

