#!/bin/sh
export PATH='/usr/local/sbin:/usr/local/bin:/usr/bin:/usr/bin/site_perl:/usr/bin/vendor_perl:/usr/bin/core_perl'
echo 'name:                 skein
version:              1.0.9.4
visibility:           public
id:                   skein-1.0.9.4-90mm8PFfaVvFwaUNY79CCJ
key:                  skein-1.0.9.4-90mm8PFfaVvFwaUNY79CCJ
license:              BSD-3-Clause
maintainer:           Felipe Lessa <felipe.lessa@gmail.com>
author:               Felipe Lessa <felipe.lessa@gmail.com>, Doug Whiting
homepage:             https://github.com/meteficha/skein
synopsis:
    Skein, a family of cryptographic hash functions.  Includes Skein-MAC as well.

description:
    Skein (<http://www.skein-hash.info/>) is a family of fast
    secure cryptographic hash functions designed by Niels
    Ferguson, Stefan Lucks, Bruce Schneier, Doug Whiting, Mihir
    Bellare, Tadayoshi Kohno, Jon Callas and Jesse Walker.

    This package uses bindings to the optimized C implementation
    of Skein.  We provide a high-level interface (see module
    "Crypto.Skein") to some of the Skein use cases.  We also
    provide a low-level interface (see module
    "Crypto.Skein.Internal") should you need to use Skein in a
    different way.

    Currently we have support for Skein as cryptographic hash
    function as Skein as a message authentication code
    (Skein-MAC).  For examples of how to use this package, see
    "Crypto.Skein" module documentation.

    This package includes Skein v1.3. Versions of this package
    before 1.0.0 implemented Skein v1.1.

category:             Cryptography
abi:                  5d95c810e14899dafe9ee310f19643a1
exposed:              True
exposed-modules:      Crypto.Skein Crypto.Skein.Internal
import-dirs:          /usr/lib/ghc-9.0.2/site-local/skein-1.0.9.4
library-dirs:         /usr/lib/ghc-9.0.2/site-local/skein-1.0.9.4
dynamic-library-dirs: /usr/lib
data-dir:             /usr/share/haskell-skein
hs-libraries:         HSskein-1.0.9.4-90mm8PFfaVvFwaUNY79CCJ
includes:             skein.h
depends:
    base-4.15.1.0 bytestring-0.10.12.1
    cereal-0.5.8.3-KCibhvvTsuv86wVgcPkD6
    crypto-api-0.13.3-EHPdhbKdFzpJPwJ37IaBSu
    tagged-0.8.7-8MQxDldL1qw9fJF5LZxnpf

haddock-interfaces:   /usr/share/doc/haskell-skein/html/skein.haddock
haddock-html:         /usr/share/doc/haskell-skein/html
' | '/usr/bin/ghc-pkg' 'update' '--force' '-' '--global' '--no-user-package-db' "$@"

