#!/bin/sh
export PATH='/usr/local/sbin:/usr/local/bin:/usr/bin:/usr/bin/site_perl:/usr/bin/vendor_perl:/usr/bin/core_perl'
echo 'name:                 skylighting-core
version:              0.13.3
visibility:           public
id:                   skylighting-core-0.13.3-I2KEjNI9KR4AiTF4sCod8m
key:                  skylighting-core-0.13.3-I2KEjNI9KR4AiTF4sCod8m
license:              BSD-3-Clause
copyright:            (C) 2016-2018 John MacFarlane
maintainer:           jgm@berkeley.edu
author:               John MacFarlane
homepage:             https://github.com/jgm/skylighting
synopsis:             syntax highlighting library
description:
    Skylighting is a syntax highlighting library.
    It derives its tokenizers from XML syntax
    definitions used by KDE'\''s KSyntaxHighlighting
    framework, so any syntax supported by that
    framework can be added. An optional command-line
    program is provided.
    Skylighting is intended to be the successor to
    highlighting-kate.
    This package provides the core highlighting
    functionality under a permissive license. It also
    bundles XML parser definitions licensed under the
    GPL.

category:             Text
abi:                  f15b39de314b0d1b150654a250ea1ac6
exposed:              True
exposed-modules:
    Skylighting.Core Skylighting.Loader Skylighting.Parser
    Skylighting.Regex Skylighting.Styles Skylighting.Tokenizer
    Skylighting.Types

hidden-modules:
    Regex.KDE Regex.KDE.Regex Regex.KDE.Compile Regex.KDE.Match

import-dirs:          /usr/lib/ghc-9.0.2/site-local/skylighting-core-0.13.3
library-dirs:         /usr/lib/ghc-9.0.2/site-local/skylighting-core-0.13.3
dynamic-library-dirs: /usr/lib
data-dir:             /usr/share/haskell-skylighting-core
hs-libraries:         HSskylighting-core-0.13.3-I2KEjNI9KR4AiTF4sCod8m
depends:
    aeson-2.1.2.1-A4BCifdqKBRKymWAxMJ7G4
    attoparsec-0.14.4-4fjJnHqpy2x7zsjAU0XRWO base-4.15.1.0
    base64-bytestring-1.2.1.0-D7qbdpqh7ZAHvyipCqb2En binary-0.8.8.0
    bytestring-0.10.12.1 case-insensitive-1.2.1.0-4jgW7rCNZT7HuDvSGowCF
    colour-2.3.6-EuYv2zipv8X3m9Cp1zQHEC containers-0.6.4.1
    directory-1.3.6.2 filepath-1.4.2.1 mtl-2.2.2
    safe-0.3.19-2aVM1fCfxX88jnlVeNbd8Q text-1.2.5.0
    transformers-0.5.6.2 utf8-string-1.0.2-519AraujIYSLY3i7TJuoqO
    xml-conduit-1.9.1.3-FXhjiZfXbw4LbDReANXEOS

haddock-interfaces:
    /usr/share/doc/haskell-skylighting-core/html/skylighting-core.haddock

haddock-html:         /usr/share/doc/haskell-skylighting-core/html
' | '/usr/bin/ghc-pkg' 'update' '--force' '-' '--global' '--no-user-package-db' "$@"

