#!/bin/sh
export PATH='/usr/local/sbin:/usr/local/bin:/usr/bin:/usr/bin/site_perl:/usr/bin/vendor_perl:/usr/bin/core_perl'
echo 'name:                 snap-core
version:              1.0.5.1
visibility:           public
id:                   snap-core-1.0.5.1-11593tEXFcMAg7jlB2WhZZ
key:                  snap-core-1.0.5.1-11593tEXFcMAg7jlB2WhZZ
license:              BSD-3-Clause
maintainer:           snap@snapframework.com
author:               Snap Framework Authors (see CONTRIBUTORS)
homepage:             http://snapframework.com/
synopsis:             Snap: A Haskell Web Framework (core interfaces and types)
description:
    Snap is a simple and fast web development framework and server written in
    Haskell. For more information or to download the latest version, you can
    visit the Snap project website at <http://snapframework.com/>.

    This library contains the core definitions and types for the Snap framework,
    including:

    1. Primitive types and functions for HTTP (requests, responses, cookies,
    post/query parameters, etc)

    2. A monad for programming web handlers called \"Snap\", which allows:

    * Stateful access to the HTTP request and response objects

    * Monadic failure (i.e. MonadPlus/Alternative instances) for declining
    to handle requests and chaining handlers together

    * Early termination of the computation if you know early what you want
    to return and want to prevent further monadic processing

    /Quick start/: The '\''Snap'\'' monad and HTTP definitions are in "Snap.Core".

category:             Web, Snap, IO-Streams
abi:                  2eef99a47c0eba8fdfc12aa2ff481d32
exposed:              True
exposed-modules:
    Snap.Core Snap.Internal.Core Snap.Internal.Debug
    Snap.Internal.Http.Types Snap.Internal.Parsing
    Snap.Internal.Util.FileServe Snap.Test Snap.Types.Headers
    Snap.Util.CORS Snap.Util.FileServe Snap.Util.FileUploads
    Snap.Util.GZip Snap.Util.Proxy

hidden-modules:
    Snap.Internal.Instances Snap.Internal.Routing
    Snap.Internal.Test.RequestBuilder Snap.Internal.Test.Assertions
    Snap.Internal.Util.FileUploads

import-dirs:          /usr/lib/ghc-9.0.2/site-local/snap-core-1.0.5.1
library-dirs:         /usr/lib/ghc-9.0.2/site-local/snap-core-1.0.5.1
dynamic-library-dirs: /usr/lib
data-dir:             /usr/share/haskell-snap-core
hs-libraries:         HSsnap-core-1.0.5.1-11593tEXFcMAg7jlB2WhZZ
depends:
    HUnit-1.6.2.0-JGxgr0O3qDr2sR1C0CRfuz
    attoparsec-0.14.4-4fjJnHqpy2x7zsjAU0XRWO base-4.15.1.0
    bytestring-0.10.12.1 case-insensitive-1.2.1.0-4jgW7rCNZT7HuDvSGowCF
    containers-0.6.4.1 directory-1.3.6.2 filepath-1.4.2.1
    hashable-1.4.2.0-8JSq7I7AhyyZ2Q90BxZWW
    io-streams-1.5.2.2-HlPLQSNazvOGmvO4lqnsG9
    lifted-base-0.2.3.12-BiJRsPA9EvQGhEhORMP1Pf
    monad-control-1.0.3.1-35h1aVdsL57202S8tnbNU9 mtl-2.2.2
    network-3.1.4.0-5PP4MrJJnZZJkybIlRRAPq
    network-uri-2.6.4.2-18lVeOrHqdkDTTcK9hqBly
    old-locale-1.0.0.7-B94o3sNLYrV8oE3WO2rqHh
    random-1.2.1.1-K0OGGZ2RgxUBJhcMzCddDt
    readable-0.3.1-8qk55zLnPf8IWPnnTbUyya
    regex-posix-0.96.0.1-3tnfXrSqQrb7MJMFtuTwG8 text-1.2.5.0 time-1.9.3
    transformers-0.5.6.2 transformers-base-0.4.6-92OnlKVmSzm7Q6K6Tg9Pzs
    unix-compat-0.7-ImZLGak9HFVAcx5hoGYQVF
    unordered-containers-0.2.19.1-Km0aDxhChoIJJSbiufyazz
    vector-0.13.0.0-9fyHsAonVFcGYv9jtLmfSh

haddock-interfaces:   /usr/share/doc/haskell-snap-core/html/snap-core.haddock
haddock-html:         /usr/share/doc/haskell-snap-core/html
' | '/usr/bin/ghc-pkg' 'update' '--force' '-' '--global' '--no-user-package-db' "$@"

