#!/bin/sh
export PATH='/usr/local/sbin:/usr/local/bin:/usr/bin:/usr/bin/site_perl:/usr/bin/vendor_perl:/usr/bin/core_perl'
echo 'name:                 snap-server
version:              1.1.2.1
visibility:           public
id:                   snap-server-1.1.2.1-BGQef2EOgxvEHIbXY7C4s1
key:                  snap-server-1.1.2.1-BGQef2EOgxvEHIbXY7C4s1
license:              BSD-3-Clause
maintainer:           snap@snapframework.com
author:               Snap Framework Authors  (see CONTRIBUTORS)
homepage:             http://snapframework.com/
synopsis:             A web server for the Snap Framework
description:
    Snap is a simple and fast web development framework and server written in
    Haskell. For more information or to download the latest version, you can
    visit the Snap project website at <http://snapframework.com/>.

    The Snap HTTP server is a high performance web server library written in
    Haskell. Together with the @snap-core@ library upon which it depends, it
    provides a clean and efficient Haskell programming interface to the HTTP
    protocol.

category:             Web, Snap, IO-Streams
abi:                  44c6257fd49b2426e3207be1d35f943b
exposed:              True
exposed-modules:
    Snap.Http.Server Snap.Http.Server.Config Snap.Http.Server.Types
    Snap.Internal.Http.Server.Config Snap.Internal.Http.Server.Types
    System.FastLogger

hidden-modules:
    Paths_snap_server Control.Concurrent.Extended
    Snap.Internal.Http.Server.Address Snap.Internal.Http.Server.Clock
    Snap.Internal.Http.Server.Common Snap.Internal.Http.Server.Date
    Snap.Internal.Http.Server.Parser Snap.Internal.Http.Server.Session
    Snap.Internal.Http.Server.Socket Snap.Internal.Http.Server.Thread
    Snap.Internal.Http.Server.TimeoutManager
    Snap.Internal.Http.Server.TLS System.SendFile System.SendFile.Linux

import-dirs:          /usr/lib/ghc-9.0.2/site-local/snap-server-1.1.2.1
library-dirs:         /usr/lib/ghc-9.0.2/site-local/snap-server-1.1.2.1
dynamic-library-dirs: /usr/lib
data-dir:             /usr/share/haskell-snap-server
hs-libraries:         HSsnap-server-1.1.2.1-BGQef2EOgxvEHIbXY7C4s1
depends:
    attoparsec-0.14.4-4fjJnHqpy2x7zsjAU0XRWO base-4.15.1.0
    blaze-builder-0.4.2.3-D7RNQqfFzoeIMP5JYaknz9 bytestring-0.10.12.1
    case-insensitive-1.2.1.0-4jgW7rCNZT7HuDvSGowCF
    clock-0.8.3-2U80sdDOrjmBlVZLInPGG1 containers-0.6.4.1
    filepath-1.4.2.1 io-streams-1.5.2.2-HlPLQSNazvOGmvO4lqnsG9
    io-streams-haproxy-1.0.1.0-6H2dWLQQSSi5DaftXegr3b
    lifted-base-0.2.3.12-BiJRsPA9EvQGhEhORMP1Pf mtl-2.2.2
    network-3.1.4.0-5PP4MrJJnZZJkybIlRRAPq
    old-locale-1.0.0.7-B94o3sNLYrV8oE3WO2rqHh
    snap-core-1.0.5.1-11593tEXFcMAg7jlB2WhZZ text-1.2.5.0 time-1.9.3
    transformers-0.5.6.2 unix-2.7.2.2
    unix-compat-0.7-ImZLGak9HFVAcx5hoGYQVF
    vector-0.13.0.0-9fyHsAonVFcGYv9jtLmfSh

haddock-interfaces:   /usr/share/doc/haskell-snap-server/html/snap-server.haddock
haddock-html:         /usr/share/doc/haskell-snap-server/html
' | '/usr/bin/ghc-pkg' 'update' '--force' '-' '--global' '--no-user-package-db' "$@"

