#!/bin/sh
export PATH='/usr/local/sbin:/usr/local/bin:/usr/bin:/usr/bin/site_perl:/usr/bin/vendor_perl:/usr/bin/core_perl'
echo 'name:                 sop-core
version:              0.5.0.2
visibility:           public
id:                   sop-core-0.5.0.2-3jnDWqiXqcyAzV81XsfWbk
key:                  sop-core-0.5.0.2-3jnDWqiXqcyAzV81XsfWbk
license:              BSD-3-Clause
maintainer:           andres@well-typed.com
author:
    Edsko de Vries <edsko@well-typed.com>, Andres Löh <andres@well-typed.com>

synopsis:             True Sums of Products
description:
    Implementation of n-ary sums and n-ary products.

    The module "Data.SOP" is the main module of this library and contains
    more detailed documentation.

    The main use case of this package is to serve as the core of
    @<https://hackage.haskell.org/package/generics-sop generics-sop>@.

    A detailed description of the ideas behind this library is provided by
    the paper:

    * Edsko de Vries and Andres Löh.
    <http://www.andres-loeh.de/TrueSumsOfProducts True Sums of Products>.
    Workshop on Generic Programming (WGP) 2014.

category:             Data
abi:                  d4f536c46e3eca2379396efbedb69715
exposed:              True
exposed-modules:
    Data.SOP Data.SOP.BasicFunctors Data.SOP.Classes
    Data.SOP.Constraint Data.SOP.Dict Data.SOP.NP Data.SOP.NS
    Data.SOP.Sing

import-dirs:          /usr/lib/ghc-9.0.2/site-local/sop-core-0.5.0.2
library-dirs:         /usr/lib/ghc-9.0.2/site-local/sop-core-0.5.0.2
dynamic-library-dirs: /usr/lib
data-dir:             /usr/share/x86_64-linux-ghc-9.0.2/sop-core-0.5.0.2
hs-libraries:         HSsop-core-0.5.0.2-3jnDWqiXqcyAzV81XsfWbk
depends:              base-4.15.1.0 deepseq-1.4.5.0
haddock-interfaces:   /usr/share/doc/haskell-sop-core/html/sop-core.haddock
haddock-html:         /usr/share/doc/haskell-sop-core/html
' | '/usr/bin/ghc-pkg' 'update' '--force' '-' '--global' '--no-user-package-db' "$@"

