#!/bin/sh
export PATH='/usr/local/sbin:/usr/local/bin:/usr/bin:/usr/bin/site_perl:/usr/bin/vendor_perl:/usr/bin/core_perl'
echo 'name:                 statistics
version:              0.16.2.0
visibility:           public
id:                   statistics-0.16.2.0-8ibfNk5wspdJbP5qZcQTBY
key:                  statistics-0.16.2.0-8ibfNk5wspdJbP5qZcQTBY
license:              BSD-2-Clause
copyright:            2009-2014 Bryan O'\''Sullivan
maintainer:           Alexey Khudaykov <alexey.skladnoy@gmail.com>
author:
    Bryan O'\''Sullivan <bos@serpentine.com>, Alexey Khudaykov <alexey.skladnoy@gmail.com>

homepage:             https://github.com/haskell/statistics
synopsis:             A library of statistical types, data, and functions
description:
    This library provides a number of common functions and types useful
    in statistics.  We focus on high performance, numerical robustness,
    and use of good algorithms.  Where possible, we provide
    references to the statistical literature.

    The library'\''s facilities can be divided into four broad categories:

    * Working with widely used discrete and continuous probability
    distributions.  (There are dozens of exotic distributions in use;
    we focus on the most common.)

    * Computing with sample data: quantile estimation, kernel density
    estimation, histograms, bootstrap methods, significance testing,
    and regression and autocorrelation analysis.

    * Random variate generation under several different distributions.

    * Common statistical tests for significant differences between
    samples.

category:             Math, Statistics
abi:                  fd740a75f2a88014dd3f6d75428786b4
exposed:              True
exposed-modules:
    Statistics.Autocorrelation Statistics.ConfidenceInt
    Statistics.Correlation Statistics.Correlation.Kendall
    Statistics.Distribution Statistics.Distribution.Beta
    Statistics.Distribution.Binomial
    Statistics.Distribution.CauchyLorentz
    Statistics.Distribution.ChiSquared
    Statistics.Distribution.DiscreteUniform
    Statistics.Distribution.Exponential
    Statistics.Distribution.FDistribution Statistics.Distribution.Gamma
    Statistics.Distribution.Geometric
    Statistics.Distribution.Hypergeometric
    Statistics.Distribution.Laplace Statistics.Distribution.Lognormal
    Statistics.Distribution.NegativeBinomial
    Statistics.Distribution.Normal Statistics.Distribution.Poisson
    Statistics.Distribution.StudentT Statistics.Distribution.Transform
    Statistics.Distribution.Uniform Statistics.Distribution.Weibull
    Statistics.Function Statistics.Quantile Statistics.Regression
    Statistics.Resampling Statistics.Resampling.Bootstrap
    Statistics.Sample Statistics.Sample.Histogram
    Statistics.Sample.Internal Statistics.Sample.KernelDensity
    Statistics.Sample.KernelDensity.Simple Statistics.Sample.Normalize
    Statistics.Sample.Powers Statistics.Test.ChiSquared
    Statistics.Test.KolmogorovSmirnov Statistics.Test.KruskalWallis
    Statistics.Test.MannWhitneyU Statistics.Test.StudentT
    Statistics.Test.Types Statistics.Test.WilcoxonT
    Statistics.Transform Statistics.Types

hidden-modules:
    Statistics.Distribution.Poisson.Internal Statistics.Internal
    Statistics.Test.Internal Statistics.Types.Internal

import-dirs:          /usr/lib/ghc-9.0.2/site-local/statistics-0.16.2.0
library-dirs:         /usr/lib/ghc-9.0.2/site-local/statistics-0.16.2.0
dynamic-library-dirs: /usr/lib
data-dir:             /usr/share/haskell-statistics
hs-libraries:         HSstatistics-0.16.2.0-8ibfNk5wspdJbP5qZcQTBY
depends:
    aeson-2.1.2.1-A4BCifdqKBRKymWAxMJ7G4
    async-2.2.4-FN1EWRVHp3S4oHdBJm7ot4 base-4.15.1.0 binary-0.8.8.0
    data-default-class-0.1.2.0-IxhEAzgy8931aXcEiJcyZO deepseq-1.4.5.0
    dense-linear-algebra-0.1.0.0-6GcPUW2i60G4S8U2iD4aKE
    math-functions-0.3.4.2-4X5leqErMg2JXn1eW69G9r
    mwc-random-0.15.0.2-LcgFDXKxrBg3pQAS28VrYq
    parallel-3.2.2.0-D2aleEa2VnPBr164BdKnms
    primitive-0.7.4.0-8RUdbvjRYjOFHQ1vgzaS7Q
    random-1.2.1.1-K0OGGZ2RgxUBJhcMzCddDt
    vector-0.13.0.0-9fyHsAonVFcGYv9jtLmfSh
    vector-algorithms-0.9.0.1-IWEGUyHMHM2Cn97qPsfmB2
    vector-binary-instances-0.2.5.2-FkMHYNFVClkB8qKie4frAy
    vector-th-unbox-0.2.2-BzytA5IURW318pwFTdTjxj

haddock-interfaces:   /usr/share/doc/haskell-statistics/html/statistics.haddock
haddock-html:         /usr/share/doc/haskell-statistics/html
' | '/usr/bin/ghc-pkg' 'update' '--force' '-' '--global' '--no-user-package-db' "$@"

