#!/bin/sh
export PATH='/usr/local/sbin:/usr/local/bin:/usr/bin:/usr/bin/site_perl:/usr/bin/vendor_perl:/usr/bin/core_perl'
echo 'name:                 storablevector
version:              0.2.13.1
visibility:           public
id:                   storablevector-0.2.13.1-9cocD9LBPT74i5LFu0AV64
key:                  storablevector-0.2.13.1-9cocD9LBPT74i5LFu0AV64
license:              BSD-3-Clause
maintainer:           Henning Thielemann <storablevector@henning-thielemann.de>
author:
    Spencer Janssen <sjanssen@cse.unl.edu>, Henning Thielemann <storablevector@henning-thielemann.de>

stability:            Experimental
homepage:             http://www.haskell.org/haskellwiki/Storable_Vector
synopsis:
    Fast, packed, strict storable arrays with a list interface like ByteString

description:
    Fast, packed, strict storable arrays
    with a list interface,
    a chunky lazy list interface with variable chunk size
    and an interface for write access via the @ST@ monad.
    This is much like @bytestring@ and @binary@
    but can be used for every '\''Foreign.Storable.Storable'\'' type.
    See also package
    <http://hackage.haskell.org/package/vector>
    with a similar intention.

    We do not provide advanced fusion optimization,
    since especially for lazy vectors
    this would either be incorrect or not applicable.
    However we provide fusion with lazy lists in the package
    <http://hackage.haskell.org/package/storablevector-streamfusion>.

category:             Data
abi:                  0924eecfa473f261a9137c305b63099a
exposed:              True
exposed-modules:
    Data.StorableVector Data.StorableVector.Base
    Data.StorableVector.Lazy Data.StorableVector.Lazy.Builder
    Data.StorableVector.Lazy.Pattern Data.StorableVector.Lazy.Pointer
    Data.StorableVector.Lazy.Typed Data.StorableVector.Pointer
    Data.StorableVector.ST.Lazy Data.StorableVector.ST.Strict

hidden-modules:
    Data.StorableVector.Memory Data.StorableVector.ST.Private
    Data.StorableVector.Lazy.PointerPrivate
    Data.StorableVector.Lazy.PointerPrivateIndex
    Data.StorableVector.Cursor

import-dirs:          /usr/lib/ghc-9.0.2/site-local/storablevector-0.2.13.1
library-dirs:         /usr/lib/ghc-9.0.2/site-local/storablevector-0.2.13.1
dynamic-library-dirs: /usr/lib
data-dir:             /usr/share/haskell-storablevector
hs-libraries:         HSstorablevector-0.2.13.1-9cocD9LBPT74i5LFu0AV64
depends:
    QuickCheck-2.14.3-1OE8Tk6Cvw85tkUdApuCR4 base-4.15.1.0
    deepseq-1.4.5.0 non-negative-0.1.2-DWUm9QVaxcJI8ViPgzQRdd
    syb-0.7.2.3-ItYotKJTU3VJfC5cskyLmn transformers-0.5.6.2
    unsafe-0.0-L6UZ6pDyVqJF3P5J7oCvq2
    utility-ht-0.0.17-DtYMSclNOzMELYOP9ZYsSE

haddock-interfaces:
    /usr/share/doc/haskell-storablevector/html/storablevector.haddock

haddock-html:         /usr/share/doc/haskell-storablevector/html
' | '/usr/bin/ghc-pkg' 'update' '--force' '-' '--global' '--no-user-package-db' "$@"

