#!/bin/sh
export PATH='/usr/local/sbin:/usr/local/bin:/usr/bin:/usr/bin/site_perl:/usr/bin/vendor_perl:/usr/bin/core_perl'
echo 'name:                 strict
version:              0.4.0.1
visibility:           public
id:                   strict-0.4.0.1-DqIvrYJvHoWHqER1V0TQ0H
key:                  strict-0.4.0.1-DqIvrYJvHoWHqER1V0TQ0H
license:              BSD-3-Clause
copyright:
    (c) 2006-2008 by Roman Leshchinskiy
    (c) 2013-2014 by Simon Meier

maintainer:
    Don Stewart <dons@galois.com>,
    Bas van Dijk <v.dijk.bas@gmail.com>,
    Oleg Grenrus <oleg.grenrus@iki.fi>,
    Simon Meier <iridcode@gmail.com>,
    Ximin Luo <infinity0@pwned.gg>

author:
    Roman Leshchinskiy <rl@cse.unsw.edu.au>
    Simon Meier <iridcode@gmail.com>

homepage:             https://github.com/haskell-strict/strict
synopsis:             Strict data types and String IO.
description:
    This package provides strict versions of some standard Haskell data
    types (pairs, Maybe and Either). It also contains strict IO operations.

    It is common knowledge that lazy datastructures can lead to space-leaks.
    This problem is particularly prominent, when using lazy datastructures to
    store the state of a long-running application in memory. One common
    solution to this problem is to use @seq@ and its variants in every piece of
    code that updates your state. However a much easier solution is to use
    fully strict types to store such state values. By \"fully strict types\" we
    mean types for whose values it holds that, if they are in weak-head normal
    form, then they are also in normal form. Intuitively, this means that
    values of fully strict types cannot contain unevaluated thunks.

    To define a fully strict datatype, one typically uses the following recipe.

    1. Make all fields of every constructor strict; i.e., add a bang to
    all fields.

    2. Use only strict types for the fields of the constructors.

    The second requirement is problematic as it rules out the use of
    the standard Haskell '\''Maybe'\'', '\''Either'\'', and pair types. This library
    solves this problem by providing strict variants of these types and their
    corresponding standard support functions and type-class instances.

    Note that this library does currently not provide fully strict lists.
    They can be added if they are really required. However, in many cases one
    probably wants to use unboxed or strict boxed vectors from the '\''vector'\''
    library (<http://hackage.haskell.org/package/vector>) instead of strict
    lists.  Moreover, instead of @String@s one probably wants to use strict
    @Text@ values from the @text@ library
    (<http://hackage.haskell.org/package/text>).

    This library comes with batteries included; i.e., mirror functions and
    instances of the lazy versions in @base@. It also includes instances for
    type-classes from the @deepseq@, @binary@, and @hashable@ packages.

category:             Data, System
abi:                  5b399d3a354dbdd3801aff3da4309af4
exposed:              True
exposed-modules:
    Data.Strict Data.Strict.Classes Data.Strict.Either
    Data.Strict.Maybe Data.Strict.These Data.Strict.Tuple
    System.IO.Strict

import-dirs:          /usr/lib/ghc-9.0.2/site-local/strict-0.4.0.1
library-dirs:         /usr/lib/ghc-9.0.2/site-local/strict-0.4.0.1
dynamic-library-dirs: /usr/lib
data-dir:             /usr/share/haskell-strict
hs-libraries:         HSstrict-0.4.0.1-DqIvrYJvHoWHqER1V0TQ0H
depends:
    assoc-1.0.2-2XMofMeCFM4GQHAP0AijVK base-4.15.1.0 binary-0.8.8.0
    bytestring-0.10.12.1 deepseq-1.4.5.0 ghc-prim-0.7.0
    hashable-1.4.2.0-8JSq7I7AhyyZ2Q90BxZWW text-1.2.5.0
    these-1.1.1.1-Co8qfzI8wtgJaT0RN5FqXo transformers-0.5.6.2

haddock-interfaces:   /usr/share/doc/haskell-strict/html/strict.haddock
haddock-html:         /usr/share/doc/haskell-strict/html
' | '/usr/bin/ghc-pkg' 'update' '--force' '-' '--global' '--no-user-package-db' "$@"

