#!/bin/sh
export PATH='/usr/local/sbin:/usr/local/bin:/usr/bin:/usr/bin/site_perl:/usr/bin/vendor_perl:/usr/bin/core_perl'
echo 'name:                 tamarin-prover-term
version:              1.8.0
visibility:           public
id:                   tamarin-prover-term-1.8.0-26RF66IQCxVBmJOFzW37dk
key:                  tamarin-prover-term-1.8.0-26RF66IQCxVBmJOFzW37dk
license:              LicenseRef-GPL
copyright:
    Benedikt Schmidt, Simon Meier, Cas Cremers, Jannik Dreier, Ralf Sasse, 2010-2023

maintainer:
    Cas Cremers <cremers@cispa.de>,
    Jannik Dreier <research@jannikdreier.net>,
    Ralf Sasse <ralf.sasse@gmail.com>

author:
    Benedikt Schmidt <benedikt.schmidt@inf.ethz.ch>,
    Simon Meier <simon.meier@inf.ethz.ch>,
    Jannik Dreier <research@jannikdreier.net>,
    Ralf Sasse <ralf.sasse@gmail.com>

homepage:             https://tamarin-prover.github.io/
synopsis:             Term manipulation library for the tamarin prover.
description:
    This is an internal library of the Tamarin prover for
    security protocol verification
    (<hackage.haskell.org/package/tamarin-prover>).

    This library provides term manipulation infrastructure
    (matching, unification, narrowing, finite variants) for
    the Tamarin prover. It uses maude
    (<http://maude.cs.uiuc.edu/>) as a backend for
    normalization, equational matching, and unification.

category:             Theorem Provers
abi:                  d02ea6e5dc944042486f8e50e3085b5c
exposed:              True
exposed-modules:
    Term.Builtin.Convenience Term.Builtin.Rules Term.Builtin.Signature
    Term.LTerm Term.Macro Term.Maude.Parser Term.Maude.Process
    Term.Maude.Signature Term.Maude.Types Term.Narrowing.Variants
    Term.Narrowing.Variants.Check Term.Narrowing.Variants.Compute
    Term.Positions Term.Rewriting.Definitions Term.Rewriting.Norm
    Term.Substitution Term.Subsumption Term.SubtermRule
    Term.Unification Term.UnitTests Term.VTerm

hidden-modules:
    Term.Term Term.Term.Classes Term.Term.Raw Term.Term.FunctionSymbols
    Term.Narrowing.Narrow Term.Substitution.SubstVFree
    Term.Substitution.SubstVFresh

import-dirs:          /usr/lib/ghc-9.0.2/site-local/tamarin-prover-term-1.8.0
library-dirs:         /usr/lib/ghc-9.0.2/site-local/tamarin-prover-term-1.8.0
dynamic-library-dirs: /usr/lib
data-dir:             /usr/share/haskell-tamarin-prover-term
hs-libraries:         HStamarin-prover-term-1.8.0-26RF66IQCxVBmJOFzW37dk
depends:
    HUnit-1.6.2.0-JGxgr0O3qDr2sR1C0CRfuz
    attoparsec-0.14.4-4fjJnHqpy2x7zsjAU0XRWO base-4.15.1.0
    binary-0.8.8.0 bytestring-0.10.12.1 containers-0.6.4.1
    deepseq-1.4.5.0 dlist-1.0-JalAZsGq1LOCqqdFHHEpoL mtl-2.2.2
    process-1.6.13.2 safe-0.3.19-2aVM1fCfxX88jnlVeNbd8Q
    tamarin-prover-utils-1.8.0-CDzpAIAHPOg4xkld6EbFez

haddock-interfaces:
    /usr/share/doc/haskell-tamarin-prover-term/html/tamarin-prover-term.haddock

haddock-html:         /usr/share/doc/haskell-tamarin-prover-term/html
' | '/usr/bin/ghc-pkg' 'update' '--force' '-' '--global' '--no-user-package-db' "$@"

