#!/bin/sh
export PATH='/usr/local/sbin:/usr/local/bin:/usr/bin:/usr/bin/site_perl:/usr/bin/vendor_perl:/usr/bin/core_perl'
echo 'name:                 tasty
version:              1.4.3
visibility:           public
id:                   tasty-1.4.3-F5jS0TcPgL077vxy1alhqa
key:                  tasty-1.4.3-F5jS0TcPgL077vxy1alhqa
license:              MIT
maintainer:           Roman Cheplyaka <roma@ro-che.info>
author:               Roman Cheplyaka <roma@ro-che.info>
homepage:             https://github.com/UnkindPartition/tasty
synopsis:             Modern and extensible testing framework
description:
    Tasty is a modern testing framework for Haskell.
    It lets you combine your unit tests, golden
    tests, QuickCheck/SmallCheck properties, and any
    other types of tests into a single test suite.

category:             Testing
abi:                  b04c86466721ebf4f591fa108acf3c02
exposed:              True
exposed-modules:
    Test.Tasty Test.Tasty.Ingredients Test.Tasty.Ingredients.Basic
    Test.Tasty.Ingredients.ConsoleReporter Test.Tasty.Options
    Test.Tasty.Patterns.Eval Test.Tasty.Patterns.Parser
    Test.Tasty.Patterns.Printer Test.Tasty.Patterns.Types
    Test.Tasty.Providers Test.Tasty.Providers.ConsoleFormat
    Test.Tasty.Runners

hidden-modules:
    Control.Concurrent.Async Test.Tasty.Parallel Test.Tasty.Core
    Test.Tasty.Options.Core Test.Tasty.Options.Env Test.Tasty.Patterns
    Test.Tasty.Patterns.Expr Test.Tasty.Run Test.Tasty.Runners.Reducers
    Test.Tasty.Runners.Utils Test.Tasty.CmdLine
    Test.Tasty.Ingredients.ListTests
    Test.Tasty.Ingredients.IncludingOptions

import-dirs:          /usr/lib/ghc-9.0.2/site-local/tasty-1.4.3
library-dirs:         /usr/lib/ghc-9.0.2/site-local/tasty-1.4.3
dynamic-library-dirs: /usr/lib
data-dir:             /usr/share/haskell-tasty
hs-libraries:         HStasty-1.4.3-F5jS0TcPgL077vxy1alhqa
depends:
    ansi-terminal-0.11.4-30w7KBHfEQ9CygddjSQvBk base-4.15.1.0
    containers-0.6.4.1
    optparse-applicative-0.17.0.0-1t7fxkFVvXn4R1Ycov0fb stm-2.5.0.0
    tagged-0.8.7-8MQxDldL1qw9fJF5LZxnpf transformers-0.5.6.2
    unix-2.7.2.2

haddock-interfaces:   /usr/share/doc/haskell-tasty/html/tasty.haddock
haddock-html:         /usr/share/doc/haskell-tasty/html
' | '/usr/bin/ghc-pkg' 'update' '--force' '-' '--global' '--no-user-package-db' "$@"

