#!/bin/sh
export PATH='/usr/local/sbin:/usr/local/bin:/usr/bin:/usr/bin/site_perl:/usr/bin/vendor_perl:/usr/bin/core_perl'
echo 'name:                 tdigest
version:              0.2.1.1
visibility:           public
id:                   tdigest-0.2.1.1-9cLDPy9eN4s2XgC8QPBhms
key:                  tdigest-0.2.1.1-9cLDPy9eN4s2XgC8QPBhms
license:              BSD-3-Clause
maintainer:           Oleg Grenrus <oleg.grenrus@iki.fi>
author:               Oleg Grenrus <oleg.grenrus@iki.fi>
homepage:             https://github.com/phadej/haskell-tdigest#readme
synopsis:             On-line accumulation of rank-based statistics
description:
    A new data structure for accurate on-line accumulation of rank-based statistics such as quantiles and trimmed means.

    See original paper: "Computing extremely accurate quantiles using t-digest" by Ted Dunning and Otmar Ertl
    for more details <https://github.com/tdunning/t-digest/blob/07b8f2ca2be8d0a9f04df2feadad5ddc1bb73c88/docs/t-digest-paper/histo.pdf>.

category:             Numeric
abi:                  b72cda3707a94df4f0b1ed09a72eb6b0
exposed:              True
exposed-modules:
    Data.TDigest Data.TDigest.Internal Data.TDigest.NonEmpty
    Data.TDigest.Postprocess Data.TDigest.Postprocess.Internal
    Data.TDigest.Tree Data.TDigest.Tree.Internal
    Data.TDigest.Tree.NonEmpty Data.TDigest.Tree.Postprocess
    Data.TDigest.Vector Data.TDigest.Vector.Internal
    Data.TDigest.Vector.NonEmpty Data.TDigest.Vector.Postprocess

import-dirs:          /usr/lib/ghc-9.0.2/site-local/tdigest-0.2.1.1
library-dirs:         /usr/lib/ghc-9.0.2/site-local/tdigest-0.2.1.1
dynamic-library-dirs: /usr/lib
data-dir:             /usr/share/haskell-tdigest
hs-libraries:         HStdigest-0.2.1.1-9cLDPy9eN4s2XgC8QPBhms
depends:
    base-4.15.1.0 base-compat-0.12.2-l1EqrM7Qwu6Pq9d4drKFu
    binary-0.8.8.0 deepseq-1.4.5.0
    reducers-3.12.4-V1bfmq3iEM1gY1n38U5fT
    semigroupoids-5.3.7-KA0YT7sGVtk8p8u4maj8I2 transformers-0.5.6.2
    vector-0.13.0.0-9fyHsAonVFcGYv9jtLmfSh
    vector-algorithms-0.9.0.1-IWEGUyHMHM2Cn97qPsfmB2

haddock-interfaces:   /usr/share/doc/haskell-tdigest/html/tdigest.haddock
haddock-html:         /usr/share/doc/haskell-tdigest/html
' | '/usr/bin/ghc-pkg' 'update' '--force' '-' '--global' '--no-user-package-db' "$@"

