#!/bin/sh
export PATH='/usr/local/sbin:/usr/local/bin:/usr/bin:/usr/bin/site_perl:/usr/bin/vendor_perl:/usr/bin/core_perl'
echo 'name:                 texmath
version:              0.12.8
visibility:           public
id:                   texmath-0.12.8-6OCaXhq3cf84zh5PWgN9fl
key:                  texmath-0.12.8-6OCaXhq3cf84zh5PWgN9fl
license:              GPL-2.0-only
maintainer:           jgm@berkeley.edu
author:               John MacFarlane, Matthew Pickering
stability:            Experimental
homepage:             http://github.com/jgm/texmath
synopsis:             Conversion between math formats.
description:
    The texmath library provides functions to read
    and write TeX math, presentation MathML, and OMML (Office
    Math Markup Language, used in Microsoft Office).  Support is also
    included for converting math formats to Gnu eqn, typst, and pandoc'\''s
    native format (allowing conversion, via pandoc, to a variety of
    different markup formats).  The TeX reader supports basic LaTeX
    and AMS extensions, and it can parse and apply LaTeX macros.
    (See <https://johnmacfarlane.net/texmath here> for a live demo of
    bidirectional conversion between LaTeX and MathML.)

    The package also includes several utility modules which may be
    useful for anyone looking to manipulate either TeX math or
    MathML.  For example, a copy of the MathML operator dictionary is
    included.

    Use the @executable@ flag to install a standalone
    executable, @texmath@, that converts formulas from one
    format to another. (Use the @--help@ flag for a description of all
    functionality).

    Use the @server@ flag to install a web server, @texmath-server@,
    that exposes a JSON API allowing conversion of individual
    formulas and batches of formulas.

category:             Text
abi:                  e6429c59a581dda71a1b78c5382994e9
exposed:              True
exposed-modules:
    Text.TeXMath Text.TeXMath.Readers.MathML
    Text.TeXMath.Readers.MathML.EntityMap
    Text.TeXMath.Readers.MathML.MMLDict Text.TeXMath.Readers.OMML
    Text.TeXMath.Readers.TeX Text.TeXMath.Readers.TeX.Macros
    Text.TeXMath.Shared Text.TeXMath.TeX Text.TeXMath.Types
    Text.TeXMath.Unicode.Fonts Text.TeXMath.Unicode.ToTeX
    Text.TeXMath.Unicode.ToUnicode Text.TeXMath.Writers.Eqn
    Text.TeXMath.Writers.MathML Text.TeXMath.Writers.OMML
    Text.TeXMath.Writers.Pandoc Text.TeXMath.Writers.TeX
    Text.TeXMath.Writers.Typst

hidden-modules:       Text.TeXMath.Readers.TeX.Commands Paths_texmath
import-dirs:          /usr/lib/ghc-9.0.2/site-local/texmath-0.12.8
library-dirs:         /usr/lib/ghc-9.0.2/site-local/texmath-0.12.8
dynamic-library-dirs: /usr/lib
data-dir:             /usr/share/x86_64-linux-ghc-9.0.2/texmath-0.12.8
hs-libraries:         HStexmath-0.12.8-6OCaXhq3cf84zh5PWgN9fl
depends:
    base-4.15.1.0 containers-0.6.4.1 mtl-2.2.2
    pandoc-types-1.23-8T5BFSbkNLg9H6oAOnuVjk parsec-3.1.14.0
    split-0.2.3.5-2QcOUxLgyp8IUTikrwTasf
    syb-0.7.2.3-ItYotKJTU3VJfC5cskyLmn text-1.2.5.0
    typst-symbols-0.1.2-ABpKFSlfFVPEMuyaNAU1ZA
    xml-1.3.14-6hlhhPBptprHwK7nsE7OzM

haddock-interfaces:   /usr/share/doc/haskell-texmath/html/texmath.haddock
haddock-html:         /usr/share/doc/haskell-texmath/html
' | '/usr/bin/ghc-pkg' 'update' '--force' '-' '--global' '--no-user-package-db' "$@"

