#!/bin/sh
export PATH='/usr/local/sbin:/usr/local/bin:/usr/bin:/usr/bin/site_perl:/usr/bin/vendor_perl:/usr/bin/core_perl'
echo 'name:                 text-show
version:              3.10.2
visibility:           public
id:                   text-show-3.10.2-9O70kFCgX0O4E5oQqwJQtZ
key:                  text-show-3.10.2-9O70kFCgX0O4E5oQqwJQtZ
license:              BSD-3-Clause
copyright:            (C) 2014-2017 Ryan Scott
maintainer:           Ryan Scott <ryan.gl.scott@gmail.com>
author:               Ryan Scott
stability:            Provisional
homepage:             https://github.com/RyanGlScott/text-show
synopsis:             Efficient conversion of values into Text
description:
    @text-show@ offers a replacement for the @Show@ typeclass intended
    for use with @Text@ instead of @String@s. This package was created
    in the spirit of
    @<http://hackage.haskell.org/package/bytestring-show bytestring-show>@.

    At the moment, @text-show@ provides instances for most data
    types in the @<http://hackage.haskell.org/package/array array>@,
    @<http://hackage.haskell.org/package/base base>@,
    @<http://hackage.haskell.org/package/bytestring bytestring>@, and
    @<http://hackage.haskell.org/package/text text>@ packages.
    Therefore, much of the source code for @text-show@ consists of
    borrowed code from those packages in order to ensure that the
    behaviors of @Show@ and @TextShow@ coincide.

    For most uses, simply importing "TextShow"
    will suffice:

    @
    module Main where

    import TextShow

    main :: IO ()
    main = printT (Just \"Hello, World!\")
    @

    See also the
    <https://github.com/RyanGlScott/text-show/wiki/Naming-conventions naming conventions>
    page.

    Support for automatically deriving @TextShow@ instances can be found
    in the "TextShow.TH" and "TextShow.Generic" modules.

category:             Text
abi:                  a4b65baaaf83c5882ab8eca1da98ce79
exposed:              True
exposed-modules:
    TextShow TextShow.Control.Applicative TextShow.Control.Concurrent
    TextShow.Control.Exception TextShow.Control.Monad.ST
    TextShow.Data.Array TextShow.Data.Array.Byte TextShow.Data.Bool
    TextShow.Data.ByteString TextShow.Data.Char TextShow.Data.Complex
    TextShow.Data.Data TextShow.Data.Dynamic TextShow.Data.Either
    TextShow.Data.Fixed TextShow.Data.Floating
    TextShow.Data.Functor.Compose TextShow.Data.Functor.Identity
    TextShow.Data.Functor.Product TextShow.Data.Functor.Sum
    TextShow.Data.Integral TextShow.Data.List
    TextShow.Data.List.NonEmpty TextShow.Data.Maybe
    TextShow.Data.Monoid TextShow.Data.OldTypeable TextShow.Data.Ord
    TextShow.Data.Proxy TextShow.Data.Ratio TextShow.Data.Semigroup
    TextShow.Data.Text TextShow.Data.Tuple TextShow.Data.Type.Coercion
    TextShow.Data.Type.Equality TextShow.Data.Typeable
    TextShow.Data.Version TextShow.Data.Void TextShow.Debug.Trace
    TextShow.Debug.Trace.Generic TextShow.Debug.Trace.TH
    TextShow.Foreign.C.Types TextShow.Foreign.Ptr TextShow.Functions
    TextShow.GHC.Conc.Windows TextShow.GHC.Event
    TextShow.GHC.Fingerprint TextShow.GHC.Generics
    TextShow.GHC.RTS.Flags TextShow.GHC.Stack TextShow.GHC.StaticPtr
    TextShow.GHC.Stats TextShow.GHC.TypeLits TextShow.Generic
    TextShow.Numeric.Natural TextShow.System.Exit TextShow.System.IO
    TextShow.System.Posix.Types TextShow.TH TextShow.Text.Read

hidden-modules:
    TextShow.Classes TextShow.Data.Typeable.Utils
    TextShow.FromStringTextShow TextShow.Instances TextShow.Options
    TextShow.TH.Internal TextShow.TH.Names TextShow.Utils

import-dirs:          /usr/lib/ghc-9.0.2/site-local/text-show-3.10.2
library-dirs:         /usr/lib/ghc-9.0.2/site-local/text-show-3.10.2
dynamic-library-dirs: /usr/lib
data-dir:             /usr/share/haskell-text-show
hs-libraries:         HStext-show-3.10.2-9O70kFCgX0O4E5oQqwJQtZ
includes:             generic.h
depends:
    array-0.5.4.0 base-4.15.1.0
    base-compat-batteries-0.12.2-AT4hp2TNkcP3aSTeYrld5l
    bifunctors-5.5.15-3KMbabBcAMBDp1F0CEHRh3 bytestring-0.10.12.1
    containers-0.6.4.1 generic-deriving-1.14.5-KN8nYmoNSxp3sMjobR4V2W
    ghc-boot-th-9.0.2 ghc-prim-0.7.0 template-haskell-2.17.0.0
    text-1.2.5.0 th-abstraction-0.4.5.0-CPrpKcr2W2S31K8QsJKgDp
    th-lift-0.8.4-4cyXLgXzVomInnuNEFv3vJ transformers-0.5.6.2
    transformers-compat-0.7.2-ZzSHjvD4flB2ChCq5TVbH

haddock-interfaces:   /usr/share/doc/haskell-text-show/html/text-show.haddock
haddock-html:         /usr/share/doc/haskell-text-show/html
' | '/usr/bin/ghc-pkg' 'update' '--force' '-' '--global' '--no-user-package-db' "$@"

