#!/bin/sh
export PATH='/usr/local/sbin:/usr/local/bin:/usr/bin:/usr/bin/site_perl:/usr/bin/vendor_perl:/usr/bin/core_perl'
echo 'name:                 tidal
version:              1.9.4
visibility:           public
id:                   tidal-1.9.4-3yTrg4C0qJzBPrdMU9rGl8
key:                  tidal-1.9.4-3yTrg4C0qJzBPrdMU9rGl8
license:              GPL-3.0-only
copyright:            (c) Alex McLean and other contributors, 2021
maintainer:
    Alex McLean <alex@slab.org>, Mike Hodnick <mike.hodnick@gmail.com>

author:               Alex McLean
stability:            Experimental
homepage:             http://tidalcycles.org/
synopsis:             Pattern language for improvised music
description:
    Tidal is a domain specific language for live coding patterns.

category:             Sound
abi:                  bfae207f4742799537c2e521e842d1be
exposed:              True
exposed-modules:
    Paths_tidal Sound.Tidal.Bjorklund Sound.Tidal.Chords
    Sound.Tidal.Config Sound.Tidal.Context Sound.Tidal.Control
    Sound.Tidal.Core Sound.Tidal.ID Sound.Tidal.Params
    Sound.Tidal.ParseBP Sound.Tidal.Pattern Sound.Tidal.Safe.Boot
    Sound.Tidal.Safe.Context Sound.Tidal.Scales Sound.Tidal.Show
    Sound.Tidal.Simple Sound.Tidal.Stream Sound.Tidal.StreamTypes
    Sound.Tidal.Tempo Sound.Tidal.Time Sound.Tidal.Transition
    Sound.Tidal.UI Sound.Tidal.Utils Sound.Tidal.Version

import-dirs:          /usr/lib/ghc-9.0.2/site-local/tidal-1.9.4
library-dirs:         /usr/lib/ghc-9.0.2/site-local/tidal-1.9.4
dynamic-library-dirs: /usr/lib
data-dir:             /usr/share/haskell-tidal
hs-libraries:         HStidal-1.9.4-3yTrg4C0qJzBPrdMU9rGl8
depends:
    base-4.15.1.0 bytestring-0.10.12.1
    clock-0.8.3-2U80sdDOrjmBlVZLInPGG1
    colour-2.3.6-EuYv2zipv8X3m9Cp1zQHEC containers-0.6.4.1
    deepseq-1.4.5.0 exceptions-0.10.4 hosc-0.20-ERPeZOWScdZ6hav9hXY6O
    mtl-2.2.2 network-3.1.4.0-5PP4MrJJnZZJkybIlRRAPq parsec-3.1.14.0
    primitive-0.7.4.0-8RUdbvjRYjOFHQ1vgzaS7Q
    random-1.2.1.1-K0OGGZ2RgxUBJhcMzCddDt text-1.2.5.0
    tidal-link-1.0.1-11erSVDHID8JnduY8ph7Ga transformers-0.5.6.2

haddock-interfaces:   /usr/share/doc/haskell-tidal/html/tidal.haddock
haddock-html:         /usr/share/doc/haskell-tidal/html
' | '/usr/bin/ghc-pkg' 'update' '--force' '-' '--global' '--no-user-package-db' "$@"

