#!/bin/sh
export PATH='/usr/local/sbin:/usr/local/bin:/usr/bin:/usr/bin/site_perl:/usr/bin/vendor_perl:/usr/bin/core_perl'
echo 'name:                 tree-diff
version:              0.3.0.1
visibility:           public
id:                   tree-diff-0.3.0.1-CdGhLpaF0nDK6EPNj0cZMq
key:                  tree-diff-0.3.0.1-CdGhLpaF0nDK6EPNj0cZMq
license:              GPL-2.0-or-later
copyright:            (c) 2017-2021 Oleg Grenrus
maintainer:           Oleg.Grenrus <oleg.grenrus@iki.fi>
author:               Oleg Grenrus <oleg.grenrus@iki.fi>
homepage:             https://github.com/phadej/tree-diff
synopsis:             Diffing of (expression) trees.
description:
    Common diff algorithm works on list structures:

    @
    diff :: Eq a => [a] -> [a] -> [Edit a]
    @

    This package works on trees.

    @
    treeDiff :: Eq a => Tree a -> Tree a -> Edit (EditTree a)
    @

    This package also provides a way to diff arbitrary ADTs,
    using @Generics@-derivable helpers.

    This package differs from <http://hackage.haskell.org/package/gdiff gdiff>,
    in a two ways: @tree-diff@ doesn'\''t have patch function,
    and the "edit-script" is a tree itself, which is useful for pretty-printing.

    @
    >>> prettyEditExpr $ ediff (Foo 42 [True, False] "old") (Foo 42 [False, False, True] "new")
    Foo
    \  {fooBool = [-True, +False, False, +True],
    \   fooInt = 42,
    \   fooString = -"old" +"new"}
    @

category:             Data, Testing
abi:                  c7847d428e8865c7235cb7097d02a207
exposed:              True
exposed-modules:
    Data.TreeDiff Data.TreeDiff.Class Data.TreeDiff.Expr
    Data.TreeDiff.Golden Data.TreeDiff.List Data.TreeDiff.OMap
    Data.TreeDiff.Parser Data.TreeDiff.Pretty Data.TreeDiff.QuickCheck
    Data.TreeDiff.Tree

import-dirs:          /usr/lib/ghc-9.0.2/site-local/tree-diff-0.3.0.1
library-dirs:         /usr/lib/ghc-9.0.2/site-local/tree-diff-0.3.0.1
dynamic-library-dirs: /usr/lib
data-dir:             /usr/share/haskell-tree-diff
hs-libraries:         HStree-diff-0.3.0.1-CdGhLpaF0nDK6EPNj0cZMq
depends:
    QuickCheck-2.14.3-1OE8Tk6Cvw85tkUdApuCR4
    aeson-2.1.2.1-A4BCifdqKBRKymWAxMJ7G4
    ansi-terminal-0.11.4-30w7KBHfEQ9CygddjSQvBk
    ansi-wl-pprint-0.6.9-3bScAiBbugl4HhJOdwJ4J8 base-4.15.1.0
    base-compat-0.12.2-l1EqrM7Qwu6Pq9d4drKFu bytestring-0.10.12.1
    containers-0.6.4.1 data-array-byte-0.1.0.1-IF8Rfu0RHop768CiMVoPta
    deepseq-1.4.5.0 hashable-1.4.2.0-8JSq7I7AhyyZ2Q90BxZWW
    parsec-3.1.14.0 parsers-0.12.11-4GlGGJopDxbEBWyVDgDjI4
    pretty-1.1.3.6 primitive-0.7.4.0-8RUdbvjRYjOFHQ1vgzaS7Q
    scientific-0.3.7.0-6CvCEFxXBWR5nYRp7k6pyR
    semialign-1.2.0.1-L3HiqIPbIDwG6hqCRiIHhY
    strict-0.4.0.1-DqIvrYJvHoWHqER1V0TQ0H
    tagged-0.8.7-8MQxDldL1qw9fJF5LZxnpf text-1.2.5.0
    these-1.1.1.1-Co8qfzI8wtgJaT0RN5FqXo time-1.9.3
    unordered-containers-0.2.19.1-Km0aDxhChoIJJSbiufyazz
    uuid-types-1.0.5-7u50b6xgE4NKbeFi1oGinA
    vector-0.13.0.0-9fyHsAonVFcGYv9jtLmfSh

haddock-interfaces:   /usr/share/doc/haskell-tree-diff/html/tree-diff.haddock
haddock-html:         /usr/share/doc/haskell-tree-diff/html
' | '/usr/bin/ghc-pkg' 'update' '--force' '-' '--global' '--no-user-package-db' "$@"

