#!/bin/sh
export PATH='/usr/local/sbin:/usr/local/bin:/usr/bin:/usr/bin/site_perl:/usr/bin/vendor_perl:/usr/bin/core_perl'
echo 'name:                 trifecta
version:              2.1.2
visibility:           public
id:                   trifecta-2.1.2-5Sfhi53tOGvDYH07jJUzrl
key:                  trifecta-2.1.2-5Sfhi53tOGvDYH07jJUzrl
license:              BSD-3-Clause
copyright:            Copyright (C) 2010-2017 Edward A. Kmett
maintainer:           Edward A. Kmett <ekmett@gmail.com>
author:               Edward A. Kmett
stability:            experimental
homepage:             http://github.com/ekmett/trifecta/
synopsis:
    A modern parser combinator library with convenient diagnostics

description:
    A modern parser combinator library with slicing and Clang-style colored diagnostics

    For example:

    <<https://i.imgur.com/ZyzUSSn.png>>

    <images/example.png (Local Copy)>

category:             Text, Parsing, Diagnostics, Pretty Printer, Logging
abi:                  32c8a7319a1b1f70c51dc4e2b185ccf3
exposed:              True
exposed-modules:
    Text.Trifecta Text.Trifecta.Combinators Text.Trifecta.Delta
    Text.Trifecta.Highlight Text.Trifecta.Parser
    Text.Trifecta.Rendering Text.Trifecta.Result Text.Trifecta.Rope
    Text.Trifecta.Tutorial Text.Trifecta.Util.IntervalMap
    Text.Trifecta.Util.It

hidden-modules:
    Text.Trifecta.Util.Combinators Text.Trifecta.Util.Pretty

import-dirs:          /usr/lib/ghc-9.0.2/site-local/trifecta-2.1.2
library-dirs:         /usr/lib/ghc-9.0.2/site-local/trifecta-2.1.2
dynamic-library-dirs: /usr/lib
data-dir:             /usr/share/haskell-trifecta
hs-libraries:         HStrifecta-2.1.2-5Sfhi53tOGvDYH07jJUzrl
depends:
    ansi-terminal-0.11.4-30w7KBHfEQ9CygddjSQvBk array-0.5.4.0
    base-4.15.1.0 blaze-builder-0.4.2.3-D7RNQqfFzoeIMP5JYaknz9
    blaze-html-0.9.1.2-CjGwhvVZpiI2yqci6C0Ey8
    blaze-markup-0.8.2.8-6v8b9MTZTaSH16HPjvW1LE bytestring-0.10.12.1
    charset-0.3.9-FYcBDCV6ulx8AHLuipfXRV
    comonad-5.0.8-4z7AihQ42OKAJi2EQgp02u containers-0.6.4.1
    deepseq-1.4.5.0 fingertree-0.1.5.0-9moip4KbdSC587KawbetVh
    ghc-prim-0.7.0 hashable-1.4.2.0-8JSq7I7AhyyZ2Q90BxZWW
    indexed-traversable-0.1.2.1-JwIQVWOpW67GVSWDdLo884
    lens-5.2.2-4uj1AepANiF2ook39zjsmk mtl-2.2.2
    parsers-0.12.11-4GlGGJopDxbEBWyVDgDjI4
    prettyprinter-1.7.1-9bwAyMlaUSyJVG7FMXWGKT
    prettyprinter-ansi-terminal-1.1.3-C9dAq9WFsAp2PXcJori7vo
    profunctors-5.6.2-5HBtTiYfVT6KsCqpwzceco
    reducers-3.12.4-V1bfmq3iEM1gY1n38U5fT transformers-0.5.6.2
    unordered-containers-0.2.19.1-Km0aDxhChoIJJSbiufyazz
    utf8-string-1.0.2-519AraujIYSLY3i7TJuoqO

haddock-interfaces:   /usr/share/doc/haskell-trifecta/html/trifecta.haddock
haddock-html:         /usr/share/doc/haskell-trifecta/html
' | '/usr/bin/ghc-pkg' 'update' '--force' '-' '--global' '--no-user-package-db' "$@"

