#!/bin/sh
export PATH='/usr/local/sbin:/usr/local/bin:/usr/bin:/usr/bin/site_perl:/usr/bin/vendor_perl:/usr/bin/core_perl'
echo 'name:                 universe-reverse-instances
version:              1.1.1
visibility:           public
id:                   universe-reverse-instances-1.1.1-B8n20Tnt2TjLVXwqMsJpqO
key:                  universe-reverse-instances-1.1.1-B8n20Tnt2TjLVXwqMsJpqO
license:              BSD-3-Clause
copyright:            Daniel Wagner 2014
maintainer:           me@dmwit.com
author:               Daniel Wagner
homepage:             https://github.com/dmwit/universe
synopsis:
    Instances of standard classes that are made possible by enumerations

description:
    For example this package provides a @Eq (a -> b)@ instance:

    @
    instance (Finite a, Eq b) => Eq (a -> b) where
    f == g = and [f x == g x | x <- universeF]
    @

category:             Data
abi:                  0c969a4a89f937025d90fb4374ae98d7
exposed:              True
exposed-modules:
    Data.Universe.Instances.Eq Data.Universe.Instances.Ord
    Data.Universe.Instances.Read Data.Universe.Instances.Show
    Data.Universe.Instances.Traversable

import-dirs:
    /usr/lib/ghc-9.0.2/site-local/universe-reverse-instances-1.1.1

library-dirs:
    /usr/lib/ghc-9.0.2/site-local/universe-reverse-instances-1.1.1

dynamic-library-dirs: /usr/lib
data-dir:             /usr/share/haskell-universe-reverse-instances
hs-libraries:         HSuniverse-reverse-instances-1.1.1-B8n20Tnt2TjLVXwqMsJpqO
depends:
    base-4.15.1.0 containers-0.6.4.1
    universe-base-1.1.3.1-EGGaoKbtfkjBEOFM7P5P0T

haddock-interfaces:
    /usr/share/doc/haskell-universe-reverse-instances/html/universe-reverse-instances.haddock

haddock-html:         /usr/share/doc/haskell-universe-reverse-instances/html
' | '/usr/bin/ghc-pkg' 'update' '--force' '-' '--global' '--no-user-package-db' "$@"

