#!/bin/sh
export PATH='/usr/local/sbin:/usr/local/bin:/usr/bin:/usr/bin/site_perl:/usr/bin/vendor_perl:/usr/bin/core_perl'
echo 'name:                 vector
version:              0.13.0.0
visibility:           public
id:                   vector-0.13.0.0-9fyHsAonVFcGYv9jtLmfSh
key:                  vector-0.13.0.0-9fyHsAonVFcGYv9jtLmfSh
license:              BSD-3-Clause
copyright:
    (c) Roman Leshchinskiy 2008-2012,
    Alexey Kuleshevich 2020-2022,
    Aleksey Khudyakov 2020-2022,
    Andrew Lelechenko 2020-2022

maintainer:           Haskell Libraries Team <libraries@haskell.org>
author:               Roman Leshchinskiy <rl@cse.unsw.edu.au>
homepage:             https://github.com/haskell/vector
synopsis:             Efficient Arrays
description:

    An efficient implementation of @Int@-indexed arrays (both mutable
    and immutable), with a powerful loop optimisation framework .

    It is structured as follows:

    ["Data.Vector"] Boxed vectors of arbitrary types.

    ["Data.Vector.Unboxed"] Unboxed vectors with an adaptive
    representation based on data type families.

    ["Data.Vector.Storable"] Unboxed vectors of '\''Storable'\'' types.

    ["Data.Vector.Primitive"] Unboxed vectors of primitive types as
    defined by the @primitive@ package. "Data.Vector.Unboxed" is more
    flexible at no performance cost.

    ["Data.Vector.Generic"] Generic interface to the vector types.

    There is also a (draft) tutorial on common uses of vector.

    * <http://haskell.org/haskellwiki/Numeric_Haskell:_A_Vector_Tutorial>

category:             Data, Data Structures
abi:                  fed67f4cfe0f523bb8675494f43ce90a
exposed:              True
exposed-modules:
    Data.Vector Data.Vector.Fusion.Bundle
    Data.Vector.Fusion.Bundle.Monadic Data.Vector.Fusion.Bundle.Size
    Data.Vector.Fusion.Stream.Monadic Data.Vector.Fusion.Util
    Data.Vector.Generic Data.Vector.Generic.Base
    Data.Vector.Generic.Mutable Data.Vector.Generic.Mutable.Base
    Data.Vector.Generic.New Data.Vector.Internal.Check
    Data.Vector.Mutable Data.Vector.Primitive
    Data.Vector.Primitive.Mutable Data.Vector.Storable
    Data.Vector.Storable.Internal Data.Vector.Storable.Mutable
    Data.Vector.Unboxed Data.Vector.Unboxed.Base
    Data.Vector.Unboxed.Mutable

import-dirs:          /usr/lib/ghc-9.0.2/site-local/vector-0.13.0.0
library-dirs:         /usr/lib/ghc-9.0.2/site-local/vector-0.13.0.0
dynamic-library-dirs: /usr/lib
data-dir:             /usr/share/haskell-vector
hs-libraries:         HSvector-0.13.0.0-9fyHsAonVFcGYv9jtLmfSh
include-dirs:         /usr/lib/ghc-9.0.2/site-local/vector-0.13.0.0/include
depends:
    base-4.15.1.0 deepseq-1.4.5.0
    primitive-0.7.4.0-8RUdbvjRYjOFHQ1vgzaS7Q
    vector-stream-0.1.0.0-4waQ7Ba3DNc332rFgBcrBU

haddock-interfaces:   /usr/share/doc/haskell-vector/html/vector.haddock
haddock-html:         /usr/share/doc/haskell-vector/html
' | '/usr/bin/ghc-pkg' 'update' '--force' '-' '--global' '--no-user-package-db' "$@"

