#!/bin/sh
export PATH='/usr/local/sbin:/usr/local/bin:/usr/bin:/usr/bin/site_perl:/usr/bin/vendor_perl:/usr/bin/core_perl'
echo 'name:                 vector-builder
version:              0.3.8.4
visibility:           public
id:                   vector-builder-0.3.8.4-G3b527IoOeM4KrEAtnGKNj
key:                  vector-builder-0.3.8.4-G3b527IoOeM4KrEAtnGKNj
license:              MIT
copyright:            (c) 2016, Nikita Volkov
maintainer:           Nikita Volkov <nikita.y.volkov@mail.ru>
author:               Nikita Volkov <nikita.y.volkov@mail.ru>
homepage:             https://github.com/nikita-volkov/vector-builder
synopsis:             Vector builder
description:
    An API for efficient and convenient construction of vectors.
    It provides the composable `Builder` abstraction, which has instances of the `Monoid` and `Semigroup` classes.

    [Usage]

    First you use the `Builder` abstraction to specify the structure of the vector.
    Then you execute the builder to actually produce the vector.

    [Example]

    The following code shows how you can efficiently concatenate different datastructures into a single immutable vector:

    >
    >import qualified Data.Vector as A
    >import qualified VectorBuilder.Builder as B
    >import qualified VectorBuilder.Vector as C
    >
    >
    >myVector :: A.Vector a -> [a] -> a -> A.Vector a
    >myVector vector list element =
    >  C.build builder
    >  where
    >    builder =
    >      B.vector vector <>
    >      B.foldable list <>
    >      B.singleton element

category:             Vector
abi:                  84ecb217f0290a0d85ae7e150e9bc1cc
exposed:              True
exposed-modules:
    VectorBuilder.Alternative VectorBuilder.Builder
    VectorBuilder.MVector VectorBuilder.MonadPlus VectorBuilder.Vector

hidden-modules:
    VectorBuilder.Prelude VectorBuilder.Core.Update
    VectorBuilder.Core.Builder

import-dirs:          /usr/lib/ghc-9.0.2/site-local/vector-builder-0.3.8.4
library-dirs:         /usr/lib/ghc-9.0.2/site-local/vector-builder-0.3.8.4
dynamic-library-dirs: /usr/lib
data-dir:             /usr/share/haskell-vector-builder
hs-libraries:         HSvector-builder-0.3.8.4-G3b527IoOeM4KrEAtnGKNj
depends:              base-4.15.1.0 vector-0.13.0.0-9fyHsAonVFcGYv9jtLmfSh
haddock-interfaces:
    /usr/share/doc/haskell-vector-builder/html/vector-builder.haddock

haddock-html:         /usr/share/doc/haskell-vector-builder/html
' | '/usr/bin/ghc-pkg' 'update' '--force' '-' '--global' '--no-user-package-db' "$@"

