#!/bin/sh
export PATH='/usr/local/sbin:/usr/local/bin:/usr/bin:/usr/bin/site_perl:/usr/bin/vendor_perl:/usr/bin/core_perl'
echo 'name:                 wai-extra
version:              3.1.13.0
visibility:           public
id:                   wai-extra-3.1.13.0-DO2SbcVgl4E2TEZUzH4p9Q
key:                  wai-extra-3.1.13.0-DO2SbcVgl4E2TEZUzH4p9Q
license:              MIT
maintainer:           michael@snoyman.com
author:               Michael Snoyman
stability:            Stable
homepage:             http://github.com/yesodweb/wai
synopsis:             Provides some basic WAI handlers and middleware.
description:
    Provides basic WAI handler and middleware functionality:

    * WAI Testing Framework

    Hspec testing facilities and helpers for WAI.

    * Event Source/Event Stream

    Send server events to the client. Compatible with the JavaScript
    EventSource API.

    * Accept Override

    Override the Accept header in a request. Special handling for the
    _accept query parameter (which is used throughout WAI override the
    Accept header).

    * Add Headers

    WAI Middleware for adding arbitrary headers to an HTTP request.

    * Clean Path

    Clean a request path to a canonical form.

    * Combine Headers

    Combine duplicate headers into one.

    * GZip Compression

    Negotiate HTTP payload gzip compression.

    * Health check endpoint

    Add an empty health check endpoint.

    * HTTP Basic Authentication

    WAI Basic Authentication Middleware which uses Authorization header.

    * JSONP

    \"JSON with Padding\" middleware. Automatic wrapping of JSON
    responses to convert into JSONP.

    * Method Override / Post

    Allows overriding of the HTTP request method via the _method query string
    parameter.

    * Request Logging

    Request logging middleware for development and production environments

    * Request Rewrite

    Rewrite request path info based on a custom conversion rules.

    * Select

    Dynamically choose between Middlewares.

    * Stream Files

    Convert ResponseFile type responses into ResponseStream type.

    * Virtual Host

    Redirect incoming requests to a new host based on custom rules.


    API docs and the README are available at <http://www.stackage.org/package/wai-extra>.

category:             Web
abi:                  931507ac258d0fca5718fa1e102c8d01
exposed:              True
exposed-modules:
    Network.Wai.EventSource Network.Wai.EventSource.EventStream
    Network.Wai.Handler.CGI Network.Wai.Handler.SCGI Network.Wai.Header
    Network.Wai.Middleware.AcceptOverride
    Network.Wai.Middleware.AddHeaders Network.Wai.Middleware.Approot
    Network.Wai.Middleware.Autohead Network.Wai.Middleware.CleanPath
    Network.Wai.Middleware.CombineHeaders
    Network.Wai.Middleware.ForceDomain Network.Wai.Middleware.ForceSSL
    Network.Wai.Middleware.Gzip
    Network.Wai.Middleware.HealthCheckEndpoint
    Network.Wai.Middleware.HttpAuth Network.Wai.Middleware.Jsonp
    Network.Wai.Middleware.Local Network.Wai.Middleware.MethodOverride
    Network.Wai.Middleware.MethodOverridePost
    Network.Wai.Middleware.RealIp Network.Wai.Middleware.RequestLogger
    Network.Wai.Middleware.RequestLogger.JSON
    Network.Wai.Middleware.RequestSizeLimit
    Network.Wai.Middleware.RequestSizeLimit.Internal
    Network.Wai.Middleware.Rewrite Network.Wai.Middleware.Routed
    Network.Wai.Middleware.Select Network.Wai.Middleware.StreamFile
    Network.Wai.Middleware.StripHeaders Network.Wai.Middleware.Timeout
    Network.Wai.Middleware.Vhost Network.Wai.Parse Network.Wai.Request
    Network.Wai.Test Network.Wai.Test.Internal Network.Wai.UrlMap

hidden-modules:
    Network.Wai.Middleware.RequestLogger.Internal Network.Wai.Util

import-dirs:          /usr/lib/ghc-9.0.2/site-local/wai-extra-3.1.13.0
library-dirs:         /usr/lib/ghc-9.0.2/site-local/wai-extra-3.1.13.0
dynamic-library-dirs: /usr/lib
data-dir:             /usr/share/haskell-wai-extra
hs-libraries:         HSwai-extra-3.1.13.0-DO2SbcVgl4E2TEZUzH4p9Q
depends:
    HUnit-1.6.2.0-JGxgr0O3qDr2sR1C0CRfuz
    aeson-2.1.2.1-A4BCifdqKBRKymWAxMJ7G4
    ansi-terminal-0.11.4-30w7KBHfEQ9CygddjSQvBk base-4.15.1.0
    base64-bytestring-1.2.1.0-D7qbdpqh7ZAHvyipCqb2En
    bytestring-0.10.12.1 call-stack-0.4.0-AF4gWC5rZiPGBfZc4bnMry
    case-insensitive-1.2.1.0-4jgW7rCNZT7HuDvSGowCF containers-0.6.4.1
    cookie-0.4.6-AQamA5QJzxUGLdn7cmcakq
    data-default-class-0.1.2.0-IxhEAzgy8931aXcEiJcyZO directory-1.3.6.2
    fast-logger-3.1.2-51e0CUNDeLV5vXlixg34jU
    http-types-0.12.3-GFhxs6XVQ6bETbOR4vEFmW
    iproute-1.7.12-vDxDE0QT3o7C7tlko7OmA
    network-3.1.4.0-5PP4MrJJnZZJkybIlRRAPq
    resourcet-1.2.6-AavQnD5kc82Iq3gAOb9Jer
    streaming-commons-0.2.2.6-HZ2A1be0fn01OMKI16UdBU text-1.2.5.0
    time-1.9.3 transformers-0.5.6.2 unix-2.7.2.2
    vault-0.3.1.5-KrUyCBjiBj452iqy9eE8Dc
    wai-3.2.3-BDPWmqf0MooISXwouhUuyf
    wai-logger-2.4.0-4MFhd5ohqyW5mpqweZYimp
    warp-3.3.29-9OttiYt9mWD7bTfEHENUMa
    word8-0.1.3-AazxEC5xyKiELvx3OUlEW

haddock-interfaces:   /usr/share/doc/haskell-wai-extra/html/wai-extra.haddock
haddock-html:         /usr/share/doc/haskell-wai-extra/html
' | '/usr/bin/ghc-pkg' 'update' '--force' '-' '--global' '--no-user-package-db' "$@"

