#!/bin/sh
export PATH='/usr/local/sbin:/usr/local/bin:/usr/bin:/usr/bin/site_perl:/usr/bin/vendor_perl:/usr/bin/core_perl'
echo 'name:                 websockets
version:              0.12.7.3
visibility:           public
id:                   websockets-0.12.7.3-RRy6Blvsmn1OLx7azRA3m
key:                  websockets-0.12.7.3-RRy6Blvsmn1OLx7azRA3m
license:              BSD-3-Clause
copyright:
    (c) 2010-2011 Siniša Biđin
    (c) 2011-2018 Jasper Van der Jeugt
    (c) 2011 Steffen Schuldenzucker
    (c) 2011 Alex Lang

maintainer:           Jasper Van der Jeugt <m@jaspervdj.be>
author:
    Siniša Biđin <sinisa@bidin.cc>
    Jasper Van der Jeugt <m@jaspervdj.be>
    Steffen Schuldenzucker <steffen.schuldenzucker@googlemail.com>
    Alex Lang <lang@tsurucapital.com>

stability:            experimental
homepage:             http://jaspervdj.be/websockets
synopsis:
    A sensible and clean way to write WebSocket-capable servers in Haskell.

description:
    This library allows you to write WebSocket-capable servers.

    An example server:
    <https://github.com/jaspervdj/websockets/blob/master/example/server.lhs>

    An example client:
    <https://github.com/jaspervdj/websockets/blob/master/example/client.hs>

    See also:

    * The specification of the WebSocket protocol:
    <http://www.whatwg.org/specs/web-socket-protocol/>

    * The JavaScript API for dealing with WebSockets:
    <http://www.w3.org/TR/websockets/>

category:             Network
abi:                  e0dad3e3aaf5bfb2c315db76cd34185c
exposed:              True
exposed-modules:
    Network.WebSockets Network.WebSockets.Client
    Network.WebSockets.Connection Network.WebSockets.Extensions
    Network.WebSockets.Stream

hidden-modules:
    Network.WebSockets.Connection.Options
    Network.WebSockets.Extensions.Description
    Network.WebSockets.Extensions.PermessageDeflate
    Network.WebSockets.Extensions.StrictUnicode Network.WebSockets.Http
    Network.WebSockets.Hybi13 Network.WebSockets.Hybi13.Demultiplex
    Network.WebSockets.Hybi13.Mask Network.WebSockets.Protocol
    Network.WebSockets.Server Network.WebSockets.Types

import-dirs:          /usr/lib/ghc-9.0.2/site-local/websockets-0.12.7.3
library-dirs:         /usr/lib/ghc-9.0.2/site-local/websockets-0.12.7.3
dynamic-library-dirs: /usr/lib
data-dir:             /usr/share/haskell-websockets
hs-libraries:         HSwebsockets-0.12.7.3-RRy6Blvsmn1OLx7azRA3m
depends:
    SHA-1.6.4.4-1UNVNO3JXJdDGqRoMkntZx
    async-2.2.4-FN1EWRVHp3S4oHdBJm7ot4
    attoparsec-0.14.4-4fjJnHqpy2x7zsjAU0XRWO base-4.15.1.0
    base64-bytestring-1.2.1.0-D7qbdpqh7ZAHvyipCqb2En binary-0.8.8.0
    bytestring-0.10.12.1 case-insensitive-1.2.1.0-4jgW7rCNZT7HuDvSGowCF
    clock-0.8.3-2U80sdDOrjmBlVZLInPGG1 containers-0.6.4.1
    entropy-0.4.1.10-CwQzC5Ky39pHQuKDZJMypk
    network-3.1.4.0-5PP4MrJJnZZJkybIlRRAPq
    random-1.2.1.1-K0OGGZ2RgxUBJhcMzCddDt
    streaming-commons-0.2.2.6-HZ2A1be0fn01OMKI16UdBU text-1.2.5.0

haddock-interfaces:   /usr/share/doc/haskell-websockets/html/websockets.haddock
haddock-html:         /usr/share/doc/haskell-websockets/html
' | '/usr/bin/ghc-pkg' 'update' '--force' '-' '--global' '--no-user-package-db' "$@"

