#!/bin/sh
export PATH='/usr/local/sbin:/usr/local/bin:/usr/bin:/usr/bin/site_perl:/usr/bin/vendor_perl:/usr/bin/core_perl'
echo 'name:                 what4
version:              1.3
visibility:           public
id:                   what4-1.3-7MLrvgiesADLPe1WyI0oO
key:                  what4-1.3-7MLrvgiesADLPe1WyI0oO
license:              BSD-3-Clause
copyright:            (c) Galois, Inc 2014-2021
maintainer:           jhendrix@galois.com, rdockins@galois.com
author:               Galois Inc.
homepage:             https://github.com/GaloisInc/what4
synopsis:             Solver-agnostic symbolic values support for issuing queries
description:
    What4 is a generic library for representing values as symbolic formulae which may
    contain references to symbolic values, representing unknown variables.
    It provides support for communicating with a variety of SAT and SMT solvers,
    including Z3, CVC4, Yices, Boolector, STP, and dReal.
    The data representation types make heavy use of GADT-style type indices
    to ensure type-correct manipulation of symbolic values.

category:             Formal Methods, Theorem Provers, Symbolic Computation, SMT
abi:                  f49933f9f97b7355a85aa9f684107474
exposed:              True
exposed-modules:
    Test.Verification What4.BaseTypes What4.Concrete What4.Config
    What4.Expr What4.Expr.Allocator What4.Expr.App What4.Expr.AppTheory
    What4.Expr.ArrayUpdateMap What4.Expr.BoolMap What4.Expr.Builder
    What4.Expr.GroundEval What4.Expr.MATLAB What4.Expr.Simplify
    What4.Expr.StringSeq What4.Expr.UnaryBV
    What4.Expr.VarIdentification What4.Expr.WeightedSum What4.FloatMode
    What4.FunctionName What4.IndexLit What4.Interface
    What4.InterpretedFloatingPoint What4.LabeledPred What4.Panic
    What4.Partial What4.ProblemFeatures What4.ProgramLoc
    What4.Protocol.Online What4.Protocol.PolyRoot
    What4.Protocol.ReadDecimal What4.Protocol.SExp
    What4.Protocol.SMTLib2 What4.Protocol.SMTLib2.Parse
    What4.Protocol.SMTLib2.Response What4.Protocol.SMTLib2.Syntax
    What4.Protocol.SMTWriter What4.Protocol.VerilogWriter
    What4.Protocol.VerilogWriter.ABCVerilog
    What4.Protocol.VerilogWriter.AST
    What4.Protocol.VerilogWriter.Backend What4.SFloat What4.SWord
    What4.SatResult What4.SemiRing What4.Solver What4.Solver.Adapter
    What4.Solver.Boolector What4.Solver.CVC4 What4.Solver.DReal
    What4.Solver.ExternalABC What4.Solver.STP What4.Solver.Yices
    What4.Solver.Z3 What4.SpecialFunctions What4.Symbol
    What4.Utils.AbstractDomains What4.Utils.AnnotatedMap
    What4.Utils.Arithmetic What4.Utils.BVDomain
    What4.Utils.BVDomain.Arith What4.Utils.BVDomain.Bitwise
    What4.Utils.BVDomain.XOR What4.Utils.Complex What4.Utils.Endian
    What4.Utils.Environment What4.Utils.FloatHelpers
    What4.Utils.HandleReader What4.Utils.IncrHash What4.Utils.LeqMap
    What4.Utils.MonadST What4.Utils.OnlyIntRepr What4.Utils.Process
    What4.Utils.ResolveBounds.BV What4.Utils.Streams
    What4.Utils.StringLiteral What4.Utils.Versions
    What4.Utils.Word16String What4.WordMap

import-dirs:          /usr/lib/ghc-9.0.2/site-local/what4-1.3
library-dirs:         /usr/lib/ghc-9.0.2/site-local/what4-1.3
dynamic-library-dirs: /usr/lib
data-dir:             /usr/share/haskell-what4
hs-libraries:         HSwhat4-1.3-7MLrvgiesADLPe1WyI0oO
depends:
    async-2.2.4-FN1EWRVHp3S4oHdBJm7ot4
    attoparsec-0.14.4-4fjJnHqpy2x7zsjAU0XRWO base-4.15.1.0
    bifunctors-5.5.15-3KMbabBcAMBDp1F0CEHRh3
    bimap-0.5.0-2F5FDnrKdW6LcyGWB8RJBu
    bv-sized-1.0.5-FmRMXYMe7AACJXMZYEW4HY bytestring-0.10.12.1
    concurrent-extra-0.7.0.12-8sLs1pLF9SELXF3i5FmASZ
    config-value-0.8.3-3pmzeYU8Vb25WTAZFoPyxS containers-0.6.4.1
    data-binary-ieee754-0.4.4-6nKeQnWkGoLJGejCHaRaWS deepseq-1.4.5.0
    deriving-compat-0.6.5-6sdpI6jmenpMIq8ldvwsQ directory-1.3.6.2
    exceptions-0.10.4 filepath-1.4.2.1
    fingertree-0.1.5.0-9moip4KbdSC587KawbetVh ghc-prim-0.7.0
    hashable-1.4.2.0-8JSq7I7AhyyZ2Q90BxZWW
    hashtables-1.3.1-45c5RsW03fJCUDS4qzuITr
    io-streams-1.5.2.2-HlPLQSNazvOGmvO4lqnsG9
    lens-5.2.2-4uj1AepANiF2ook39zjsmk
    libBF-0.6.5.1-FknDHCXsSJo1HxVmmyI8Od mtl-2.2.2
    panic-0.4.0.1-2wjLiVfd2FlFLaw0kmLA9p
    parameterized-utils-2.1.6.0-BwWdEkpa93WLJAXS1kmZHo
    prettyprinter-1.7.1-9bwAyMlaUSyJVG7FMXWGKT process-1.6.13.2
    scientific-0.3.7.0-6CvCEFxXBWR5nYRp7k6pyR template-haskell-2.17.0.0
    temporary-1.3-Bh4fczMTiyN6QOEVSScDYk text-1.2.5.0
    th-abstraction-0.4.5.0-CPrpKcr2W2S31K8QsJKgDp
    th-lift-0.8.4-4cyXLgXzVomInnuNEFv3vJ
    th-lift-instances-0.1.20-Cb8K81p9utM1skQxiFjQn2
    transformers-0.5.6.2
    unordered-containers-0.2.19.1-Km0aDxhChoIJJSbiufyazz
    utf8-string-1.0.2-519AraujIYSLY3i7TJuoqO
    vector-0.13.0.0-9fyHsAonVFcGYv9jtLmfSh
    versions-5.0.5-1sPYfqusbIYElOmPthIvUM
    zenc-0.1.2-FZR8gAjfWoyKWTFcGpCdLh

haddock-interfaces:   /usr/share/doc/haskell-what4/html/what4.haddock
haddock-html:         /usr/share/doc/haskell-what4/html
' | '/usr/bin/ghc-pkg' 'update' '--force' '-' '--global' '--no-user-package-db' "$@"

