#!/bin/sh
export PATH='/usr/local/sbin:/usr/local/bin:/usr/bin:/usr/bin/site_perl:/usr/bin/vendor_perl:/usr/bin/core_perl'
echo 'name:                 wide-word
version:              0.1.5.0
visibility:           public
id:                   wide-word-0.1.5.0-5dZGssPNxi1CP5kLpFsGGe
key:                  wide-word-0.1.5.0-5dZGssPNxi1CP5kLpFsGGe
license:              BSD-2-Clause
copyright:
    Copyright (c) 2017 Erik de Castro Lopo <erikd@mega-nerd.com>

maintainer:           erikd@mega-nerd.com
author:               Erik de Castro Lopo
stability:            provisional
homepage:             https://github.com/erikd/wide-word
synopsis:
    Data types for large but fixed width signed and unsigned integers

description:
    A library to provide data types for large (ie > 64 bits) but fixed width signed
    and unsigned integers with the usual typeclass instances to allow them to be used
    interchangeably with `Word64`.

    The types and operations are coded to be as fast as possible using strictness
    annotations, `INLINEABLE` pragmas and unboxed values and operations where
    appropriate.

category:             Data
abi:                  c6b40d77f3e4b4e458a0a8d7bc311fdf
exposed:              True
exposed-modules:
    Data.WideWord Data.WideWord.Int128 Data.WideWord.Word128
    Data.WideWord.Word256 Data.WideWord.Word64

hidden-modules:       Data.WideWord.Compat
import-dirs:          /usr/lib/ghc-9.0.2/site-local/wide-word-0.1.5.0
library-dirs:         /usr/lib/ghc-9.0.2/site-local/wide-word-0.1.5.0
dynamic-library-dirs: /usr/lib
data-dir:             /usr/share/haskell-wide-word
hs-libraries:         HSwide-word-0.1.5.0-5dZGssPNxi1CP5kLpFsGGe
depends:
    base-4.15.1.0 binary-0.8.8.0 deepseq-1.4.5.0 ghc-prim-0.7.0
    hashable-1.4.2.0-8JSq7I7AhyyZ2Q90BxZWW
    primitive-0.7.4.0-8RUdbvjRYjOFHQ1vgzaS7Q

haddock-interfaces:   /usr/share/doc/haskell-wide-word/html/wide-word.haddock
haddock-html:         /usr/share/doc/haskell-wide-word/html
' | '/usr/bin/ghc-pkg' 'update' '--force' '-' '--global' '--no-user-package-db' "$@"

