#!/bin/sh
export PATH='/usr/local/sbin:/usr/local/bin:/usr/bin:/usr/bin/site_perl:/usr/bin/vendor_perl:/usr/bin/core_perl'
echo 'name:                 x509
version:              1.7.7
visibility:           public
id:                   x509-1.7.7-HPoOmMo5ITAEwKInegOKUF
key:                  x509-1.7.7-HPoOmMo5ITAEwKInegOKUF
license:              BSD-3-Clause
copyright:            Vincent Hanquez <vincent@snarc.org>
maintainer:           Vincent Hanquez <vincent@snarc.org>
author:               Vincent Hanquez <vincent@snarc.org>
stability:            experimental
homepage:             http://github.com/vincenthz/hs-certificate
synopsis:             X509 reader and writer
description:          X509 reader and writer. please see README
category:             Data
abi:                  ff40a3c3f6ebbb3f145751381b1d42dc
exposed:              True
exposed-modules:      Data.X509 Data.X509.EC
hidden-modules:
    Data.X509.Internal Data.X509.CertificateChain
    Data.X509.AlgorithmIdentifier Data.X509.DistinguishedName
    Data.X509.Cert Data.X509.PublicKey Data.X509.PrivateKey
    Data.X509.Ext Data.X509.ExtensionRaw Data.X509.CRL Data.X509.OID
    Data.X509.Signed

import-dirs:          /usr/lib/ghc-9.0.2/site-local/x509-1.7.7
library-dirs:         /usr/lib/ghc-9.0.2/site-local/x509-1.7.7
dynamic-library-dirs: /usr/lib
data-dir:             /usr/share/haskell-x509
hs-libraries:         HSx509-1.7.7-HPoOmMo5ITAEwKInegOKUF
depends:
    asn1-encoding-0.9.6-1Z4gQw1tzUE2BT1xNwBCfI
    asn1-parse-0.9.5-6kHWMGywwgJEvg9N9s5V8o
    asn1-types-0.3.4-K5Jv36Bzoic5aVrcL4bJfY base-4.15.1.0
    bytestring-0.10.12.1 containers-0.6.4.1
    cryptonite-0.30-A2WcUXrCplbraDFo3HWcX
    hourglass-0.2.12-3wGaKcE8Ujz1EvMq5zvP8q
    memory-0.17.0-Ba80JGdi30PBt5EgUiQ1Tu
    pem-0.2.4-CtrXRM9Jh4KD1osnRA82Ka transformers-0.5.6.2

haddock-interfaces:   /usr/share/doc/haskell-x509/html/x509.haddock
haddock-html:         /usr/share/doc/haskell-x509/html
' | '/usr/bin/ghc-pkg' 'update' '--force' '-' '--global' '--no-user-package-db' "$@"

