#!/bin/sh
export PATH='/usr/local/sbin:/usr/local/bin:/usr/bin:/usr/bin/site_perl:/usr/bin/vendor_perl:/usr/bin/core_perl'
echo 'name:                 zeromq4-haskell
version:              0.8.0
visibility:           public
id:                   zeromq4-haskell-0.8.0-4k8xr6Lz5sDKp389UKRr5F
key:                  zeromq4-haskell-0.8.0-4k8xr6Lz5sDKp389UKRr5F
license:              MIT
copyright:            (c) 2010 - 2015 zeromq-haskell authors
maintainer:           Toralf Wittner <tw@dtex.org>
author:               Toralf Wittner
stability:            experimental
homepage:             https://gitlab.com/twittner/zeromq-haskell/
synopsis:             Bindings to ZeroMQ 4.x
description:
    The 0MQ lightweight messaging kernel is a library which extends
    the standard socket interfaces with features traditionally provided
    by specialised messaging middleware products.

    0MQ sockets provide an abstraction of asynchronous message queues,
    multiple messaging patterns, message filtering (subscriptions),
    seamless access to multiple transport protocols and more.

    This library provides the Haskell language binding to 0MQ >= 4.x

category:             System, FFI
abi:                  e93fbda8b1ff12eadecb29571003cf73
exposed:              True
exposed-modules:
    Data.Restricted System.ZMQ4 System.ZMQ4.Internal
    System.ZMQ4.Internal.Base System.ZMQ4.Internal.Error
    System.ZMQ4.Monadic

import-dirs:          /usr/lib/ghc-9.0.2/site-local/zeromq4-haskell-0.8.0
library-dirs:         /usr/lib/ghc-9.0.2/site-local/zeromq4-haskell-0.8.0
dynamic-library-dirs: /usr/lib
data-dir:             /usr/share/haskell-zeromq4-haskell
hs-libraries:         HSzeromq4-haskell-0.8.0-4k8xr6Lz5sDKp389UKRr5F
extra-libraries:      zmq
include-dirs:         /usr/include/p11-kit-1 /usr/include/pgm-5.3
depends:
    async-2.2.4-FN1EWRVHp3S4oHdBJm7ot4 base-4.15.1.0
    bytestring-0.10.12.1 containers-0.6.4.1 exceptions-0.10.4
    monad-control-1.0.3.1-35h1aVdsL57202S8tnbNU9 transformers-0.5.6.2
    transformers-base-0.4.6-92OnlKVmSzm7Q6K6Tg9Pzs

haddock-interfaces:
    /usr/share/doc/haskell-zeromq4-haskell/html/zeromq4-haskell.haddock

haddock-html:         /usr/share/doc/haskell-zeromq4-haskell/html
' | '/usr/bin/ghc-pkg' 'update' '--force' '-' '--global' '--no-user-package-db' "$@"

