/*
Copyright (c) 2015 - 2022 Advanced Micro Devices, Inc. All rights reserved.

Permission is hereby granted, free of charge, to any person obtaining a copy
of this software and associated documentation files (the "Software"), to deal
in the Software without restriction, including without limitation the rights
to use, copy, modify, merge, publish, distribute, sublicense, and/or sell
copies of the Software, and to permit persons to whom the Software is
furnished to do so, subject to the following conditions:

The above copyright notice and this permission notice shall be included in
all copies or substantial portions of the Software.

THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT.  IN NO EVENT SHALL THE
AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN
THE SOFTWARE.
*/
#ifndef NVIDIA_HIP_MATH_CONSTANTS_H
#define NVIDIA_HIP_MATH_CONSTANTS_H
#include <math_constants.h>
#define HIP_INF_F            CUDART_INF_F
#define HIP_NAN_F            CUDART_NAN_F
#define HIP_MIN_DENORM_F     CUDART_MIN_DENORM_F
#define HIP_MAX_NORMAL_F     CUDART_MAX_NORMAL_F
#define HIP_NEG_ZERO_F       CUDART_NEG_ZERO_F
#define HIP_ZERO_F           CUDART_ZERO_F
#define HIP_ONE_F            CUDART_ONE_F
#define HIP_SQRT_HALF_F      CUDART_SQRT_HALF_F
#define HIP_SQRT_HALF_HI_F   CUDART_SQRT_HALF_HI_F
#define HIP_SQRT_HALF_LO_F   CUDART_SQRT_HALF_LO_F
#define HIP_SQRT_TWO_F       CUDART_SQRT_TWO_F
#define HIP_THIRD_F          CUDART_THIRD_F
#define HIP_PIO4_F           CUDART_PIO4_F
#define HIP_PIO2_F           CUDART_PIO2_F
#define HIP_3PIO4_F          CUDART_3PIO4_F
#define HIP_2_OVER_PI_F      CUDART_2_OVER_PI_F
#define HIP_SQRT_2_OVER_PI_F CUDART_SQRT_2_OVER_PI_F
#define HIP_PI_F             CUDART_PI_F
#define HIP_L2E_F            CUDART_L2E_F
#define HIP_L2T_F            CUDART_L2T_F
#define HIP_LG2_F            CUDART_LG2_F
#define HIP_LGE_F            CUDART_LGE_F
#define HIP_LN2_F            CUDART_LN2_F
#define HIP_LNT_F            CUDART_LNT_F
#define HIP_LNPI_F           CUDART_LNPI_F
#define HIP_TWO_TO_M126_F    CUDART_TWO_TO_M126_F
#define HIP_TWO_TO_126_F     CUDART_TWO_TO_126_F
#define HIP_NORM_HUGE_F      CUDART_NORM_HUGE_F
#define HIP_TWO_TO_23_F      CUDART_TWO_TO_23_F
#define HIP_TWO_TO_24_F      CUDART_TWO_TO_24_F
#define HIP_TWO_TO_31_F      CUDART_TWO_TO_31_F
#define HIP_TWO_TO_32_F      CUDART_TWO_TO_32_F
#define HIP_REMQUO_BITS_F    CUDART_REMQUO_BITS_F
#define HIP_REMQUO_MASK_F    CUDART_REMQUO_MASK_F
#define HIP_TRIG_PLOSS_F     CUDART_TRIG_PLOSS_F
#endif


