/*
    Copyright (c) 2022 Advanced Micro Devices, Inc. All rights reserved.
*/

#ifndef ROCM_WRAPPER_HIPCUB_VERSION_HPP
#define ROCM_WRAPPER_HIPCUB_VERSION_HPP

#if defined(ROCM_NO_WRAPPER_HEADER_WARNING) || defined(ROCM_WRAPPER_GAVE_WARNING)
/* include file */
#include "../../../include/hipcub/hipcub_version.hpp"
#else
#ifndef ROCM_HEADER_WRAPPER_WERROR
#define ROCM_HEADER_WRAPPER_WERROR 0
#endif
#if ROCM_HEADER_WRAPPER_WERROR  /* ROCM_HEADER_WRAPPER_WERROR 1 */
#error "This file is deprecated. Use the header file from /opt/rocm/include/hipcub/hipcub_version.hpp by using #include <hipcub/hipcub_version.hpp>"
#else  /* ROCM_HEADER_WRAPPER_WERROR 0 */
/* give warning */
#if defined(_MSC_VER)
#pragma message(": warning:This file is deprecated. Use the header file from /opt/rocm/include/hipcub/hipcub_version.hpp by using #include <hipcub/hipcub_version.hpp>")
#elif defined(__GNUC__)
#warning "This file is deprecated. Use the header file from /opt/rocm/include/hipcub/hipcub_version.hpp by using #include <hipcub/hipcub_version.hpp>"
#endif
#endif  /* ROCM_HEADER_WRAPPER_WERROR */
/* include file */
#define ROCM_WRAPPER_GAVE_WARNING
#include "../../../include/hipcub/hipcub_version.hpp"
#undef ROCM_WRAPPER_GAVE_WARNING
#endif /* defined(ROCM_NO_WRAPPER_HEADER_WARNING) || defined(ROCM_WRAPPER_GAVE_WARNING) */

#endif /* ROCM_WRAPPER_HIPCUB_VERSION_HPP */

#if 0

/* The following is a copy of the original file for the benefit of build systems which grep for values
 * in this file rather than preprocess it. This is just for backward compatibility */

// Copyright (c) 2018 Advanced Micro Devices, Inc. All rights reserved.
//
// Permission is hereby granted, free of charge, to any person obtaining a copy
// of this software and associated documentation files (the "Software"), to deal
// in the Software without restriction, including without limitation the rights
// to use, copy, modify, merge, publish, distribute, sublicense, and/or sell
// copies of the Software, and to permit persons to whom the Software is
// furnished to do so, subject to the following conditions:
//
// The above copyright notice and this permission notice shall be included in
// all copies or substantial portions of the Software.
//
// THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
// IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
// FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT.  IN NO EVENT SHALL THE
// AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
// LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
// OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN
// THE SOFTWARE.

#ifndef HIPCUB_VERSION_HPP_
#define HIPCUB_VERSION_HPP_

/// \def HIPCUB_VERSION
/// \brief HIPCUB library version
///
/// Version number may not be visible in the documentation.
///
/// HIPCUB_VERSION % 100 is the patch level,
/// HIPCUB_VERSION / 100 % 1000 is the minor version,
/// HIPCUB_VERSION / 100000 is the major version.
///
/// For example, if HIPCUB_VERSION is 100500, then the major version is 1,
/// the minor version is 5, and the patch level is 0.
#define HIPCUB_VERSION 2 * 100000 + 13 * 100 + 1

#define HIPCUB_VERSION_MAJOR 2
#define HIPCUB_VERSION_MINOR 13
#define HIPCUB_VERSION_PATCH 1

#endif // HIPCUB_VERSION_HPP_

#endif
