#!/bin/sh
export PATH='/usr/local/sbin:/usr/local/bin:/usr/bin:/usr/bin/site_perl:/usr/bin/vendor_perl:/usr/bin/core_perl'
echo 'name:                 hledger
version:              1.29
visibility:           public
id:                   hledger-1.29-EK3gIuPgvu08kWdxhpBPTA
key:                  hledger-1.29-EK3gIuPgvu08kWdxhpBPTA
license:              GPL-3.0-only
maintainer:           Simon Michael <simon@joyful.com>
author:               Simon Michael <simon@joyful.com>
stability:            stable
homepage:             http://hledger.org
synopsis:             Command-line interface for the hledger accounting system
description:
    The command-line interface for the hledger accounting system.
    Its basic function is to read a plain text file describing
    financial transactions and produce useful reports.

    hledger is a robust, cross-platform set of tools for tracking money,
    time, or any other commodity, using double-entry accounting and a
    simple, editable file format, with command-line, terminal and web
    interfaces. It is a Haskell rewrite of Ledger, and one of the leading
    implementations of Plain Text Accounting. Read more at:
    <https://hledger.org>

category:             Finance, Console
abi:                  bdcb07bd9edddadab6458f075d1e696a
exposed:              True
exposed-modules:
    Hledger.Cli Hledger.Cli.Anon Hledger.Cli.CliOptions
    Hledger.Cli.Commands Hledger.Cli.Commands.Accounts
    Hledger.Cli.Commands.Activity Hledger.Cli.Commands.Add
    Hledger.Cli.Commands.Aregister Hledger.Cli.Commands.Balance
    Hledger.Cli.Commands.Balancesheet
    Hledger.Cli.Commands.Balancesheetequity
    Hledger.Cli.Commands.Cashflow Hledger.Cli.Commands.Check
    Hledger.Cli.Commands.Close Hledger.Cli.Commands.Codes
    Hledger.Cli.Commands.Commodities Hledger.Cli.Commands.Descriptions
    Hledger.Cli.Commands.Diff Hledger.Cli.Commands.Files
    Hledger.Cli.Commands.Help Hledger.Cli.Commands.Import
    Hledger.Cli.Commands.Incomestatement Hledger.Cli.Commands.Notes
    Hledger.Cli.Commands.Payees Hledger.Cli.Commands.Prices
    Hledger.Cli.Commands.Print Hledger.Cli.Commands.Register
    Hledger.Cli.Commands.Rewrite Hledger.Cli.Commands.Roi
    Hledger.Cli.Commands.Stats Hledger.Cli.Commands.Tags
    Hledger.Cli.CompoundBalanceCommand Hledger.Cli.DocFiles
    Hledger.Cli.Main Hledger.Cli.Script Hledger.Cli.Utils
    Hledger.Cli.Version

hidden-modules:       Paths_hledger
import-dirs:          /usr/lib/ghc-9.0.2/site-local/hledger-1.29
library-dirs:         /usr/lib/ghc-9.0.2/site-local/hledger-1.29
dynamic-library-dirs: /usr/lib
data-dir:             /usr/share/hledger
hs-libraries:         HShledger-1.29-EK3gIuPgvu08kWdxhpBPTA
depends:
    Decimal-0.5.2-JuUDSdXwdHw807z3DuaA9c
    Diff-0.4.1-GdxJqSCBWVSImKhqghLkQt
    aeson-2.1.2.1-A4BCifdqKBRKymWAxMJ7G4
    ansi-terminal-0.11.4-30w7KBHfEQ9CygddjSQvBk base-4.15.1.0
    bytestring-0.10.12.1 cmdargs-0.10.22-LMGehiIpWZC4X4EZqKH5Yu
    containers-0.6.4.1 data-default-0.7.1.1-8E5NGoO1gLxEpVTFDWBmYU
    directory-1.3.6.2 extra-1.7.13-HYX6gpOPDmAIHqUj1ljVuZ
    filepath-1.4.2.1 githash-0.1.6.3-4OenuBfB1jl1qiRF0GwaeC
    hashable-1.4.2.0-8JSq7I7AhyyZ2Q90BxZWW haskeline-0.8.2
    hledger-lib-1.29.1-Cpyc2blrNRI6OQj2h9lrC6
    lucid-2.11.20230408-Agg77e7do5s8IXlH5nTokM
    math-functions-0.3.4.2-4X5leqErMg2JXn1eW69G9r
    megaparsec-9.3.1-LmiWZGXQazp1nnuwCBnmcX
    microlens-0.4.13.1-AoR6D5midYZB5ErWoiySs4 mtl-2.2.2
    process-1.6.13.2 regex-tdfa-1.3.2.2-9R5AJXd71FKmHTeEzzCL9
    safe-0.3.19-2aVM1fCfxX88jnlVeNbd8Q
    shakespeare-2.1.0-xnGBKt1X5w6Ot6kNYKJXr
    split-0.2.3.5-2QcOUxLgyp8IUTikrwTasf
    tabular-0.2.2.8-3mznlUNrnmF8EH6LDY9YkX
    tasty-1.4.3-F5jS0TcPgL077vxy1alhqa
    temporary-1.3-Bh4fczMTiyN6QOEVSScDYk terminfo-0.4.1.5 text-1.2.5.0
    text-ansi-0.2.1.1-AAgwmJIiNvK5moT80bMV20 time-1.9.3
    timeit-2.0-13BYXbUXu2MJzbvDZuPEww transformers-0.5.6.2
    unordered-containers-0.2.19.1-Km0aDxhChoIJJSbiufyazz
    utf8-string-1.0.2-519AraujIYSLY3i7TJuoqO
    utility-ht-0.0.17-DtYMSclNOzMELYOP9ZYsSE
    wizards-1.0.3-1RnzFufEITLBaBp65cnTUp

haddock-interfaces:   /usr/share/doc/hledger/html/hledger.haddock
haddock-html:         /usr/share/doc/hledger/html
' | '/usr/bin/ghc-pkg' 'update' '--force' '-' '--global' '--no-user-package-db' "$@"

