#!/bin/sh
export PATH='/usr/local/sbin:/usr/local/bin:/usr/bin:/usr/bin/site_perl:/usr/bin/vendor_perl:/usr/bin/core_perl'
echo 'name:                 hledger-iadd
version:              1.3.18
visibility:           public
id:                   hledger-iadd-1.3.18-HRGqg8PTNsnERxnoBq3TqR
key:                  hledger-iadd-1.3.18-HRGqg8PTNsnERxnoBq3TqR
license:              BSD-3-Clause
copyright:            2018 Hans-Peter Deifel
maintainer:           Hans-Peter Deifel <hpd@hpdeifel.de>
author:               Hans-Peter Deifel <hpd@hpdeifel.de>
homepage:             https://github.com/hpdeifel/hledger-iadd#readme
synopsis:             A terminal UI as drop-in replacement for hledger add
description:
    This is a terminal UI as drop-in replacement for hledger add.

    It improves in the following ways on hledger'\''s add command:

    * Interactive as-you-type completion for
    account names and descriptions with optional
    fuzzy matching.

    * Integrated calculator: Amounts can be written
    as simple sums with real-time feedback on the
    result.

    * All actions while entering a transaction can
    be undone

    * Configurable format for date input. Instead
    of @y\/m\/d@ it is also possible to use other
    formats like the german @d.m.y@.

category:             Finance, Console
abi:                  ea3829bce91161c07080dde3fed45eb4
exposed:              True
exposed-modules:
    AmountParser Brick.Widgets.BetterDialog Brick.Widgets.Border.Utils
    Brick.Widgets.CommentDialog Brick.Widgets.Edit.EmacsBindings
    Brick.Widgets.HelpMessage Brick.Widgets.List.Utils
    Brick.Widgets.WrappedText ConfigParser Data.Time.Ext DateParser
    Model View

import-dirs:          /usr/lib/ghc-9.0.2/site-local/hledger-iadd-1.3.18
library-dirs:         /usr/lib/ghc-9.0.2/site-local/hledger-iadd-1.3.18
dynamic-library-dirs: /usr/lib
data-dir:             /usr/share/hledger-iadd
hs-libraries:         HShledger-iadd-1.3.18-HRGqg8PTNsnERxnoBq3TqR
depends:
    base-4.15.1.0 brick-1.5-Aidz8xWh3V4o17gSxsmyj containers-0.6.4.1
    directory-1.3.6.2 free-5.1.10-JIdA28qKKvuIGxHjXb7ZXe
    hledger-lib-1.29.1-Cpyc2blrNRI6OQj2h9lrC6
    megaparsec-9.3.1-LmiWZGXQazp1nnuwCBnmcX
    microlens-0.4.13.1-AoR6D5midYZB5ErWoiySs4
    microlens-mtl-0.2.0.3-1bQnOxrDGVaBhXPSWw1eDJ
    microlens-th-0.4.3.13-2F8uJinYM5B66CBFDh33gA
    optparse-applicative-0.17.0.0-1t7fxkFVvXn4R1Ycov0fb text-1.2.5.0
    text-zipper-0.13-9XVMCbsNtDxGZAOYWi2DXX time-1.9.3
    transformers-0.5.6.2
    unordered-containers-0.2.19.1-Km0aDxhChoIJJSbiufyazz
    vector-0.13.0.0-9fyHsAonVFcGYv9jtLmfSh
    vty-5.38-6guis7PXnUmAFxRihYvW2q
    xdg-basedir-0.2.2-DeGg1ryr7ndmwRYCQYweT

haddock-interfaces:   /usr/share/doc/hledger-iadd/html/hledger-iadd.haddock
haddock-html:         /usr/share/doc/hledger-iadd/html
' | '/usr/bin/ghc-pkg' 'update' '--force' '-' '--global' '--no-user-package-db' "$@"

