#!/bin/sh
export PATH='/usr/local/sbin:/usr/local/bin:/usr/bin:/usr/bin/site_perl:/usr/bin/vendor_perl:/usr/bin/core_perl'
echo 'name:                 hledger-web
version:              1.29
visibility:           public
id:                   hledger-web-1.29-3up3u17nSATL9mbgqexHuA
key:                  hledger-web-1.29-3up3u17nSATL9mbgqexHuA
license:              GPL-3.0-only
maintainer:           Simon Michael <simon@joyful.com>
author:               Simon Michael <simon@joyful.com>
stability:            stable
homepage:             http://hledger.org
synopsis:             Web-based user interface for the hledger accounting system
description:
    A simple web-based user interface for the hledger accounting system,
    providing a more modern UI than the command-line or terminal interfaces.
    It can be used as a local single-user UI, or as a multi-user UI for
    viewing\/adding\/editing on the web.

    hledger is a robust, cross-platform set of tools for tracking money,
    time, or any other commodity, using double-entry accounting and a
    simple, editable file format, with command-line, terminal and web
    interfaces. It is a Haskell rewrite of Ledger, and one of the leading
    implementations of Plain Text Accounting. Read more at:
    <https://hledger.org>

category:             Finance
abi:                  8cd35c0ec7a658253d088d89bb893906
exposed:              True
exposed-modules:
    Hledger.Web Hledger.Web.Application Hledger.Web.Foundation
    Hledger.Web.Handler.AddR Hledger.Web.Handler.EditR
    Hledger.Web.Handler.JournalR Hledger.Web.Handler.MiscR
    Hledger.Web.Handler.RegisterR Hledger.Web.Handler.UploadR
    Hledger.Web.Import Hledger.Web.Main Hledger.Web.Settings
    Hledger.Web.Settings.StaticFiles Hledger.Web.Test
    Hledger.Web.WebOptions Hledger.Web.Widget.AddForm
    Hledger.Web.Widget.Common

hidden-modules:       Paths_hledger_web
import-dirs:          /usr/lib/ghc-9.0.2/site-local/hledger-web-1.29
library-dirs:         /usr/lib/ghc-9.0.2/site-local/hledger-web-1.29
dynamic-library-dirs: /usr/lib
data-dir:             /usr/share/hledger-web
hs-libraries:         HShledger-web-1.29-3up3u17nSATL9mbgqexHuA
depends:
    Decimal-0.5.2-JuUDSdXwdHw807z3DuaA9c
    aeson-2.1.2.1-A4BCifdqKBRKymWAxMJ7G4 base-4.15.1.0
    base64-0.4.2.4-5gSrOpzXmeeDBfLMhZMNQx
    blaze-html-0.9.1.2-CjGwhvVZpiI2yqci6C0Ey8
    blaze-markup-0.8.2.8-6v8b9MTZTaSH16HPjvW1LE bytestring-0.10.12.1
    case-insensitive-1.2.1.0-4jgW7rCNZT7HuDvSGowCF
    clientsession-0.9.2.0-INKYue0Z5jEIvlktBbTYC0
    cmdargs-0.10.22-LMGehiIpWZC4X4EZqKH5Yu
    conduit-1.3.5-Jq81tBeR2eG6Vm9Wfmg9Au
    conduit-extra-1.3.6-81BNaX6jVC8HfEWFG32czK containers-0.6.4.1
    data-default-0.7.1.1-8E5NGoO1gLxEpVTFDWBmYU directory-1.3.6.2
    extra-1.7.13-HYX6gpOPDmAIHqUj1ljVuZ filepath-1.4.2.1
    hjsmin-0.2.0.4-4enXX2WutH9Jy4gqbwreMP
    hledger-1.29-EK3gIuPgvu08kWdxhpBPTA
    hledger-lib-1.29.1-Cpyc2blrNRI6OQj2h9lrC6
    hspec-2.10.9-5ihXCFT3Zax5sW9xvf8qrc
    http-client-0.7.13.1-E99uRcHPg6l4pFHjAbr9ZZ
    http-conduit-2.3.8.2-5VV28veWBXc3z6Pi33cUa4
    http-types-0.12.3-GFhxs6XVQ6bETbOR4vEFmW
    megaparsec-9.3.1-LmiWZGXQazp1nnuwCBnmcX mtl-2.2.2
    network-3.1.4.0-5PP4MrJJnZZJkybIlRRAPq
    shakespeare-2.1.0-xnGBKt1X5w6Ot6kNYKJXr template-haskell-2.17.0.0
    text-1.2.5.0 time-1.9.3 transformers-0.5.6.2
    unix-compat-0.7-ImZLGak9HFVAcx5hoGYQVF
    unordered-containers-0.2.19.1-Km0aDxhChoIJJSbiufyazz
    utf8-string-1.0.2-519AraujIYSLY3i7TJuoqO
    wai-3.2.3-BDPWmqf0MooISXwouhUuyf
    wai-cors-0.2.7-AzQs3rH7mRFHrvnAE7oLty
    wai-extra-3.1.13.0-DO2SbcVgl4E2TEZUzH4p9Q
    wai-handler-launch-3.0.3.1-IiRi3B3NuQV6zZzl6mfvrQ
    warp-3.3.29-9OttiYt9mWD7bTfEHENUMa
    yaml-0.11.11.2-HMJi93sq55j29LTuvNA0C1
    yesod-1.6.2.1-Ls606pEYSjqFpmbhMeWpAt
    yesod-core-1.6.24.4-CiBcyOAtR1m80o8EcEK5bZ
    yesod-form-1.7.6-KKksbQTrwXxAGh8of6PKdR
    yesod-static-1.6.1.0-DeiDFatZ1AcCt6WHovaJil
    yesod-test-1.6.15-BAsfkzcZgIPGoYTwJKg0kb

haddock-interfaces:   /usr/share/doc/hledger-web/html/hledger-web.haddock
haddock-html:         /usr/share/doc/hledger-web/html
' | '/usr/bin/ghc-pkg' 'update' '--force' '-' '--global' '--no-user-package-db' "$@"

