#!/bin/sh
export PATH='/usr/local/sbin:/usr/local/bin:/usr/bin:/usr/bin/site_perl:/usr/bin/vendor_perl:/usr/bin/core_perl'
echo 'name:                 idris
version:              1.3.4
visibility:           public
id:                   idris-1.3.4-8Fy78Y7E6GoLjG8pqVWzb3
key:                  idris-1.3.4-8Fy78Y7E6GoLjG8pqVWzb3
license:              BSD-3-Clause
maintainer:           Niklas Larsson <niklas@mm.st>
author:               Edwin Brady
stability:            Beta
homepage:             https://www.idris-lang.org/
synopsis:             Functional Programming Language with Dependent Types
description:
    Idris is a general purpose language with full dependent types.
    It is compiled, with eager evaluation.
    Dependent types allow types to be predicated on values,
    meaning that some aspects of a program'\''s behaviour can be
    specified precisely in the type. The language is closely
    related to Epigram and Agda. There is a tutorial at
    <https://www.idris-lang.org/documentation>.
    Features include:

    * Full, first class, dependent types with dependent pattern matching

    * where clauses, with rule, case expressions,
    pattern matching let and lambda bindings

    * Interfaces (similar to type classes), monad comprehensions

    * do notation, idiom brackets, syntactic conveniences for lists,
    tuples, dependent pairs

    * Totality checking

    * Coinductive types

    * Indentation significant syntax, extensible syntax

    * Cumulative universes

    * Simple foreign function interface (to C)

    * Hugs style interactive environment

category:             Compilers/Interpreters, Dependent Types
abi:                  eae7d880e0f5cd1a0917e32fdb4ed2a1
exposed:              True
exposed-modules:
    IRTS.Bytecode IRTS.CodegenC IRTS.CodegenCommon
    IRTS.CodegenJavaScript IRTS.Compiler IRTS.Defunctionalise
    IRTS.DumpBC IRTS.Exports IRTS.Inliner IRTS.JavaScript.AST
    IRTS.JavaScript.Codegen IRTS.JavaScript.LangTransforms
    IRTS.JavaScript.Name IRTS.JavaScript.PrimOp
    IRTS.JavaScript.Specialize IRTS.Lang IRTS.LangOpts IRTS.Portable
    IRTS.Simplified IRTS.System Idris.ASTUtils Idris.AbsSyntax
    Idris.AbsSyntaxTree Idris.Apropos Idris.CaseSplit Idris.Chaser
    Idris.CmdOptions Idris.Colours Idris.Completion Idris.Core.Binary
    Idris.Core.CaseTree Idris.Core.Constraints Idris.Core.DeepSeq
    Idris.Core.Elaborate Idris.Core.Evaluate Idris.Core.Execute
    Idris.Core.ProofState Idris.Core.ProofTerm Idris.Core.TT
    Idris.Core.Typecheck Idris.Core.Unify Idris.Core.WHNF
    Idris.Coverage Idris.DSL Idris.DataOpts Idris.DeepSeq
    Idris.Delaborate Idris.Directives Idris.Docs Idris.Docstrings
    Idris.Elab.AsPat Idris.Elab.Clause Idris.Elab.Data
    Idris.Elab.Implementation Idris.Elab.Interface Idris.Elab.Provider
    Idris.Elab.Quasiquote Idris.Elab.Record Idris.Elab.Rewrite
    Idris.Elab.RunElab Idris.Elab.Term Idris.Elab.Transform
    Idris.Elab.Type Idris.Elab.Utils Idris.Elab.Value Idris.ElabDecls
    Idris.Erasure Idris.ErrReverse Idris.Error Idris.Help Idris.IBC
    Idris.IdeMode Idris.IdrisDoc Idris.Imports Idris.Info
    Idris.Info.Show Idris.Inliner Idris.Interactive Idris.Main
    Idris.ModeCommon Idris.Options Idris.Output Idris.Package
    Idris.Package.Common Idris.Package.Parser Idris.Parser
    Idris.Parser.Data Idris.Parser.Expr Idris.Parser.Helpers
    Idris.Parser.Ops Idris.Parser.Stack Idris.PartialEval
    Idris.Primitives Idris.ProofSearch Idris.Prover Idris.Providers
    Idris.REPL Idris.REPL.Browse Idris.REPL.Commands Idris.REPL.Parser
    Idris.Reflection Idris.Termination Idris.Transforms
    Idris.TypeSearch Idris.Unlit Idris.WhoCalls Util.DynamicLinker
    Util.ScreenSize Util.System

hidden-modules:
    Util.Pretty Util.Net Paths_idris Version_idris Tools_idris
    BuildFlags_idris

import-dirs:          /usr/lib/ghc-9.0.2/site-local/idris-1.3.4
library-dirs:         /usr/lib/ghc-9.0.2/site-local/idris-1.3.4
dynamic-library-dirs: /usr/lib
data-dir:             /usr/share/idris
hs-libraries:         HSidris-1.3.4-8Fy78Y7E6GoLjG8pqVWzb3
extra-libraries:      gmp
depends:
    aeson-2.1.2.1-A4BCifdqKBRKymWAxMJ7G4
    annotated-wl-pprint-0.7.0-6vyiTB7Qv98BkD7hsY3Ewg
    ansi-terminal-0.11.4-30w7KBHfEQ9CygddjSQvBk
    ansi-wl-pprint-0.6.9-3bScAiBbugl4HhJOdwJ4J8 array-0.5.4.0
    async-2.2.4-FN1EWRVHp3S4oHdBJm7ot4 base-4.15.1.0
    base64-bytestring-1.2.1.0-D7qbdpqh7ZAHvyipCqb2En binary-0.8.8.0
    blaze-html-0.9.1.2-CjGwhvVZpiI2yqci6C0Ey8
    blaze-markup-0.8.2.8-6v8b9MTZTaSH16HPjvW1LE bytestring-0.10.12.1
    cheapskate-0.1.1.2-JmC6jmDMtJE7fC47xfTCHh
    code-page-0.2.1-2yvmeM0b2LT6XlGG4kufG5 containers-0.6.4.1
    deepseq-1.4.5.0 directory-1.3.6.2 filepath-1.4.2.1
    fingertree-0.1.5.0-9moip4KbdSC587KawbetVh
    fsnotify-0.4.0.0-2VghzAGN7VJ6qZiofZV6Rt haskeline-0.8.2
    ieee754-0.8.0-8ARR0f1c99A76lnIcdz1Si
    libffi-0.2.1-DP5u3iTN0ykGYSlh8Owdy3
    megaparsec-9.3.1-LmiWZGXQazp1nnuwCBnmcX mtl-2.2.2
    network-3.1.4.0-5PP4MrJJnZZJkybIlRRAPq
    optparse-applicative-0.17.0.0-1t7fxkFVvXn4R1Ycov0fb
    parser-combinators-1.3.0-FL5bcA6sX4a2ejs4tDtkjB pretty-1.1.3.6
    process-1.6.13.2 regex-tdfa-1.3.2.2-9R5AJXd71FKmHTeEzzCL9
    safe-0.3.19-2aVM1fCfxX88jnlVeNbd8Q
    split-0.2.3.5-2QcOUxLgyp8IUTikrwTasf
    terminal-size-0.3.4-35v8zhylKTKAMnavZT32Cm text-1.2.5.0 time-1.9.3
    transformers-0.5.6.2 uniplate-1.6.13-BOezg2zuMGrKMCjK6N2ijG
    unix-2.7.2.2 unordered-containers-0.2.19.1-Km0aDxhChoIJJSbiufyazz
    utf8-string-1.0.2-519AraujIYSLY3i7TJuoqO
    vector-0.13.0.0-9fyHsAonVFcGYv9jtLmfSh
    vector-binary-instances-0.2.5.2-FkMHYNFVClkB8qKie4frAy
    zip-archive-0.4.3-3F07V5YI0R8G40JcJ1U2BC

haddock-interfaces:   /usr/share/doc/idris/html/idris.haddock
haddock-html:         /usr/share/doc/idris/html
' | '/usr/bin/ghc-pkg' 'update' '--force' '-' '--global' '--no-user-package-db' "$@"

