/*
 * Decompiled with CFR 0.152.
 */
package jadx.gui.device.debugger;

import jadx.core.dex.info.FieldInfo;
import jadx.core.dex.instructions.args.ArgType;
import jadx.core.dex.nodes.ClassNode;
import jadx.core.utils.StringUtils;
import jadx.core.utils.exceptions.JadxRuntimeException;
import jadx.gui.device.debugger.ArtAdapter;
import jadx.gui.device.debugger.BreakpointManager;
import jadx.gui.device.debugger.DbgUtils;
import jadx.gui.device.debugger.RegisterObserver;
import jadx.gui.device.debugger.RuntimeType;
import jadx.gui.device.debugger.SmaliDebugger;
import jadx.gui.device.debugger.SmaliDebuggerException;
import jadx.gui.device.debugger.SuspendInfo;
import jadx.gui.device.debugger.smali.Smali;
import jadx.gui.device.debugger.smali.SmaliRegister;
import jadx.gui.treemodel.JClass;
import jadx.gui.ui.panel.IDebugController;
import jadx.gui.ui.panel.JDebuggerPanel;
import jadx.gui.utils.NLS;
import jadx.gui.utils.UiUtils;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import javax.swing.JOptionPane;
import javax.swing.tree.DefaultMutableTreeNode;
import org.jetbrains.annotations.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class DebugController
implements SmaliDebugger.SuspendListener,
IDebugController {
    private static final Logger LOG = LoggerFactory.getLogger(DebugController.class);
    private static final String ONCREATE_SIGNATURE = "onCreate(Landroid/os/Bundle;)V";
    private static final Map<String, RuntimeType> TYPE_MAP = new HashMap<String, RuntimeType>();
    private static final RuntimeType[] POSSIBLE_TYPES = new RuntimeType[]{RuntimeType.OBJECT, RuntimeType.INT, RuntimeType.LONG};
    private static final int DEFAULT_CACHE_SIZE = 512;
    private JDebuggerPanel debuggerPanel;
    private SmaliDebugger debugger;
    private ArtAdapter.Debugger art;
    private final CurrentInfo cur = new CurrentInfo();
    private BreakpointStore bpStore;
    private boolean updateAllFldAndReg = false;
    private JDebuggerPanel.ValueTreeNode toBeUpdatedTreeNode;
    private volatile boolean isSuspended = true;
    private boolean hasResumed;
    private ResumeCmd run;
    private ResumeCmd stepOver;
    private ResumeCmd stepInto;
    private ResumeCmd stepOut;
    private IDebugController.StateListener stateListener;
    private final Map<String, RegisterObserver> regAdaMap = new ConcurrentHashMap<String, RegisterObserver>();
    private final ExecutorService updateQueue = Executors.newSingleThreadExecutor();
    private final ExecutorService lazyQueue = Executors.newSingleThreadExecutor();
    private static SmaliDebugger.RuntimeBreakpoint delayBP = null;

    @Override
    public boolean startDebugger(JDebuggerPanel debuggerPanel, String adbHost, int adbPort, int androidVer) {
        if (TYPE_MAP.isEmpty()) {
            DebugController.initTypeMap();
        }
        this.debuggerPanel = debuggerPanel;
        UiUtils.uiRunAndWait(debuggerPanel::resetUI);
        try {
            this.debugger = SmaliDebugger.attach(adbHost, adbPort, this);
        }
        catch (SmaliDebuggerException e) {
            JOptionPane.showMessageDialog(debuggerPanel.getMainWindow(), e.getMessage(), NLS.str("error_dialog.title"), 0);
            this.logErr(e);
            return false;
        }
        this.art = ArtAdapter.getAdapter(androidVer);
        this.resetAllInfo();
        this.hasResumed = false;
        this.run = this.debugger::resume;
        this.stepOver = this.debugger::stepOver;
        this.stepInto = this.debugger::stepInto;
        this.stepOut = this.debugger::stepOut;
        this.stopAtOnCreate();
        if (this.bpStore == null) {
            this.bpStore = new BreakpointStore();
        } else {
            this.bpStore.reset();
        }
        BreakpointManager.setDebugController(this);
        this.initBreakpoints(BreakpointManager.getAllBreakpoints());
        return true;
    }

    private void openMainActivityTab(JClass mainActivity) {
        String fullID = DbgUtils.getRawFullName(mainActivity) + "." + ONCREATE_SIGNATURE;
        Smali smali = DbgUtils.getSmali(mainActivity.getCls().getClassNode());
        int pos = smali.getMethodDefPos(fullID);
        int finalPos = Math.max(1, pos);
        this.debuggerPanel.scrollToSmaliLine(mainActivity, finalPos, true);
    }

    private void stopAtOnCreate() {
        JClass mainActivity = DbgUtils.searchMainActivity(this.debuggerPanel.getMainWindow());
        if (mainActivity == null) {
            this.debuggerPanel.log("Failed to set breakpoint at onCreate, you have to do it yourself.");
            return;
        }
        this.lazyQueue.execute(() -> this.openMainActivityTab(mainActivity));
        String clsSig = DbgUtils.getRawFullName(mainActivity);
        try {
            long id = this.debugger.getClassID(clsSig, true);
            if (id != -1L) {
                return;
            }
            this.debuggerPanel.log(String.format("Breakpoint will set at %s.%s", clsSig, ONCREATE_SIGNATURE));
            this.debugger.regMethodEntryEventSync(clsSig, ONCREATE_SIGNATURE::equals);
        }
        catch (SmaliDebuggerException e) {
            this.logErr(e, String.format("Failed set breakpoint at %s.%s", clsSig, ONCREATE_SIGNATURE));
        }
    }

    @Override
    public boolean isSuspended() {
        return this.isSuspended;
    }

    @Override
    public boolean isDebugging() {
        return this.debugger != null;
    }

    @Override
    public boolean run() {
        return this.execResumeCmd(this.run);
    }

    @Override
    public boolean stepInto() {
        return this.execResumeCmd(this.stepInto);
    }

    @Override
    public boolean stepOver() {
        return this.execResumeCmd(this.stepOver);
    }

    @Override
    public boolean stepOut() {
        return this.execResumeCmd(this.stepOut);
    }

    @Override
    public boolean pause() {
        if (this.isDebugging()) {
            try {
                this.debugger.suspend();
            }
            catch (SmaliDebuggerException e) {
                this.logErr(e);
                return false;
            }
            this.setDebuggerState(true, false);
            this.resetAllInfo();
        }
        return true;
    }

    @Override
    public boolean stop() {
        if (this.isDebugging()) {
            try {
                this.debugger.exit();
            }
            catch (SmaliDebuggerException e) {
                this.logErr(e);
                return false;
            }
        }
        return true;
    }

    @Override
    public boolean exit() {
        if (this.isDebugging()) {
            this.setDebuggerState(true, true);
            this.stop();
            this.debugger = null;
        }
        BreakpointManager.setDebugController(null);
        this.debuggerPanel.getMainWindow().destroyDebuggerPanel();
        this.debuggerPanel = null;
        return true;
    }

    @Override
    public boolean modifyRegValue(JDebuggerPanel.ValueTreeNode valNode, ArgType type, Object value) {
        this.checkType(type, value);
        if (this.isDebugging() && this.isSuspended()) {
            return this.modifyValueInternal(valNode, this.castType(type), value);
        }
        return false;
    }

    @Override
    public String getProcessName() {
        String pkg = DbgUtils.searchPackageName(this.debuggerPanel.getMainWindow());
        if (pkg.isEmpty()) {
            return "";
        }
        JClass cls = DbgUtils.searchMainActivity(this.debuggerPanel.getMainWindow());
        if (cls == null) {
            return "";
        }
        return pkg + "/" + cls.getCls().getClassNode().getClassInfo().getFullName();
    }

    private RuntimeType castType(ArgType type) {
        if (type == ArgType.INT) {
            return RuntimeType.INT;
        }
        if (type == ArgType.STRING) {
            return RuntimeType.STRING;
        }
        if (type == ArgType.LONG) {
            return RuntimeType.LONG;
        }
        if (type == ArgType.FLOAT) {
            return RuntimeType.FLOAT;
        }
        if (type == ArgType.DOUBLE) {
            return RuntimeType.DOUBLE;
        }
        if (type == ArgType.OBJECT) {
            return RuntimeType.OBJECT;
        }
        throw new JadxRuntimeException("Unexpected type: " + type);
    }

    protected static RuntimeType castType(String type) {
        RuntimeType rt = null;
        if (!StringUtils.isEmpty((String)type)) {
            rt = TYPE_MAP.get(type);
        }
        if (rt == null) {
            rt = POSSIBLE_TYPES[0];
        }
        return rt;
    }

    private void checkType(ArgType type, Object value) {
        if (!(type == ArgType.INT && value instanceof Integer || type == ArgType.STRING && value instanceof String || type == ArgType.LONG && value instanceof Long || type == ArgType.FLOAT && value instanceof Float || type == ArgType.DOUBLE && value instanceof Double || type == ArgType.OBJECT && value instanceof Long)) {
            throw new JadxRuntimeException("Type must be one of int, long, float, double, String or Object.");
        }
    }

    private boolean modifyValueInternal(JDebuggerPanel.ValueTreeNode valNode, RuntimeType type, Object value) {
        if (valNode instanceof RegTreeNode) {
            try {
                RegTreeNode regNode = (RegTreeNode)valNode;
                this.debugger.setValueSync(regNode.getRuntimeRegNum(), type, value, this.cur.frame.getThreadID(), this.cur.frame.getFrame().getID());
                this.lazyQueue.execute(() -> {
                    this.setRegsNotUpdated();
                    this.updateRegister((RegTreeNode)valNode, type, true);
                });
            }
            catch (SmaliDebuggerException e) {
                this.logErr(e);
                return false;
            }
        }
        if (valNode instanceof FieldTreeNode) {
            FieldTreeNode fldNode = (FieldTreeNode)valNode;
            try {
                this.debugger.setValueSync(fldNode.getObjectID(), ((SmaliDebugger.RuntimeField)fldNode.getRuntimeValue()).getFieldID(), fldNode.getRuntimeField().getType(), value);
                this.lazyQueue.execute(() -> this.updateField((FieldTreeNode)valNode));
            }
            catch (SmaliDebuggerException e) {
                this.logErr(e);
                return false;
            }
        }
        return true;
    }

    private boolean execResumeCmd(ResumeCmd cmd) {
        if (!this.hasResumed) {
            if (cmd != this.run) {
                return false;
            }
            this.hasResumed = true;
        }
        if (this.isDebugging() && this.isSuspended()) {
            this.updateAllFldAndReg = cmd == this.run;
            this.setDebuggerState(false, false);
            try {
                cmd.exec();
                return true;
            }
            catch (SmaliDebuggerException e) {
                this.logErr(e);
                this.setDebuggerState(true, false);
            }
        }
        return false;
    }

    private void setDebuggerState(boolean suspended, boolean stopped) {
        this.isSuspended = suspended;
        if (stopped) {
            this.hasResumed = false;
        }
        if (this.stateListener != null) {
            this.stateListener.onStateChanged(suspended, stopped);
        }
    }

    @Override
    public void setStateListener(IDebugController.StateListener listener) {
        this.stateListener = listener;
    }

    @Override
    public void onSuspendEvent(SuspendInfo info) {
        if (!this.isDebugging()) {
            return;
        }
        if (info.isTerminated()) {
            this.debuggerPanel.log("Debugger exited.");
            this.setDebuggerState(true, true);
            this.debugger = null;
            return;
        }
        this.setDebuggerState(true, false);
        long threadID = info.getThreadID();
        int refreshLevel = 2;
        if (this.cur.frame != null) {
            if (threadID == this.cur.frame.getThreadID() && info.getClassID() == this.cur.frame.getClsID() && info.getMethodID() == this.cur.frame.getMthID()) {
                refreshLevel = 1;
            } else {
                this.cur.frame.getClsID();
            }
            this.setRegsNotUpdated();
        }
        if (refreshLevel == 2) {
            this.updateAllInfo(threadID, info.getOffset());
        } else {
            if (this.cur.smali != null && this.cur.frame != null) {
                this.refreshRegInfo(info.getOffset());
                this.refreshCurFrame(threadID, info.getOffset());
                if (this.updateAllFldAndReg) {
                    this.debuggerPanel.resetRegTreeNodes();
                    this.updateAllRegisters(this.cur.frame);
                } else if (this.toBeUpdatedTreeNode != null) {
                    this.lazyQueue.execute(() -> this.updateRegOrField(this.toBeUpdatedTreeNode));
                }
                this.markCodeOffset(info.getOffset());
            } else {
                this.debuggerPanel.resetRegTreeNodes();
            }
            if (this.cur.frame != null) {
                this.cur.frame.updateCodeOffset(info.getOffset());
                this.debuggerPanel.refreshStackFrameList(Collections.emptyList());
            }
        }
    }

    private void refreshRegInfo(long codeOffset) {
        List<RegisterObserver.Info> list = this.cur.regAdapter.getInfoAt(codeOffset);
        for (RegisterObserver.Info info : list) {
            RegTreeNode reg = this.cur.frame.getRegNodes().get(info.getSmaliRegNum());
            if (info.isLoad()) {
                this.applyDbgInfo(reg, info.getInfo());
                continue;
            }
            reg.setAlias("");
            reg.setAbsoluteType(false);
        }
        if (list.size() > 0) {
            this.debuggerPanel.refreshRegisterTree();
        }
    }

    private void updateRegOrField(JDebuggerPanel.ValueTreeNode valTreeNode) {
        if (valTreeNode instanceof RegTreeNode) {
            this.updateRegister((RegTreeNode)valTreeNode, null, true);
            return;
        }
        if (valTreeNode instanceof FieldTreeNode) {
            this.updateField((FieldTreeNode)valTreeNode);
            return;
        }
    }

    public void updateField(FieldTreeNode node) {
        try {
            this.setFieldsNotUpdated();
            this.debugger.getValueSync(node.getObjectID(), node.getRuntimeField());
            this.decodeRuntimeValue(node);
            this.debuggerPanel.updateThisTree(node);
        }
        catch (SmaliDebuggerException e) {
            this.logErr(e);
        }
    }

    public boolean updateRegister(RegTreeNode regNode, RuntimeType type, boolean retry) {
        SmaliDebugger.RuntimeRegister register;
        boolean ok;
        block6: {
            if (type == null) {
                type = regNode.isAbsoluteType() ? DebugController.castType(regNode.getType()) : POSSIBLE_TYPES[0];
            }
            ok = false;
            register = null;
            try {
                register = this.debugger.getRegisterSync(this.cur.frame.getThreadID(), this.cur.frame.getFrame().getID(), regNode.getRuntimeRegNum(), type);
            }
            catch (SmaliDebuggerException e) {
                if (!retry) break block6;
                if (this.debugger.errIsTypeMismatched(e.getErrCode())) {
                    RuntimeType[] types;
                    for (RuntimeType nextType : types = this.getPossibleTypes(type)) {
                        ok = this.updateRegister(regNode, nextType, false);
                        if (!ok) continue;
                        regNode.updateType(nextType.getDesc());
                    }
                }
                this.logErr(e.getMessage() + " for " + regNode.getName());
                regNode.updateType(null);
                regNode.updateValue(null);
            }
        }
        if (register != null) {
            regNode.updateReg(register);
            this.decodeRuntimeValue(regNode);
        }
        this.debuggerPanel.updateRegTree(regNode);
        return ok;
    }

    private RuntimeType[] getPossibleTypes(RuntimeType cur) {
        RuntimeType[] types = new RuntimeType[2];
        int j = 0;
        for (int i = 0; i < POSSIBLE_TYPES.length; ++i) {
            if (cur == POSSIBLE_TYPES[i]) continue;
            types[j++] = POSSIBLE_TYPES[i];
        }
        return types;
    }

    private void markNextToBeUpdated(long codeOffset) {
        if (codeOffset != -1L) {
            Object rst = this.cur.smali.getResultRegOrField(this.cur.mthFullID, codeOffset);
            this.toBeUpdatedTreeNode = null;
            if (this.cur.frame != null) {
                if (rst instanceof Integer) {
                    int regNum = (Integer)rst;
                    if (this.cur.frame.getRegNodes().size() > regNum) {
                        this.toBeUpdatedTreeNode = this.cur.frame.getRegNodes().get(regNum);
                    }
                    return;
                }
                if (rst instanceof FieldInfo) {
                    FieldInfo info = (FieldInfo)rst;
                    this.toBeUpdatedTreeNode = this.cur.frame.getFieldNodes().stream().filter(f -> f.getName().equals(info.getName())).findFirst().orElse(null);
                }
            }
        }
    }

    private void updateAllThreads() {
        List<Long> threads;
        try {
            threads = this.debugger.getAllThreadsSync();
        }
        catch (SmaliDebuggerException e) {
            this.logErr(e);
            return;
        }
        ArrayList<ThreadBoxElement> threadEleList = new ArrayList<ThreadBoxElement>(threads.size());
        for (Long thread : threads) {
            ThreadBoxElement ele = new ThreadBoxElement(thread);
            threadEleList.add(ele);
        }
        this.debuggerPanel.refreshThreadBox(threadEleList);
        this.lazyQueue.execute(() -> {
            for (ThreadBoxElement ele : threadEleList) {
                try {
                    ele.setName(this.debugger.getThreadNameSync(ele.getThreadID()));
                }
                catch (SmaliDebuggerException e) {
                    this.logErr(e);
                }
            }
            this.debuggerPanel.refreshThreadBox(Collections.emptyList());
        });
    }

    private FrameNode updateAllStackFrames(long threadID) {
        List<Object> frames = Collections.emptyList();
        try {
            frames = this.debugger.getFramesSync(threadID);
        }
        catch (SmaliDebuggerException e) {
            this.logErr(e);
        }
        if (frames.size() == 0) {
            return null;
        }
        ArrayList<FrameNode> frameEleList = new ArrayList<FrameNode>(frames.size());
        for (SmaliDebugger.Frame frame : frames) {
            FrameNode ele = new FrameNode(threadID, frame);
            frameEleList.add(ele);
        }
        FrameNode curEle = (FrameNode)frameEleList.get(0);
        this.fetchStackFrameNames(curEle);
        this.debuggerPanel.refreshStackFrameList(frameEleList);
        this.lazyQueue.execute(() -> {
            for (int i = 1; i < frameEleList.size(); ++i) {
                this.fetchStackFrameNames((FrameNode)frameEleList.get(i));
            }
            this.debuggerPanel.refreshStackFrameList(Collections.emptyList());
        });
        return (FrameNode)frameEleList.get(0);
    }

    private void fetchStackFrameNames(FrameNode ele) {
        try {
            long clsID = ele.getFrame().getClassID();
            String clsSig = this.debugger.getClassSignatureSync(clsID);
            String mthSig = this.debugger.getMethodSignatureSync(clsID, ele.getFrame().getMethodID());
            ele.setSignatures(clsSig, mthSig);
        }
        catch (SmaliDebuggerException e) {
            this.logErr(e);
        }
    }

    private Smali decodeSmali(FrameNode frame) {
        JClass jClass;
        if (this.cur.frame.getClsSig() != null && (jClass = DbgUtils.getTopClassBySig(frame.getClsSig(), this.debuggerPanel.getMainWindow())) != null) {
            ClassNode cNode = jClass.getCls().getClassNode();
            this.cur.clsNode = jClass;
            this.cur.mthFullID = DbgUtils.classSigToRawFullName(frame.getClsSig()) + "." + frame.getMthSig();
            return DbgUtils.getSmali(cNode);
        }
        return null;
    }

    private void refreshCurFrame(long threadID, long codeOffset) {
        try {
            SmaliDebugger.Frame frame = this.debugger.getCurrentFrame(threadID);
            this.cur.frame.setFrame(frame);
            this.cur.frame.updateCodeOffset(codeOffset);
        }
        catch (SmaliDebuggerException e) {
            this.logErr(e);
        }
    }

    private void updateAllFields(FrameNode frame) {
        ClassNode clsNode;
        List fldNodes = Collections.emptyList();
        String clsSig = frame.getClsSig();
        if (clsSig != null && (clsNode = DbgUtils.getClassNodeBySig(clsSig, this.debuggerPanel.getMainWindow())) != null) {
            fldNodes = clsNode.getFields();
        }
        try {
            long thisID = this.debugger.getThisID(frame.getThreadID(), frame.getFrame().getID());
            List<SmaliDebugger.RuntimeField> flds = this.debugger.getAllFieldsSync(frame.getClsID());
            ArrayList<FieldTreeNode> nodes = new ArrayList<FieldTreeNode>(flds.size());
            for (SmaliDebugger.RuntimeField fld : flds) {
                FieldTreeNode fldNode = new FieldTreeNode(fld, thisID);
                fldNodes.stream().filter(f -> f.getName().equals(fldNode.getName())).findFirst().ifPresent(smaliFld -> fldNode.setAlias(smaliFld.getAlias()));
                nodes.add(fldNode);
            }
            this.debuggerPanel.updateThisFieldNodes(nodes);
            frame.setFieldNodes(nodes);
            if (thisID > 0L && nodes.size() > 0) {
                this.lazyQueue.execute(() -> this.updateAllFieldValues(thisID, frame));
            }
        }
        catch (SmaliDebuggerException e) {
            this.logErr(e);
        }
    }

    private void updateAllFieldValues(long thisID, FrameNode frame) {
        List<FieldTreeNode> nodes = frame.getFieldNodes();
        if (nodes.size() > 0) {
            ArrayList flds = new ArrayList(nodes.size());
            ArrayList<SmaliDebugger.RuntimeField> rts = new ArrayList<SmaliDebugger.RuntimeField>(nodes.size());
            nodes.forEach(n -> {
                SmaliDebugger.RuntimeField f = n.getRuntimeField();
                if (f.isBelongToThis()) {
                    flds.add(n);
                    rts.add(f);
                }
            });
            try {
                this.debugger.getAllFieldValuesSync(thisID, rts);
                flds.forEach(n -> this.decodeRuntimeValue((RuntimeValueTreeNode)n));
                this.debuggerPanel.refreshThisFieldTree();
            }
            catch (SmaliDebuggerException e) {
                this.logErr(e);
            }
        }
    }

    private void updateAllRegisters(FrameNode frame) {
        UiUtils.uiRun(() -> {
            if (!this.buildRegTreeNodes(frame).isEmpty()) {
                this.fetchAllRegisters(frame);
            }
        });
    }

    private void fetchAllRegisters(FrameNode frame) {
        List<SmaliRegister> regs = this.cur.regAdapter.getInitializedList(frame.getCodeOffset());
        for (SmaliRegister reg : regs) {
            Map.Entry<String, String> info = this.cur.regAdapter.getInfo(reg.getRuntimeRegNum(), frame.getCodeOffset());
            RegTreeNode regNode = frame.getRegNodes().get(reg.getRegNum());
            if (info != null) {
                this.applyDbgInfo(regNode, info);
            }
            this.updateRegister(regNode, null, true);
        }
    }

    private void applyDbgInfo(RegTreeNode rn, Map.Entry<String, String> info) {
        rn.setAlias(info.getKey());
        rn.updateType(info.getValue());
        rn.setAbsoluteType(true);
    }

    private void setRegsNotUpdated() {
        if (this.cur.frame != null) {
            for (RegTreeNode regNode : this.cur.frame.getRegNodes()) {
                regNode.setUpdated(false);
            }
        }
    }

    private void setFieldsNotUpdated() {
        if (this.cur.frame != null) {
            for (FieldTreeNode node : this.cur.frame.getFieldNodes()) {
                node.setUpdated(false);
            }
        }
    }

    private List<RegTreeNode> buildRegTreeNodes(FrameNode frame) {
        List<SmaliRegister> regs = this.cur.smali.getRegisterList(this.cur.mthFullID);
        ArrayList<RegTreeNode> regNodes = new ArrayList<RegTreeNode>(regs.size());
        ArrayList<RegTreeNode> inRtOrder = new ArrayList<RegTreeNode>(regs.size());
        regs.forEach(r -> {
            RegTreeNode rn = new RegTreeNode((SmaliRegister)r);
            regNodes.add(rn);
            inRtOrder.add(rn);
        });
        inRtOrder.sort(Comparator.comparingInt(RegTreeNode::getRuntimeRegNum));
        frame.setRegNodes(regNodes);
        this.debuggerPanel.updateRegTreeNodes(inRtOrder);
        this.debuggerPanel.refreshRegisterTree();
        return regNodes;
    }

    private boolean decodeRuntimeValue(RuntimeValueTreeNode valNode) {
        SmaliDebugger.RuntimeValue rValue = valNode.getRuntimeValue();
        RuntimeType type = rValue.getType();
        if (!valNode.isAbsoluteType()) {
            valNode.updateType(null);
        }
        try {
            switch (type) {
                case OBJECT: {
                    return this.decodeObject(valNode);
                }
                case STRING: {
                    String str = "\"" + this.debugger.readStringSync(rValue) + "\"";
                    valNode.updateType("java.lang.String").updateTypeID(this.debugger.readID(rValue)).updateValue(str);
                    break;
                }
                case INT: {
                    valNode.updateValue(Integer.toString(this.debugger.readInt(rValue)));
                    break;
                }
                case LONG: {
                    valNode.updateValue(Long.toString(this.debugger.readAll(rValue)));
                    break;
                }
                case ARRAY: {
                    this.decodeArrayVal(valNode);
                    break;
                }
                case BOOLEAN: {
                    byte b = this.debugger.readByte(rValue);
                    valNode.updateValue(b == 1 ? "true" : "false");
                    break;
                }
                case SHORT: {
                    valNode.updateValue(Short.toString(this.debugger.readShort(rValue)));
                    break;
                }
                case CHAR: 
                case BYTE: {
                    int b = (int)this.debugger.readAll(rValue);
                    if (DbgUtils.isPrintableChar(b)) {
                        valNode.updateValue(type == RuntimeType.CHAR ? String.valueOf((char)b) : String.valueOf((byte)b));
                        break;
                    }
                    valNode.updateValue(String.valueOf(b));
                    break;
                }
                case DOUBLE: {
                    double d = this.debugger.readDouble(rValue);
                    valNode.updateValue(Double.toString(d));
                    break;
                }
                case FLOAT: {
                    float f = this.debugger.readFloat(rValue);
                    valNode.updateValue(Float.toString(f));
                    break;
                }
                case VOID: {
                    valNode.updateType("void");
                    break;
                }
                case THREAD: {
                    valNode.updateType("thread").updateTypeID(this.debugger.readID(rValue));
                    break;
                }
                case THREAD_GROUP: {
                    valNode.updateType("thread_group").updateTypeID(this.debugger.readID(rValue));
                    break;
                }
                case CLASS_LOADER: {
                    valNode.updateType("class_loader").updateTypeID(this.debugger.readID(rValue));
                    break;
                }
                case CLASS_OBJECT: {
                    valNode.updateType("class_object").updateTypeID(this.debugger.readID(rValue));
                }
            }
        }
        catch (SmaliDebuggerException e) {
            this.logErr(e);
            return false;
        }
        return true;
    }

    private boolean decodeObject(RuntimeValueTreeNode valNode) {
        SmaliDebugger.RuntimeValue rValue = valNode.getRuntimeValue();
        boolean ok = true;
        if (this.debugger.readID(rValue) == 0L) {
            if (valNode.isAbsoluteType()) {
                valNode.updateValue("null");
                return ok;
            }
            if (!this.art.readNullObject()) {
                valNode.updateType(this.art.typeForNull());
                valNode.updateValue("0");
                return ok;
            }
        }
        try {
            String sig = this.debugger.readObjectSignatureSync(rValue);
            valNode.updateType(String.format("%s@%d", DbgUtils.classSigToRawFullName(sig), this.debugger.readID(rValue)));
        }
        catch (SmaliDebuggerException e) {
            boolean bl = ok = this.debugger.errIsInvalidObject(e.getErrCode()) && valNode instanceof RegTreeNode;
            if (ok) {
                try {
                    RegTreeNode reg = (RegTreeNode)valNode;
                    SmaliDebugger.RuntimeRegister rr = this.debugger.getRegisterSync(this.cur.frame.getThreadID(), this.cur.frame.getFrame().getID(), reg.getRuntimeRegNum(), RuntimeType.INT);
                    reg.updateReg(rr);
                    rValue = rr;
                    valNode.updateType(RuntimeType.INT.getDesc());
                    valNode.updateValue(Long.toString((int)this.debugger.readAll(rValue)));
                }
                catch (SmaliDebuggerException except) {
                    this.logErr(except, String.format("Update %s failed, %s", valNode.getName(), except.getMessage()));
                    valNode.updateValue(except.getMessage());
                    ok = false;
                }
            }
            this.logErr(e);
        }
        return ok;
    }

    private void decodeArrayVal(RuntimeValueTreeNode valNode) throws SmaliDebuggerException {
        String type = this.debugger.readObjectSignatureSync(valNode.getRuntimeValue());
        ArgType argType = ArgType.parse((String)type);
        String javaType = argType.toString();
        Map.Entry<Integer, List<Long>> ret = this.debugger.readArray(valNode.getRuntimeValue(), 0, 0);
        javaType = javaType.substring(0, javaType.length() - 1) + ret.getKey() + "]";
        valNode.updateType(javaType + "@" + this.debugger.readID(valNode.getRuntimeValue()));
        if (argType.getArrayElement().isPrimitive()) {
            for (Long aLong : ret.getValue()) {
                valNode.add(new DefaultMutableTreeNode(Long.toString(aLong)));
            }
            return;
        }
        String typeSig = type.substring(1);
        if (DbgUtils.isStringObjectSig(typeSig)) {
            for (Long aLong : ret.getValue()) {
                valNode.add(new DefaultMutableTreeNode(this.debugger.readStringSync(aLong)));
            }
            return;
        }
        typeSig = DbgUtils.classSigToRawFullName(typeSig);
        for (Long aLong : ret.getValue()) {
            valNode.add(new DefaultMutableTreeNode(String.format("%s@%d", typeSig, aLong)));
        }
    }

    private void updateAllInfo(long threadID, long codeOffset) {
        this.updateQueue.execute(() -> {
            this.resetAllInfo();
            this.cur.frame = this.updateAllStackFrames(threadID);
            if (this.cur.frame != null) {
                this.lazyQueue.execute(() -> this.updateAllFields(this.cur.frame));
                if (this.cur.frame.getClsSig() == null || this.cur.frame.getMthSig() == null) {
                    this.fetchStackFrameNames(this.cur.frame);
                }
                this.cur.smali = this.decodeSmali(this.cur.frame);
                if (this.cur.smali != null) {
                    this.cur.regAdapter = this.regAdaMap.computeIfAbsent(this.cur.mthFullID, k -> RegisterObserver.merge(this.getRuntimeDebugInfo(this.cur.frame), this.getRegisterList()));
                    if (this.cur.smali.getRegCount(this.cur.mthFullID) > 0) {
                        this.updateAllRegisters(this.cur.frame);
                    }
                    this.markCodeOffset(codeOffset);
                }
            }
            this.updateAllThreads();
        });
    }

    private List<SmaliRegister> getRegisterList() {
        int regCount = this.cur.smali.getRegCount(this.cur.mthFullID);
        int paramStart = this.cur.smali.getParamRegStart(this.cur.mthFullID);
        List<SmaliRegister> srs = this.cur.smali.getRegisterList(this.cur.mthFullID);
        for (SmaliRegister sr : srs) {
            sr.setRuntimeRegNum(this.art.getRuntimeRegNum(sr.getRegNum(), regCount, paramStart));
        }
        return srs;
    }

    private void resetAllInfo() {
        this.isSuspended = true;
        this.toBeUpdatedTreeNode = null;
        this.debuggerPanel.resetAllDebuggingInfo();
        this.cur.reset();
    }

    private List<SmaliDebugger.RuntimeVarInfo> getRuntimeDebugInfo(FrameNode frame) {
        try {
            SmaliDebugger.RuntimeDebugInfo dbgInfo = this.debugger.getRuntimeDebugInfo(frame.getClsID(), frame.getMthID());
            if (dbgInfo != null) {
                return dbgInfo.getInfoList();
            }
        }
        catch (SmaliDebuggerException smaliDebuggerException) {
            // empty catch block
        }
        return Collections.emptyList();
    }

    private void markCodeOffset(long codeOffset) {
        this.scrollToPos(codeOffset);
        this.markNextToBeUpdated(codeOffset);
    }

    private void logErr(Exception e, String extra) {
        this.debuggerPanel.log(e.getMessage());
        this.debuggerPanel.log(extra);
        LOG.error(extra, (Throwable)e);
    }

    private void logErr(Exception e) {
        this.debuggerPanel.log(e.getMessage());
        LOG.error("Debug error", (Throwable)e);
    }

    private void logErr(String e) {
        this.debuggerPanel.log(e);
        LOG.error("Debug error: {}", (Object)e);
    }

    private void scrollToPos(long codeOffset) {
        int pos = -1;
        if (codeOffset > -1L) {
            pos = this.cur.smali.getInsnPosByCodeOffset(this.cur.mthFullID, codeOffset);
        }
        if (pos == -1 && (pos = this.cur.smali.getMethodDefPos(this.cur.mthFullID)) == -1) {
            this.debuggerPanel.log("Can't scroll to " + this.cur.mthFullID);
            return;
        }
        this.debuggerPanel.scrollToSmaliLine(this.cur.clsNode, pos, true);
    }

    private void initBreakpoints(List<BreakpointManager.FileBreakpoint> fbps) {
        if (fbps.size() == 0) {
            return;
        }
        boolean fetch = true;
        for (BreakpointManager.FileBreakpoint fbp : fbps) {
            try {
                long id = this.debugger.getClassID(fbp.cls, fetch);
                fetch = false;
                if (id > -1L) {
                    this.setBreakpoint(id, fbp);
                    continue;
                }
                this.setDelayBreakpoint(fbp);
            }
            catch (SmaliDebuggerException e) {
                this.logErr(e);
                this.failBreakpoint(fbp, e.getMessage());
            }
        }
    }

    protected boolean setBreakpoint(BreakpointManager.FileBreakpoint bp) {
        if (!this.isDebugging()) {
            return true;
        }
        try {
            long cid = this.debugger.getClassID(bp.cls, true);
            if (cid > -1L) {
                this.setBreakpoint(cid, bp);
            } else {
                this.setDelayBreakpoint(bp);
            }
        }
        catch (SmaliDebuggerException e) {
            this.logErr(e);
            BreakpointManager.failBreakpoint(bp);
            return false;
        }
        return true;
    }

    private void setDelayBreakpoint(BreakpointManager.FileBreakpoint bp) {
        boolean hasSet = this.bpStore.hasSetDelaied(bp.cls);
        this.bpStore.add(bp, null);
        if (!hasSet) {
            this.updateQueue.execute(() -> {
                try {
                    this.debugger.regClassPrepareEventForBreakpoint(bp.cls, id -> {
                        List<BreakpointManager.FileBreakpoint> list = this.bpStore.get(bp.cls);
                        for (BreakpointManager.FileBreakpoint fbp : list) {
                            this.setBreakpoint(id, fbp);
                        }
                    });
                }
                catch (SmaliDebuggerException e) {
                    this.logErr(e);
                    this.failBreakpoint(bp, "");
                }
            });
        }
    }

    protected void setBreakpoint(long cid, BreakpointManager.FileBreakpoint fbp) {
        try {
            long mid = this.debugger.getMethodID(cid, fbp.mth);
            if (mid > -1L) {
                SmaliDebugger.RuntimeBreakpoint rbp = this.debugger.makeBreakpoint(cid, mid, fbp.codeOffset);
                this.debugger.setBreakpoint(rbp);
                this.bpStore.add(fbp, rbp);
                return;
            }
        }
        catch (SmaliDebuggerException e) {
            this.logErr(e);
        }
        this.failBreakpoint(fbp, "Failed to get method for breakpoint, " + fbp.mth + ":" + fbp.codeOffset);
    }

    private void failBreakpoint(BreakpointManager.FileBreakpoint fbp, String msg) {
        if (!msg.isEmpty()) {
            this.debuggerPanel.log(msg);
        }
        this.bpStore.removeBreakpoint(fbp);
        BreakpointManager.failBreakpoint(fbp);
    }

    protected boolean removeBreakpoint(BreakpointManager.FileBreakpoint fbp) {
        if (!this.isDebugging()) {
            return true;
        }
        SmaliDebugger.RuntimeBreakpoint rbp = this.bpStore.removeBreakpoint(fbp);
        if (rbp != null) {
            try {
                this.debugger.removeBreakpoint(rbp);
            }
            catch (SmaliDebuggerException e) {
                this.logErr(e);
                return false;
            }
        }
        return true;
    }

    private static void initTypeMap() {
        TYPE_MAP.put("I", RuntimeType.INT);
        TYPE_MAP.put("Z", RuntimeType.INT);
        TYPE_MAP.put("B", RuntimeType.INT);
        TYPE_MAP.put("C", RuntimeType.INT);
        TYPE_MAP.put("F", RuntimeType.INT);
        TYPE_MAP.put("S", RuntimeType.INT);
        TYPE_MAP.put("V", RuntimeType.INT);
        TYPE_MAP.put("int", RuntimeType.INT);
        TYPE_MAP.put("boolean", RuntimeType.INT);
        TYPE_MAP.put("byte", RuntimeType.INT);
        TYPE_MAP.put("short", RuntimeType.INT);
        TYPE_MAP.put("char", RuntimeType.INT);
        TYPE_MAP.put("float", RuntimeType.INT);
        TYPE_MAP.put("void", RuntimeType.INT);
        TYPE_MAP.put("L", RuntimeType.LONG);
        TYPE_MAP.put("D", RuntimeType.LONG);
        TYPE_MAP.put("long", RuntimeType.LONG);
        TYPE_MAP.put("double", RuntimeType.LONG);
        TYPE_MAP.put("java.lang.String", RuntimeType.STRING);
        TYPE_MAP.put("Ljava/lang/String;", RuntimeType.STRING);
    }

    private class CurrentInfo {
        JClass clsNode;
        String mthFullID;
        Smali smali;
        FrameNode frame;
        RegisterObserver regAdapter;

        private CurrentInfo() {
        }

        public void reset() {
            this.frame = null;
            this.smali = null;
            this.clsNode = null;
            this.regAdapter = null;
            this.mthFullID = "";
        }
    }

    private static interface ResumeCmd {
        public void exec() throws SmaliDebuggerException;
    }

    private class BreakpointStore {
        Map<BreakpointManager.FileBreakpoint, SmaliDebugger.RuntimeBreakpoint> bpm = Collections.emptyMap();

        BreakpointStore() {
            if (delayBP == null) {
                delayBP = DebugController.this.debugger.makeBreakpoint(-1L, -1L, -1L);
            }
        }

        void reset() {
            this.bpm.clear();
        }

        boolean hasSetDelaied(String cls) {
            for (Map.Entry<BreakpointManager.FileBreakpoint, SmaliDebugger.RuntimeBreakpoint> entry : this.bpm.entrySet()) {
                if (entry.getValue() != delayBP || !entry.getKey().cls.equals(cls)) continue;
                return true;
            }
            return false;
        }

        List<BreakpointManager.FileBreakpoint> get(String cls) {
            ArrayList<BreakpointManager.FileBreakpoint> fbps = new ArrayList<BreakpointManager.FileBreakpoint>();
            this.bpm.forEach((k, v) -> {
                if (v == delayBP && k.cls.equals(cls)) {
                    fbps.add((BreakpointManager.FileBreakpoint)k);
                    this.bpm.remove(k);
                }
            });
            return fbps;
        }

        void add(BreakpointManager.FileBreakpoint fbp, SmaliDebugger.RuntimeBreakpoint rbp) {
            if (this.bpm == Collections.EMPTY_MAP) {
                this.bpm = new ConcurrentHashMap<BreakpointManager.FileBreakpoint, SmaliDebugger.RuntimeBreakpoint>();
            }
            this.bpm.put(fbp, rbp == null ? delayBP : rbp);
        }

        SmaliDebugger.RuntimeBreakpoint removeBreakpoint(BreakpointManager.FileBreakpoint fbp) {
            return this.bpm.remove(fbp);
        }
    }

    private static class RegTreeNode
    extends RuntimeValueTreeNode {
        private static final long serialVersionUID = -1111111202103122234L;
        private final SmaliRegister smaliReg;
        private SmaliDebugger.RuntimeRegister runtimeReg;
        private String value;
        private String type;
        private String alias;
        private boolean absType;

        public RegTreeNode(SmaliRegister smaliReg) {
            this.smaliReg = smaliReg;
        }

        public void updateReg(SmaliDebugger.RuntimeRegister reg) {
            this.runtimeReg = reg;
        }

        public void setAlias(String alias) {
            this.alias = alias;
        }

        @Override
        public RegTreeNode updateValue(String value) {
            this.setUpdated(true);
            this.value = value;
            this.removeAllChildren();
            return this;
        }

        @Override
        public RegTreeNode updateType(String type) {
            if (this.type == null || !this.type.equals(type)) {
                this.type = type;
                this.reset();
            }
            return this;
        }

        private void reset() {
            this.value = null;
            this.removeAllChildren();
            this.setUpdated(true);
            this.absType = false;
            this.updateTypeID(0L);
        }

        @Override
        public String getName() {
            if (!StringUtils.isEmpty((String)this.alias)) {
                return String.format("%s (%s)", this.smaliReg.getName(), this.alias);
            }
            return String.format("%-3s", this.smaliReg.getName());
        }

        @Override
        @Nullable
        public String getValue() {
            return this.value;
        }

        public SmaliDebugger.RuntimeRegister getRuntimeReg() {
            return this.runtimeReg;
        }

        public int getRuntimeRegNum() {
            return this.smaliReg.getRuntimeRegNum();
        }

        @Override
        public String getType() {
            if (this.type != null) {
                return this.type;
            }
            if (this.runtimeReg != null) {
                return this.runtimeReg.getType().getDesc();
            }
            return null;
        }

        @Override
        public SmaliDebugger.RuntimeValue getRuntimeValue() {
            return this.getRuntimeReg();
        }

        @Override
        public boolean isAbsoluteType() {
            return this.absType;
        }

        public void setAbsoluteType(boolean abs) {
            this.absType = abs;
        }
    }

    public class FrameNode
    implements JDebuggerPanel.IListElement {
        private SmaliDebugger.Frame frame;
        private final long threadID;
        private String clsSig;
        private String mthSig;
        private StringBuilder cache = new StringBuilder(512);
        private long codeOffset = -1L;
        private List<RegTreeNode> regNodes;
        private List<FieldTreeNode> thisNodes;
        private long thisID;

        public FrameNode(long threadID, SmaliDebugger.Frame frame) {
            this.frame = frame;
            this.threadID = threadID;
            this.regNodes = Collections.emptyList();
            this.thisNodes = Collections.emptyList();
        }

        public SmaliDebugger.Frame getFrame() {
            return this.frame;
        }

        public void setFrame(SmaliDebugger.Frame frame) {
            this.frame = frame;
        }

        public long getClsID() {
            return this.frame.getClassID();
        }

        public long getMthID() {
            return this.frame.getMethodID();
        }

        public long getThreadID() {
            return this.threadID;
        }

        public long getThisID() {
            return this.thisID;
        }

        public void setThisID(long thisID) {
            this.thisID = thisID;
        }

        public void setSignatures(String clsSig, String mthSig) {
            this.clsSig = clsSig;
            this.mthSig = mthSig;
            this.resetCache();
        }

        public String getClsSig() {
            return this.clsSig;
        }

        public String getMthSig() {
            return this.mthSig;
        }

        public void updateCodeOffset(long codeOffset) {
            this.codeOffset = codeOffset;
            if (this.codeOffset > -1L) {
                this.resetCache();
            }
        }

        public long getCodeOffset() {
            return this.codeOffset == -1L ? this.frame.getCodeIndex() : this.codeOffset;
        }

        public void setRegNodes(List<RegTreeNode> regNodes) {
            this.regNodes = regNodes;
        }

        public List<RegTreeNode> getRegNodes() {
            return this.regNodes;
        }

        public List<FieldTreeNode> getFieldNodes() {
            return this.thisNodes;
        }

        public void setFieldNodes(List<FieldTreeNode> thisNodes) {
            this.thisNodes = thisNodes;
        }

        @Override
        public void onSelected() {
            if (this.clsSig != null) {
                Smali smali;
                JClass cls = DbgUtils.getTopClassBySig(this.clsSig, DebugController.this.debuggerPanel.getMainWindow());
                if (cls != null && (smali = DbgUtils.getSmali(cls.getCls().getClassNode())) != null) {
                    int pos = smali.getInsnPosByCodeOffset(DbgUtils.classSigToRawFullName(this.clsSig) + "." + this.mthSig, this.getCodeOffset());
                    DebugController.this.debuggerPanel.scrollToSmaliLine(cls, Math.max(0, pos), true);
                    return;
                }
                DebugController.this.debuggerPanel.log("Can't open smali panel for " + this.clsSig + "->" + this.mthSig);
            }
        }

        private void resetCache() {
            this.cache = new StringBuilder(512);
        }

        public String toString() {
            StringBuilder sbCache = this.cache;
            if (sbCache.length() == 0) {
                long off = this.getCodeOffset();
                if (off < 0L) {
                    sbCache.append(String.format("index: %-4d ", off));
                } else {
                    sbCache.append(String.format("index: %04x ", off));
                }
                if (this.clsSig == null) {
                    sbCache.append("clsID: ").append(this.frame.getClassID());
                } else {
                    sbCache.append(this.clsSig).append("->");
                }
                if (this.mthSig == null) {
                    sbCache.append(" mthID: ").append(this.frame.getMethodID());
                } else {
                    sbCache.append(this.mthSig);
                }
            }
            return sbCache.toString();
        }
    }

    private static class FieldTreeNode
    extends RuntimeValueTreeNode {
        private static final long serialVersionUID = -1111111202103122235L;
        private final SmaliDebugger.RuntimeField field;
        private String value;
        private String alias;
        private long objectID;

        private FieldTreeNode(SmaliDebugger.RuntimeField field, long id) {
            this.field = field;
            this.objectID = id;
        }

        public long getObjectID() {
            return this.objectID;
        }

        public void setObjectID(long id) {
            this.objectID = id;
        }

        public SmaliDebugger.RuntimeField getRuntimeField() {
            return this.field;
        }

        public void setAlias(String alias) {
            this.alias = alias;
        }

        @Override
        public FieldTreeNode updateValue(String val) {
            this.setUpdated(true);
            this.value = val;
            this.removeAllChildren();
            return this;
        }

        @Override
        public FieldTreeNode updateType(String val) {
            return this;
        }

        @Override
        public String getName() {
            if (StringUtils.isEmpty((String)this.alias) || this.alias.equals(this.field.getName())) {
                return this.field.getName();
            }
            return this.field.getName() + " (" + this.alias + ")";
        }

        @Override
        public String getValue() {
            return this.value;
        }

        @Override
        public String getType() {
            return ArgType.parse((String)this.field.getFieldType()).toString();
        }

        @Override
        public SmaliDebugger.RuntimeValue getRuntimeValue() {
            return this.field;
        }

        @Override
        public boolean isAbsoluteType() {
            return true;
        }
    }

    private static abstract class RuntimeValueTreeNode
    extends JDebuggerPanel.ValueTreeNode {
        private static final long serialVersionUID = -1111111202103260222L;
        private long typeID;

        private RuntimeValueTreeNode() {
        }

        @Override
        public JDebuggerPanel.ValueTreeNode updateTypeID(long id) {
            this.typeID = id;
            return this;
        }

        @Override
        public long getTypeID() {
            return this.typeID;
        }

        public abstract SmaliDebugger.RuntimeValue getRuntimeValue();

        public abstract boolean isAbsoluteType();
    }

    private static class ThreadBoxElement
    implements JDebuggerPanel.IListElement {
        private long threadID;
        private String name;

        public ThreadBoxElement(long threadID) {
            this.threadID = threadID;
        }

        public void setName(String name) {
            this.name = name;
        }

        public long getThreadID() {
            return this.threadID;
        }

        public String toString() {
            if (this.name == null) {
                return "thread id: " + this.threadID;
            }
            return "thread id: " + this.threadID + " name:" + this.name;
        }

        @Override
        public void onSelected() {
        }
    }
}

