/*
 * Decompiled with CFR 0.152.
 */
package jadx.gui.ui.dialog;

import com.formdev.flatlaf.icons.FlatSearchWithHistoryIcon;
import io.reactivex.BackpressureStrategy;
import io.reactivex.Emitter;
import io.reactivex.Flowable;
import io.reactivex.disposables.Disposable;
import io.reactivex.schedulers.Schedulers;
import jadx.api.JavaClass;
import jadx.core.utils.ListUtils;
import jadx.gui.jobs.ITaskInfo;
import jadx.gui.jobs.ITaskProgress;
import jadx.gui.search.SearchSettings;
import jadx.gui.search.SearchTask;
import jadx.gui.search.providers.ClassSearchProvider;
import jadx.gui.search.providers.CodeSearchProvider;
import jadx.gui.search.providers.CommentSearchProvider;
import jadx.gui.search.providers.FieldSearchProvider;
import jadx.gui.search.providers.MergedSearchProvider;
import jadx.gui.search.providers.MethodSearchProvider;
import jadx.gui.search.providers.ResourceSearchProvider;
import jadx.gui.treemodel.JClass;
import jadx.gui.treemodel.JNode;
import jadx.gui.treemodel.JResource;
import jadx.gui.ui.MainWindow;
import jadx.gui.ui.dialog.CommonSearchDialog;
import jadx.gui.utils.JumpPosition;
import jadx.gui.utils.NLS;
import jadx.gui.utils.TextStandardActions;
import jadx.gui.utils.UiUtils;
import jadx.gui.utils.layout.WrapLayout;
import jadx.gui.utils.rx.RxUtils;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.util.ArrayList;
import java.util.Collections;
import java.util.EnumSet;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import java.util.concurrent.Executor;
import java.util.concurrent.Executors;
import java.util.concurrent.TimeUnit;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.Icon;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JLabel;
import javax.swing.JMenuItem;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JTextField;
import javax.swing.event.ChangeListener;
import org.jetbrains.annotations.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SearchDialog
extends CommonSearchDialog {
    private static final Logger LOG = LoggerFactory.getLogger(SearchDialog.class);
    private static final long serialVersionUID = -5105405456969134105L;
    private static final Color SEARCH_FIELD_ERROR_COLOR = new Color(255, 150, 150);
    private final transient SearchPreset searchPreset;
    private final transient Set<SearchOptions> options;
    private transient Color searchFieldDefaultBgColor;
    private transient JTextField searchField;
    @Nullable
    private transient SearchTask searchTask;
    private transient JButton loadAllButton;
    private transient JButton loadMoreButton;
    private transient JButton stopBtn;
    private transient JButton sortBtn;
    private transient Disposable searchDisposable;
    private transient SearchEventEmitter searchEmitter;
    private transient ChangeListener activeTabListener;
    private transient String initSearchText = null;
    private final List<JNode> pendingResults = new ArrayList<JNode>();
    private final Executor searchBackgroundExecutor = Executors.newSingleThreadExecutor();

    public static void search(MainWindow window, SearchPreset preset) {
        SearchDialog searchDialog = new SearchDialog(window, preset, Collections.emptySet());
        SearchDialog.show(searchDialog, window);
    }

    public static void searchInActiveTab(MainWindow window, SearchPreset preset) {
        SearchDialog searchDialog = new SearchDialog(window, preset, EnumSet.of(SearchOptions.ACTIVE_TAB));
        SearchDialog.show(searchDialog, window);
    }

    public static void searchText(MainWindow window, String text) {
        SearchDialog searchDialog = new SearchDialog(window, SearchPreset.TEXT, Collections.emptySet());
        searchDialog.initSearchText = text;
        SearchDialog.show(searchDialog, window);
    }

    private static void show(SearchDialog searchDialog, MainWindow mw) {
        mw.addLoadListener(loaded -> {
            if (!loaded) {
                searchDialog.dispose();
                return true;
            }
            return false;
        });
        searchDialog.setVisible(true);
    }

    private SearchDialog(MainWindow mainWindow, SearchPreset preset, Set<SearchOptions> additionalOptions) {
        super(mainWindow, NLS.str("menu.text_search"));
        this.searchPreset = preset;
        this.options = this.buildOptions(preset);
        this.options.addAll(additionalOptions);
        this.loadWindowPos();
        this.initUI();
        this.initSearchEvents();
        this.registerInitOnOpen();
        this.registerActiveTabListener();
    }

    @Override
    public void dispose() {
        if (this.searchDisposable != null && !this.searchDisposable.isDisposed()) {
            this.searchDisposable.dispose();
        }
        this.resultsModel.clear();
        this.removeActiveTabListener();
        this.searchBackgroundExecutor.execute(() -> {
            this.stopSearchTask();
            this.unloadTempData();
        });
        super.dispose();
    }

    private Set<SearchOptions> buildOptions(SearchPreset preset) {
        Set<SearchOptions> searchOptions = this.cache.getLastSearchOptions().get((Object)preset);
        if (searchOptions == null) {
            searchOptions = EnumSet.noneOf(SearchOptions.class);
        }
        switch (preset) {
            case TEXT: {
                if (!searchOptions.isEmpty()) break;
                searchOptions.add(SearchOptions.CODE);
                searchOptions.add(SearchOptions.IGNORE_CASE);
                break;
            }
            case CLASS: {
                searchOptions.add(SearchOptions.CLASS);
                break;
            }
            case COMMENT: {
                searchOptions.add(SearchOptions.COMMENT);
                searchOptions.remove((Object)SearchOptions.ACTIVE_TAB);
            }
        }
        return searchOptions;
    }

    @Override
    protected void openInit() {
        String searchText;
        String string = searchText = this.initSearchText != null ? this.initSearchText : this.cache.getLastSearch();
        if (searchText != null) {
            this.searchField.setText(searchText);
            this.searchField.selectAll();
        }
        this.searchField.requestFocus();
        this.resultsTable.initColumnWidth();
        if (this.options.contains((Object)SearchOptions.COMMENT)) {
            this.searchEmitter.emitSearch();
        }
    }

    private void initUI() {
        this.searchField = new JTextField();
        this.searchFieldDefaultBgColor = this.searchField.getBackground();
        this.searchField.setAlignmentX(0.0f);
        TextStandardActions.attach(this.searchField);
        this.addSearchHistoryButton();
        this.searchField.putClientProperty("JTextField.showClearButton", true);
        boolean autoSearch = this.mainWindow.getSettings().isUseAutoSearch();
        JButton searchBtn = new JButton(NLS.str("search_dialog.search_button"));
        searchBtn.setVisible(!autoSearch);
        searchBtn.addActionListener(ev -> this.searchEmitter.emitSearch());
        JCheckBox autoSearchCB = new JCheckBox(NLS.str("search_dialog.auto_search"));
        autoSearchCB.setSelected(autoSearch);
        autoSearchCB.addActionListener(ev -> {
            boolean newValue = autoSearchCB.isSelected();
            this.mainWindow.getSettings().setUseAutoSearch(newValue);
            searchBtn.setVisible(!newValue);
            this.initSearchEvents();
            if (newValue) {
                this.searchEmitter.emitSearch();
            }
        });
        JPanel searchLinePanel = new JPanel();
        searchLinePanel.setLayout(new BoxLayout(searchLinePanel, 2));
        searchLinePanel.add(this.searchField);
        searchLinePanel.add(Box.createRigidArea(new Dimension(5, 0)));
        searchLinePanel.add(searchBtn);
        searchLinePanel.add(Box.createRigidArea(new Dimension(5, 0)));
        searchLinePanel.add(autoSearchCB);
        searchLinePanel.setAlignmentX(0.0f);
        JLabel findLabel = new JLabel(NLS.str("search_dialog.open_by_name"));
        findLabel.setAlignmentX(0.0f);
        JPanel searchFieldPanel = new JPanel();
        searchFieldPanel.setLayout(new BoxLayout(searchFieldPanel, 3));
        searchFieldPanel.setAlignmentX(0.0f);
        searchFieldPanel.add(findLabel);
        searchFieldPanel.add(Box.createRigidArea(new Dimension(0, 5)));
        searchFieldPanel.add(searchLinePanel);
        JPanel searchInPanel = new JPanel(new FlowLayout(0));
        searchInPanel.setBorder(BorderFactory.createTitledBorder(NLS.str("search_dialog.search_in")));
        searchInPanel.add(this.makeOptionsCheckBox(NLS.str("search_dialog.class"), SearchOptions.CLASS));
        searchInPanel.add(this.makeOptionsCheckBox(NLS.str("search_dialog.method"), SearchOptions.METHOD));
        searchInPanel.add(this.makeOptionsCheckBox(NLS.str("search_dialog.field"), SearchOptions.FIELD));
        searchInPanel.add(this.makeOptionsCheckBox(NLS.str("search_dialog.code"), SearchOptions.CODE));
        searchInPanel.add(this.makeOptionsCheckBox(NLS.str("search_dialog.resource"), SearchOptions.RESOURCE));
        searchInPanel.add(this.makeOptionsCheckBox(NLS.str("search_dialog.comments"), SearchOptions.COMMENT));
        JPanel searchOptions = new JPanel(new FlowLayout(0));
        searchOptions.setBorder(BorderFactory.createTitledBorder(NLS.str("search_dialog.options")));
        searchOptions.add(this.makeOptionsCheckBox(NLS.str("search_dialog.ignorecase"), SearchOptions.IGNORE_CASE));
        searchOptions.add(this.makeOptionsCheckBox(NLS.str("search_dialog.regex"), SearchOptions.USE_REGEX));
        searchOptions.add(this.makeOptionsCheckBox(NLS.str("search_dialog.active_tab"), SearchOptions.ACTIVE_TAB));
        JPanel optionsPanel = new JPanel(new WrapLayout(0, 0, 0));
        optionsPanel.setAlignmentX(0.0f);
        optionsPanel.add(searchInPanel);
        optionsPanel.add(searchOptions);
        JPanel searchPane = new JPanel();
        searchPane.setLayout(new BoxLayout(searchPane, 3));
        searchPane.add(searchFieldPanel);
        searchPane.add(Box.createRigidArea(new Dimension(0, 5)));
        searchPane.add(optionsPanel);
        this.initCommon();
        JPanel resultsPanel = this.initResultsTable();
        JPanel buttonPane = this.initButtonsPanel();
        JPanel contentPanel = new JPanel();
        contentPanel.setLayout(new BorderLayout(5, 5));
        contentPanel.setBorder(BorderFactory.createEmptyBorder(10, 10, 10, 10));
        contentPanel.add((Component)searchPane, "First");
        contentPanel.add((Component)resultsPanel, "Center");
        contentPanel.add((Component)buttonPane, "Last");
        this.getContentPane().add(contentPanel);
        this.setLocationRelativeTo(null);
        this.setDefaultCloseOperation(2);
    }

    private void addSearchHistoryButton() {
        JButton searchHistoryButton = new JButton((Icon)new FlatSearchWithHistoryIcon(true));
        searchHistoryButton.setToolTipText(NLS.str("search_dialog.search_history"));
        searchHistoryButton.addActionListener(e -> {
            JPopupMenu popupMenu = new JPopupMenu();
            List<String> searchHistory = this.mainWindow.getProject().getSearchHistory();
            if (searchHistory.isEmpty()) {
                popupMenu.add("(empty)");
            } else {
                for (String str : searchHistory) {
                    JMenuItem item = popupMenu.add(str);
                    item.addActionListener(ev -> this.searchField.setText(str));
                }
            }
            popupMenu.show(searchHistoryButton, 0, searchHistoryButton.getHeight());
        });
        this.searchField.putClientProperty("JTextField.leadingComponent", searchHistoryButton);
    }

    @Override
    protected void addResultsActions(JPanel resultsActionsPanel) {
        this.loadAllButton = new JButton(NLS.str("search_dialog.load_all"));
        this.loadAllButton.addActionListener(e -> this.loadMoreResults(true));
        this.loadAllButton.setEnabled(false);
        this.loadMoreButton = new JButton(NLS.str("search_dialog.load_more"));
        this.loadMoreButton.addActionListener(e -> this.loadMoreResults(false));
        this.loadMoreButton.setEnabled(false);
        this.stopBtn = new JButton(NLS.str("search_dialog.stop"));
        this.stopBtn.addActionListener(e -> this.pauseSearch());
        this.stopBtn.setEnabled(false);
        this.sortBtn = new JButton(NLS.str("search_dialog.sort_results"));
        this.sortBtn.addActionListener(e -> {
            List<JNode> list = this.pendingResults;
            synchronized (list) {
                this.resultsModel.sort();
                this.resultsTable.updateTable();
            }
        });
        this.sortBtn.setEnabled(false);
        resultsActionsPanel.add(this.loadAllButton);
        resultsActionsPanel.add(Box.createRigidArea(new Dimension(10, 0)));
        resultsActionsPanel.add(this.loadMoreButton);
        resultsActionsPanel.add(Box.createRigidArea(new Dimension(10, 0)));
        resultsActionsPanel.add(this.stopBtn);
        resultsActionsPanel.add(Box.createRigidArea(new Dimension(10, 0)));
        resultsActionsPanel.add(this.stopBtn);
        super.addResultsActions(resultsActionsPanel);
        resultsActionsPanel.add(Box.createRigidArea(new Dimension(10, 0)));
        resultsActionsPanel.add(this.sortBtn);
    }

    private void initSearchEvents() {
        if (this.searchDisposable != null) {
            this.searchDisposable.dispose();
            this.searchDisposable = null;
        }
        this.searchEmitter = new SearchEventEmitter();
        Flowable searchEvents = this.mainWindow.getSettings().isUseAutoSearch() ? Flowable.merge(RxUtils.textFieldChanges(this.searchField), RxUtils.textFieldEnterPress(this.searchField), this.searchEmitter.getFlowable()) : Flowable.merge(RxUtils.textFieldEnterPress(this.searchField), this.searchEmitter.getFlowable());
        this.searchDisposable = searchEvents.debounce(50L, TimeUnit.MILLISECONDS).observeOn(Schedulers.from((Executor)this.searchBackgroundExecutor)).subscribe(this::search);
    }

    private void search(String text) {
        UiUtils.notUiThreadGuard();
        this.stopSearchTask();
        UiUtils.uiRun(this::resetSearch);
        this.searchTask = this.prepareSearch(text);
        if (this.searchTask == null) {
            return;
        }
        UiUtils.uiRunAndWait(() -> {
            this.updateTableHighlight();
            this.prepareForSearch();
        });
        this.searchTask.setResultsLimit(this.mainWindow.getSettings().getSearchResultsPerPage());
        this.searchTask.setProgressListener(this::updateProgress);
        this.searchTask.fetchResults();
        LOG.debug("Total search items count estimation: {}", (Object)this.searchTask.getTaskProgress().total());
    }

    private SearchTask prepareSearch(String text) {
        if (text == null || this.options.isEmpty()) {
            return null;
        }
        if (text.isEmpty() && !this.options.contains((Object)SearchOptions.COMMENT)) {
            return null;
        }
        LOG.debug("Building search for '{}', options: {}", (Object)text, this.options);
        boolean ignoreCase = this.options.contains((Object)SearchOptions.IGNORE_CASE);
        boolean useRegex = this.options.contains((Object)SearchOptions.USE_REGEX);
        SearchSettings searchSettings = new SearchSettings(text, ignoreCase, useRegex);
        String error = searchSettings.prepare();
        if (error == null) {
            if (Objects.equals(this.searchField.getBackground(), SEARCH_FIELD_ERROR_COLOR)) {
                this.searchField.setBackground(this.searchFieldDefaultBgColor);
            }
        } else {
            this.searchField.setBackground(SEARCH_FIELD_ERROR_COLOR);
            this.resultsInfoLabel.setText(error);
            return null;
        }
        SearchTask newSearchTask = new SearchTask(this.mainWindow, this::addSearchResult, this::searchFinished);
        if (!this.buildSearch(newSearchTask, text, searchSettings)) {
            return null;
        }
        return newSearchTask;
    }

    /*
     * Enabled aggressive block sorting
     */
    private boolean buildSearch(SearchTask newSearchTask, String text, SearchSettings searchSettings) {
        List<Object> allClasses;
        if (this.options.contains((Object)SearchOptions.ACTIVE_TAB)) {
            JumpPosition currentPos = this.mainWindow.getTabbedPane().getCurrentPosition();
            if (currentPos == null) {
                this.resultsInfoLabel.setText("Can't search in current tab");
                return false;
            }
            JNode currentNode = currentPos.getNode();
            if (currentNode instanceof JClass) {
                JClass activeCls = currentNode.getRootClass();
                searchSettings.setActiveCls(activeCls);
                allClasses = Collections.singletonList(activeCls.getCls());
            } else {
                if (!(currentNode instanceof JResource)) {
                    this.resultsInfoLabel.setText("Can't search in current tab");
                    return false;
                }
                searchSettings.setActiveResource((JResource)currentNode);
                allClasses = Collections.emptyList();
            }
        } else {
            allClasses = this.mainWindow.getWrapper().getIncludedClassesWithInners();
        }
        if (text.isEmpty() && this.options.contains((Object)SearchOptions.COMMENT)) {
            newSearchTask.addProviderJob(new CommentSearchProvider(this.mainWindow, searchSettings));
            return true;
        }
        MergedSearchProvider merged = new MergedSearchProvider();
        if (this.options.contains((Object)SearchOptions.CLASS)) {
            merged.add(new ClassSearchProvider(this.mainWindow, searchSettings, allClasses));
        }
        if (this.options.contains((Object)SearchOptions.METHOD)) {
            merged.add(new MethodSearchProvider(this.mainWindow, searchSettings, allClasses));
        }
        if (this.options.contains((Object)SearchOptions.FIELD)) {
            merged.add(new FieldSearchProvider(this.mainWindow, searchSettings, allClasses));
        }
        if (this.options.contains((Object)SearchOptions.CODE)) {
            int clsCount = allClasses.size();
            if (clsCount == 1) {
                newSearchTask.addProviderJob(new CodeSearchProvider(this.mainWindow, searchSettings, allClasses));
            } else if (clsCount > 1) {
                List<List<JavaClass>> batches = this.mainWindow.getCacheObject().getDecompileBatches();
                if (batches == null) {
                    List topClasses = ListUtils.filter(allClasses, c -> !c.isInner());
                    batches = this.mainWindow.getWrapper().buildDecompileBatches(topClasses);
                    this.mainWindow.getCacheObject().setDecompileBatches(batches);
                }
                for (List<JavaClass> batch : batches) {
                    newSearchTask.addProviderJob(new CodeSearchProvider(this.mainWindow, searchSettings, batch));
                }
            }
        }
        if (this.options.contains((Object)SearchOptions.RESOURCE)) {
            newSearchTask.addProviderJob(new ResourceSearchProvider(this.mainWindow, searchSettings, this));
        }
        if (this.options.contains((Object)SearchOptions.COMMENT)) {
            newSearchTask.addProviderJob(new CommentSearchProvider(this.mainWindow, searchSettings));
        }
        merged.prepare();
        newSearchTask.addProviderJob(merged);
        return true;
    }

    @Override
    protected void openItem(JNode node) {
        if (this.mainWindow.getSettings().isUseAutoSearch()) {
            this.mainWindow.getProject().addToSearchHistory(this.searchField.getText());
        }
        super.openItem(node);
    }

    private void pauseSearch() {
        this.stopBtn.setEnabled(false);
        this.searchBackgroundExecutor.execute(() -> {
            if (this.searchTask != null) {
                this.searchTask.cancel();
            }
        });
    }

    private void stopSearchTask() {
        UiUtils.notUiThreadGuard();
        if (this.searchTask != null) {
            this.searchTask.cancel();
            this.searchTask.waitTask();
            this.searchTask = null;
        }
    }

    private void loadMoreResults(boolean all) {
        this.searchBackgroundExecutor.execute(() -> {
            if (this.searchTask == null) {
                return;
            }
            this.searchTask.cancel();
            this.searchTask.waitTask();
            UiUtils.uiRunAndWait(this::prepareForSearch);
            if (all) {
                this.searchTask.setResultsLimit(0);
            }
            this.searchTask.fetchResults();
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void resetSearch() {
        UiUtils.uiThreadGuard();
        this.resultsModel.clear();
        this.resultsTable.updateTable();
        List<JNode> list = this.pendingResults;
        synchronized (list) {
            this.pendingResults.clear();
        }
        this.updateProgressLabel("");
        this.progressPane.setVisible(false);
        this.warnLabel.setVisible(false);
        this.loadAllButton.setEnabled(false);
        this.loadMoreButton.setEnabled(false);
    }

    private void prepareForSearch() {
        UiUtils.uiThreadGuard();
        this.stopBtn.setEnabled(true);
        this.sortBtn.setEnabled(false);
        this.showSearchState();
        this.progressStartCommon();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void addSearchResult(JNode node) {
        Objects.requireNonNull(node);
        List<JNode> list = this.pendingResults;
        synchronized (list) {
            UiUtils.notUiThreadGuard();
            this.pendingResults.add(node);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void updateTable() {
        List<JNode> list = this.pendingResults;
        synchronized (list) {
            UiUtils.uiThreadGuard();
            Collections.sort(this.pendingResults);
            this.resultsModel.addAll(this.pendingResults);
            this.pendingResults.clear();
            this.resultsTable.updateTable();
        }
    }

    private void updateTableHighlight() {
        String text = this.searchField.getText();
        this.updateHighlightContext(text, !this.options.contains((Object)SearchOptions.IGNORE_CASE), this.options.contains((Object)SearchOptions.USE_REGEX));
        this.cache.setLastSearch(text);
        this.cache.getLastSearchOptions().put(this.searchPreset, this.options);
        if (!this.mainWindow.getSettings().isUseAutoSearch()) {
            this.mainWindow.getProject().addToSearchHistory(text);
        }
    }

    private void updateProgress(ITaskProgress progress) {
        UiUtils.uiRun(() -> {
            this.progressPane.setProgress(progress);
            this.updateTable();
        });
    }

    public void updateProgressLabel(String text) {
        UiUtils.uiRun(() -> this.progressInfoLabel.setText(text));
    }

    private void searchFinished(ITaskInfo status, Boolean complete) {
        UiUtils.uiThreadGuard();
        LOG.debug("Search complete: {}, complete: {}", (Object)status, (Object)complete);
        this.loadAllButton.setEnabled(complete == false);
        this.loadMoreButton.setEnabled(complete == false);
        this.stopBtn.setEnabled(false);
        this.progressFinishedCommon();
        this.updateTable();
        this.updateProgressLabel(complete);
        this.sortBtn.setEnabled(this.resultsModel.getRowCount() != 0);
    }

    private void unloadTempData() {
        this.mainWindow.getWrapper().unloadClasses();
        System.gc();
    }

    private JCheckBox makeOptionsCheckBox(String name, SearchOptions opt) {
        JCheckBox chBox = new JCheckBox(name);
        chBox.setAlignmentX(0.0f);
        chBox.setSelected(this.options.contains((Object)opt));
        chBox.addItemListener(e -> {
            if (chBox.isSelected()) {
                this.options.add(opt);
            } else {
                this.options.remove((Object)opt);
            }
            this.searchEmitter.emitSearch();
        });
        return chBox;
    }

    @Override
    protected void loadFinished() {
        this.resultsTable.setEnabled(true);
        this.searchField.setEnabled(true);
        this.searchEmitter.emitSearch();
    }

    @Override
    protected void loadStart() {
        this.resultsTable.setEnabled(false);
        this.searchField.setEnabled(false);
    }

    private void registerActiveTabListener() {
        this.removeActiveTabListener();
        this.activeTabListener = e -> {
            if (this.options.contains((Object)SearchOptions.ACTIVE_TAB)) {
                LOG.debug("active tab change event received");
                this.searchEmitter.emitSearch();
            }
        };
        this.mainWindow.getTabbedPane().addChangeListener(this.activeTabListener);
    }

    private void removeActiveTabListener() {
        if (this.activeTabListener != null) {
            this.mainWindow.getTabbedPane().removeChangeListener(this.activeTabListener);
            this.activeTabListener = null;
        }
    }

    public static enum SearchPreset {
        TEXT,
        CLASS,
        COMMENT;

    }

    public static enum SearchOptions {
        CLASS,
        METHOD,
        FIELD,
        CODE,
        RESOURCE,
        COMMENT,
        IGNORE_CASE,
        USE_REGEX,
        ACTIVE_TAB;

    }

    private class SearchEventEmitter {
        private final Flowable<String> flowable = Flowable.create(this::saveEmitter, (BackpressureStrategy)BackpressureStrategy.LATEST);
        private Emitter<String> emitter;

        public Flowable<String> getFlowable() {
            return this.flowable;
        }

        private void saveEmitter(Emitter<String> emitter) {
            this.emitter = emitter;
        }

        public synchronized void emitSearch() {
            this.emitter.onNext((Object)SearchDialog.this.searchField.getText());
        }
    }
}

