/*
 * Decompiled with CFR 0.152.
 */
package jadx.api;

import jadx.api.CommentsLevel;
import jadx.api.DecompilationMode;
import jadx.api.ICodeCache;
import jadx.api.ICodeWriter;
import jadx.api.args.DeobfuscationMapFileMode;
import jadx.api.args.ResourceNameSource;
import jadx.api.data.ICodeData;
import jadx.api.impl.AnnotatedCodeWriter;
import jadx.api.impl.InMemoryCodeCache;
import jadx.core.utils.files.FileUtils;
import java.io.File;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Collections;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.Function;
import java.util.function.Predicate;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class JadxArgs {
    private static final Logger LOG = LoggerFactory.getLogger(JadxArgs.class);
    public static final int DEFAULT_THREADS_COUNT = Math.max(1, Runtime.getRuntime().availableProcessors() / 2);
    public static final String DEFAULT_OUT_DIR = "jadx-output";
    public static final String DEFAULT_SRC_DIR = "sources";
    public static final String DEFAULT_RES_DIR = "resources";
    private List<File> inputFiles = new ArrayList<File>(1);
    private File outDir;
    private File outDirSrc;
    private File outDirRes;
    private ICodeCache codeCache = new InMemoryCodeCache();
    private Function<JadxArgs, ICodeWriter> codeWriterProvider = AnnotatedCodeWriter::new;
    private int threadsCount = DEFAULT_THREADS_COUNT;
    private boolean cfgOutput = false;
    private boolean rawCFGOutput = false;
    private boolean showInconsistentCode = false;
    private boolean useImports = true;
    private boolean debugInfo = true;
    private boolean insertDebugLines = false;
    private boolean extractFinally = true;
    private boolean inlineAnonymousClasses = true;
    private boolean inlineMethods = true;
    private boolean allowInlineKotlinLambda = true;
    private boolean skipResources = false;
    private boolean skipSources = false;
    private Predicate<String> classFilter = null;
    private boolean includeDependencies = false;
    private boolean deobfuscationOn = false;
    private boolean useSourceNameAsClassAlias = false;
    private boolean parseKotlinMetadata = false;
    private File deobfuscationMapFile = null;
    private DeobfuscationMapFileMode deobfuscationMapFileMode = DeobfuscationMapFileMode.READ;
    private ResourceNameSource resourceNameSource = ResourceNameSource.AUTO;
    private int deobfuscationMinLength = 0;
    private int deobfuscationMaxLength = Integer.MAX_VALUE;
    private boolean escapeUnicode = false;
    private boolean replaceConsts = true;
    private boolean respectBytecodeAccModifiers = false;
    private boolean exportAsGradleProject = false;
    private boolean fsCaseSensitive;
    private Set<RenameEnum> renameFlags = EnumSet.allOf(RenameEnum.class);
    private OutputFormatEnum outputFormat = OutputFormatEnum.JAVA;
    private DecompilationMode decompilationMode = DecompilationMode.AUTO;
    private ICodeData codeData;
    private CommentsLevel commentsLevel = CommentsLevel.INFO;
    private boolean useDxInput = false;
    private UseKotlinMethodsForVarNames useKotlinMethodsForVarNames = UseKotlinMethodsForVarNames.APPLY;
    private boolean skipFilesSave = false;
    private Map<String, String> pluginOptions = new HashMap<String, String>();

    public void setRootDir(File rootDir) {
        this.setOutDir(rootDir);
        this.setOutDirSrc(new File(rootDir, DEFAULT_SRC_DIR));
        this.setOutDirRes(new File(rootDir, DEFAULT_RES_DIR));
    }

    public void close() {
        try {
            this.inputFiles = null;
            if (this.codeCache != null) {
                this.codeCache.close();
            }
        }
        catch (Exception e) {
            LOG.error("Failed to close JadxArgs", (Throwable)e);
        }
        finally {
            this.codeCache = null;
        }
    }

    public List<File> getInputFiles() {
        return this.inputFiles;
    }

    public void setInputFile(File inputFile) {
        this.inputFiles = Collections.singletonList(inputFile);
    }

    public void setInputFiles(List<File> inputFiles) {
        this.inputFiles = inputFiles;
    }

    public File getOutDir() {
        return this.outDir;
    }

    public void setOutDir(File outDir) {
        this.outDir = outDir;
    }

    public File getOutDirSrc() {
        return this.outDirSrc;
    }

    public void setOutDirSrc(File outDirSrc) {
        this.outDirSrc = outDirSrc;
    }

    public File getOutDirRes() {
        return this.outDirRes;
    }

    public void setOutDirRes(File outDirRes) {
        this.outDirRes = outDirRes;
    }

    public int getThreadsCount() {
        return this.threadsCount;
    }

    public void setThreadsCount(int threadsCount) {
        this.threadsCount = Math.max(1, threadsCount);
    }

    public boolean isCfgOutput() {
        return this.cfgOutput;
    }

    public void setCfgOutput(boolean cfgOutput) {
        this.cfgOutput = cfgOutput;
    }

    public boolean isRawCFGOutput() {
        return this.rawCFGOutput;
    }

    public void setRawCFGOutput(boolean rawCFGOutput) {
        this.rawCFGOutput = rawCFGOutput;
    }

    public boolean isFallbackMode() {
        return this.decompilationMode == DecompilationMode.FALLBACK;
    }

    @Deprecated
    public void setFallbackMode(boolean fallbackMode) {
        if (fallbackMode) {
            this.decompilationMode = DecompilationMode.FALLBACK;
        }
    }

    public boolean isShowInconsistentCode() {
        return this.showInconsistentCode;
    }

    public void setShowInconsistentCode(boolean showInconsistentCode) {
        this.showInconsistentCode = showInconsistentCode;
    }

    public boolean isUseImports() {
        return this.useImports;
    }

    public void setUseImports(boolean useImports) {
        this.useImports = useImports;
    }

    public boolean isDebugInfo() {
        return this.debugInfo;
    }

    public void setDebugInfo(boolean debugInfo) {
        this.debugInfo = debugInfo;
    }

    public boolean isInsertDebugLines() {
        return this.insertDebugLines;
    }

    public void setInsertDebugLines(boolean insertDebugLines) {
        this.insertDebugLines = insertDebugLines;
    }

    public boolean isInlineAnonymousClasses() {
        return this.inlineAnonymousClasses;
    }

    public void setInlineAnonymousClasses(boolean inlineAnonymousClasses) {
        this.inlineAnonymousClasses = inlineAnonymousClasses;
    }

    public boolean isInlineMethods() {
        return this.inlineMethods;
    }

    public void setInlineMethods(boolean inlineMethods) {
        this.inlineMethods = inlineMethods;
    }

    public boolean isAllowInlineKotlinLambda() {
        return this.allowInlineKotlinLambda;
    }

    public void setAllowInlineKotlinLambda(boolean allowInlineKotlinLambda) {
        this.allowInlineKotlinLambda = allowInlineKotlinLambda;
    }

    public boolean isExtractFinally() {
        return this.extractFinally;
    }

    public void setExtractFinally(boolean extractFinally) {
        this.extractFinally = extractFinally;
    }

    public boolean isSkipResources() {
        return this.skipResources;
    }

    public void setSkipResources(boolean skipResources) {
        this.skipResources = skipResources;
    }

    public boolean isSkipSources() {
        return this.skipSources;
    }

    public void setSkipSources(boolean skipSources) {
        this.skipSources = skipSources;
    }

    public void setIncludeDependencies(boolean includeDependencies) {
        this.includeDependencies = includeDependencies;
    }

    public boolean isIncludeDependencies() {
        return this.includeDependencies;
    }

    public Predicate<String> getClassFilter() {
        return this.classFilter;
    }

    public void setClassFilter(Predicate<String> classFilter) {
        this.classFilter = classFilter;
    }

    public boolean isDeobfuscationOn() {
        return this.deobfuscationOn;
    }

    public void setDeobfuscationOn(boolean deobfuscationOn) {
        this.deobfuscationOn = deobfuscationOn;
    }

    @Deprecated
    public boolean isDeobfuscationForceSave() {
        return this.deobfuscationMapFileMode == DeobfuscationMapFileMode.OVERWRITE;
    }

    @Deprecated
    public void setDeobfuscationForceSave(boolean deobfuscationForceSave) {
        if (deobfuscationForceSave) {
            this.deobfuscationMapFileMode = DeobfuscationMapFileMode.OVERWRITE;
        }
    }

    public DeobfuscationMapFileMode getDeobfuscationMapFileMode() {
        return this.deobfuscationMapFileMode;
    }

    public void setDeobfuscationMapFileMode(DeobfuscationMapFileMode deobfuscationMapFileMode) {
        this.deobfuscationMapFileMode = deobfuscationMapFileMode;
    }

    public boolean isUseSourceNameAsClassAlias() {
        return this.useSourceNameAsClassAlias;
    }

    public void setUseSourceNameAsClassAlias(boolean useSourceNameAsClassAlias) {
        this.useSourceNameAsClassAlias = useSourceNameAsClassAlias;
    }

    public boolean isParseKotlinMetadata() {
        return this.parseKotlinMetadata;
    }

    public void setParseKotlinMetadata(boolean parseKotlinMetadata) {
        this.parseKotlinMetadata = parseKotlinMetadata;
    }

    public int getDeobfuscationMinLength() {
        return this.deobfuscationMinLength;
    }

    public void setDeobfuscationMinLength(int deobfuscationMinLength) {
        this.deobfuscationMinLength = deobfuscationMinLength;
    }

    public int getDeobfuscationMaxLength() {
        return this.deobfuscationMaxLength;
    }

    public void setDeobfuscationMaxLength(int deobfuscationMaxLength) {
        this.deobfuscationMaxLength = deobfuscationMaxLength;
    }

    public File getDeobfuscationMapFile() {
        return this.deobfuscationMapFile;
    }

    public void setDeobfuscationMapFile(File deobfuscationMapFile) {
        this.deobfuscationMapFile = deobfuscationMapFile;
    }

    public ResourceNameSource getResourceNameSource() {
        return this.resourceNameSource;
    }

    public void setResourceNameSource(ResourceNameSource resourceNameSource) {
        this.resourceNameSource = resourceNameSource;
    }

    public boolean isEscapeUnicode() {
        return this.escapeUnicode;
    }

    public void setEscapeUnicode(boolean escapeUnicode) {
        this.escapeUnicode = escapeUnicode;
    }

    public boolean isReplaceConsts() {
        return this.replaceConsts;
    }

    public void setReplaceConsts(boolean replaceConsts) {
        this.replaceConsts = replaceConsts;
    }

    public boolean isRespectBytecodeAccModifiers() {
        return this.respectBytecodeAccModifiers;
    }

    public void setRespectBytecodeAccModifiers(boolean respectBytecodeAccModifiers) {
        this.respectBytecodeAccModifiers = respectBytecodeAccModifiers;
    }

    public boolean isExportAsGradleProject() {
        return this.exportAsGradleProject;
    }

    public void setExportAsGradleProject(boolean exportAsGradleProject) {
        this.exportAsGradleProject = exportAsGradleProject;
    }

    public boolean isFsCaseSensitive() {
        return this.fsCaseSensitive;
    }

    public void setFsCaseSensitive(boolean fsCaseSensitive) {
        this.fsCaseSensitive = fsCaseSensitive;
    }

    public boolean isRenameCaseSensitive() {
        return this.renameFlags.contains((Object)RenameEnum.CASE);
    }

    public void setRenameCaseSensitive(boolean renameCaseSensitive) {
        this.updateRenameFlag(renameCaseSensitive, RenameEnum.CASE);
    }

    public boolean isRenameValid() {
        return this.renameFlags.contains((Object)RenameEnum.VALID);
    }

    public void setRenameValid(boolean renameValid) {
        this.updateRenameFlag(renameValid, RenameEnum.VALID);
    }

    public boolean isRenamePrintable() {
        return this.renameFlags.contains((Object)RenameEnum.PRINTABLE);
    }

    public void setRenamePrintable(boolean renamePrintable) {
        this.updateRenameFlag(renamePrintable, RenameEnum.PRINTABLE);
    }

    private void updateRenameFlag(boolean enabled, RenameEnum flag) {
        if (enabled) {
            this.renameFlags.add(flag);
        } else {
            this.renameFlags.remove((Object)flag);
        }
    }

    public void setRenameFlags(Set<RenameEnum> renameFlags) {
        this.renameFlags = renameFlags;
    }

    public Set<RenameEnum> getRenameFlags() {
        return this.renameFlags;
    }

    public OutputFormatEnum getOutputFormat() {
        return this.outputFormat;
    }

    public boolean isJsonOutput() {
        return this.outputFormat == OutputFormatEnum.JSON;
    }

    public void setOutputFormat(OutputFormatEnum outputFormat) {
        this.outputFormat = outputFormat;
    }

    public DecompilationMode getDecompilationMode() {
        return this.decompilationMode;
    }

    public void setDecompilationMode(DecompilationMode decompilationMode) {
        this.decompilationMode = decompilationMode;
    }

    public ICodeCache getCodeCache() {
        return this.codeCache;
    }

    public void setCodeCache(ICodeCache codeCache) {
        this.codeCache = codeCache;
    }

    public Function<JadxArgs, ICodeWriter> getCodeWriterProvider() {
        return this.codeWriterProvider;
    }

    public void setCodeWriterProvider(Function<JadxArgs, ICodeWriter> codeWriterProvider) {
        this.codeWriterProvider = codeWriterProvider;
    }

    public ICodeData getCodeData() {
        return this.codeData;
    }

    public void setCodeData(ICodeData codeData) {
        this.codeData = codeData;
    }

    public CommentsLevel getCommentsLevel() {
        return this.commentsLevel;
    }

    public void setCommentsLevel(CommentsLevel commentsLevel) {
        this.commentsLevel = commentsLevel;
    }

    public boolean isUseDxInput() {
        return this.useDxInput;
    }

    public void setUseDxInput(boolean useDxInput) {
        this.useDxInput = useDxInput;
    }

    public UseKotlinMethodsForVarNames getUseKotlinMethodsForVarNames() {
        return this.useKotlinMethodsForVarNames;
    }

    public void setUseKotlinMethodsForVarNames(UseKotlinMethodsForVarNames useKotlinMethodsForVarNames) {
        this.useKotlinMethodsForVarNames = useKotlinMethodsForVarNames;
    }

    public boolean isSkipFilesSave() {
        return this.skipFilesSave;
    }

    public void setSkipFilesSave(boolean skipFilesSave) {
        this.skipFilesSave = skipFilesSave;
    }

    public Map<String, String> getPluginOptions() {
        return this.pluginOptions;
    }

    public void setPluginOptions(Map<String, String> pluginOptions) {
        this.pluginOptions = pluginOptions;
    }

    public String makeCodeArgsHash() {
        String argStr = "args:" + (Object)((Object)this.decompilationMode) + this.useImports + this.showInconsistentCode + this.inlineAnonymousClasses + this.inlineMethods + this.deobfuscationOn + this.deobfuscationMinLength + this.deobfuscationMaxLength + (Object)((Object)this.resourceNameSource) + this.parseKotlinMetadata + (Object)((Object)this.useKotlinMethodsForVarNames) + this.insertDebugLines + this.extractFinally + this.debugInfo + this.useSourceNameAsClassAlias + this.escapeUnicode + this.replaceConsts + this.respectBytecodeAccModifiers + this.fsCaseSensitive + this.renameFlags + (Object)((Object)this.commentsLevel) + this.useDxInput + this.pluginOptions;
        return FileUtils.md5Sum(argStr.getBytes(StandardCharsets.US_ASCII));
    }

    public String toString() {
        return "JadxArgs{inputFiles=" + this.inputFiles + ", outDir=" + this.outDir + ", outDirSrc=" + this.outDirSrc + ", outDirRes=" + this.outDirRes + ", threadsCount=" + this.threadsCount + ", decompilationMode=" + (Object)((Object)this.decompilationMode) + ", showInconsistentCode=" + this.showInconsistentCode + ", useImports=" + this.useImports + ", skipResources=" + this.skipResources + ", skipSources=" + this.skipSources + ", includeDependencies=" + this.includeDependencies + ", deobfuscationOn=" + this.deobfuscationOn + ", deobfuscationMapFile=" + this.deobfuscationMapFile + ", deobfuscationMapFileMode=" + (Object)((Object)this.deobfuscationMapFileMode) + ", resourceNameSource=" + (Object)((Object)this.resourceNameSource) + ", useSourceNameAsClassAlias=" + this.useSourceNameAsClassAlias + ", parseKotlinMetadata=" + this.parseKotlinMetadata + ", useKotlinMethodsForVarNames=" + (Object)((Object)this.useKotlinMethodsForVarNames) + ", insertDebugLines=" + this.insertDebugLines + ", extractFinally=" + this.extractFinally + ", deobfuscationMinLength=" + this.deobfuscationMinLength + ", deobfuscationMaxLength=" + this.deobfuscationMaxLength + ", escapeUnicode=" + this.escapeUnicode + ", replaceConsts=" + this.replaceConsts + ", respectBytecodeAccModifiers=" + this.respectBytecodeAccModifiers + ", exportAsGradleProject=" + this.exportAsGradleProject + ", fsCaseSensitive=" + this.fsCaseSensitive + ", renameFlags=" + this.renameFlags + ", outputFormat=" + (Object)((Object)this.outputFormat) + ", commentsLevel=" + (Object)((Object)this.commentsLevel) + ", codeCache=" + this.codeCache + ", codeWriter=" + this.codeWriterProvider.apply(this).getClass().getSimpleName() + ", useDxInput=" + this.useDxInput + ", pluginOptions=" + this.pluginOptions + ", cfgOutput=" + this.cfgOutput + ", rawCFGOutput=" + this.rawCFGOutput + '}';
    }

    public static enum RenameEnum {
        CASE,
        VALID,
        PRINTABLE;

    }

    public static enum OutputFormatEnum {
        JAVA,
        JSON;

    }

    public static enum UseKotlinMethodsForVarNames {
        DISABLE,
        APPLY,
        APPLY_AND_HIDE;

    }
}

