/*
 * Decompiled with CFR 0.152.
 */
package jadx.api;

import jadx.api.ICodeInfo;
import jadx.api.ICodeWriter;
import jadx.api.JadxDecompiler;
import jadx.api.ResourceFile;
import jadx.api.ResourceType;
import jadx.api.impl.SimpleCodeInfo;
import jadx.api.plugins.utils.ZipSecurity;
import jadx.core.dex.nodes.RootNode;
import jadx.core.utils.Utils;
import jadx.core.utils.android.Res9patchStreamDecoder;
import jadx.core.utils.exceptions.JadxException;
import jadx.core.utils.files.FileUtils;
import jadx.core.xmlgen.ResContainer;
import jadx.core.xmlgen.ResProtoParser;
import jadx.core.xmlgen.ResTableParser;
import java.io.BufferedInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.List;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class ResourcesLoader {
    private static final Logger LOG = LoggerFactory.getLogger(ResourcesLoader.class);
    private final JadxDecompiler jadxRef;

    ResourcesLoader(JadxDecompiler jadxRef) {
        this.jadxRef = jadxRef;
    }

    List<ResourceFile> load() {
        List<File> inputFiles = this.jadxRef.getArgs().getInputFiles();
        ArrayList<ResourceFile> list = new ArrayList<ResourceFile>(inputFiles.size());
        for (File file : inputFiles) {
            this.loadFile(list, file);
        }
        return list;
    }

    /*
     * Enabled aggressive exception aggregation
     */
    public static <T> T decodeStream(ResourceFile rf, ResourceDecoder<T> decoder) throws JadxException {
        try {
            ResourceFile.ZipRef zipRef = rf.getZipRef();
            if (zipRef == null) {
                File file = new File(rf.getOriginalName());
                try (BufferedInputStream inputStream = new BufferedInputStream(new FileInputStream(file));){
                    T t = decoder.decode(file.length(), inputStream);
                    return t;
                }
            }
            try (ZipFile zipFile = new ZipFile(zipRef.getZipFile());){
                T t;
                block22: {
                    ZipEntry entry = zipFile.getEntry(zipRef.getEntryName());
                    if (entry == null) {
                        throw new IOException("Zip entry not found: " + zipRef);
                    }
                    if (!ZipSecurity.isValidZipEntry((ZipEntry)entry)) {
                        T t2 = null;
                        return t2;
                    }
                    InputStream inputStream = ZipSecurity.getInputStreamForEntry((ZipFile)zipFile, (ZipEntry)entry);
                    try {
                        t = decoder.decode(entry.getSize(), inputStream);
                        if (inputStream == null) break block22;
                    }
                    catch (Throwable throwable) {
                        if (inputStream != null) {
                            try {
                                inputStream.close();
                            }
                            catch (Throwable throwable2) {
                                throwable.addSuppressed(throwable2);
                            }
                        }
                        throw throwable;
                    }
                    inputStream.close();
                }
                return t;
            }
        }
        catch (Exception e) {
            throw new JadxException("Error decode: " + rf.getDeobfName(), e);
        }
    }

    static ResContainer loadContent(JadxDecompiler jadxRef, ResourceFile rf) {
        try {
            return ResourcesLoader.decodeStream(rf, (size, is) -> ResourcesLoader.loadContent(jadxRef, rf, is));
        }
        catch (JadxException e) {
            LOG.error("Decode error", (Throwable)e);
            ICodeWriter cw = jadxRef.getRoot().makeCodeWriter();
            cw.add("Error decode ").add(rf.getType().toString().toLowerCase());
            Utils.appendStackTrace(cw, e.getCause());
            return ResContainer.textResource(rf.getDeobfName(), cw.finish());
        }
    }

    private static ResContainer loadContent(JadxDecompiler jadxRef, ResourceFile rf, InputStream inputStream) throws IOException {
        RootNode root = jadxRef.getRoot();
        switch (rf.getType()) {
            case MANIFEST: 
            case XML: {
                ICodeInfo content = root.isProto() ? jadxRef.getProtoXmlParser().parse(inputStream) : jadxRef.getBinaryXmlParser().parse(inputStream);
                return ResContainer.textResource(rf.getDeobfName(), content);
            }
            case ARSC: {
                if (root.isProto()) {
                    return new ResProtoParser(root).decodeFiles(inputStream);
                }
                return new ResTableParser(root).decodeFiles(inputStream);
            }
            case IMG: {
                return ResourcesLoader.decodeImage(rf, inputStream);
            }
        }
        return ResContainer.resourceFileLink(rf);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private static ResContainer decodeImage(ResourceFile rf, InputStream inputStream) {
        String name = rf.getOriginalName();
        if (!name.endsWith(".9.png")) return ResContainer.resourceFileLink(rf);
        try (ByteArrayOutputStream os = new ByteArrayOutputStream();){
            Res9patchStreamDecoder decoder = new Res9patchStreamDecoder();
            if (!decoder.decode(inputStream, os)) return ResContainer.resourceFileLink(rf);
            ResContainer resContainer = ResContainer.decodedData(rf.getDeobfName(), os.toByteArray());
            return resContainer;
        }
        catch (Exception e) {
            LOG.error("Failed to decode 9-patch png image, path: {}", (Object)name, (Object)e);
        }
        return ResContainer.resourceFileLink(rf);
    }

    private void loadFile(List<ResourceFile> list, File file) {
        if (file == null || file.isDirectory()) {
            return;
        }
        if (FileUtils.isZipFile(file)) {
            ZipSecurity.visitZipEntries((File)file, (zipFile, entry) -> {
                this.addEntry(list, file, (ZipEntry)entry);
                return null;
            });
        } else {
            ResourceType type = ResourceType.getFileType(file.getAbsolutePath());
            list.add(ResourceFile.createResourceFile(this.jadxRef, file, type));
        }
    }

    private void addEntry(List<ResourceFile> list, File zipFile, ZipEntry entry) {
        ResourceType type;
        if (entry.isDirectory()) {
            return;
        }
        String name = entry.getName();
        ResourceFile rf = ResourceFile.createResourceFile(this.jadxRef, name, type = ResourceType.getFileType(name));
        if (rf != null) {
            rf.setZipRef(new ResourceFile.ZipRef(zipFile, name));
            list.add(rf);
        }
    }

    public static ICodeInfo loadToCodeWriter(InputStream is) throws IOException {
        ByteArrayOutputStream baos = new ByteArrayOutputStream(8192);
        FileUtils.copyStream(is, baos);
        return new SimpleCodeInfo(baos.toString("UTF-8"));
    }

    public static interface ResourceDecoder<T> {
        public T decode(long var1, InputStream var3) throws IOException;
    }
}

