/*
 * Decompiled with CFR 0.152.
 */
package jadx.core.codegen;

import jadx.api.CommentsLevel;
import jadx.api.ICodeInfo;
import jadx.api.ICodeWriter;
import jadx.api.JadxArgs;
import jadx.api.metadata.annotations.NodeEnd;
import jadx.api.plugins.input.data.annotations.EncodedType;
import jadx.api.plugins.input.data.annotations.EncodedValue;
import jadx.api.plugins.input.data.attributes.JadxAttrType;
import jadx.core.codegen.AnnotationGen;
import jadx.core.codegen.InsnGen;
import jadx.core.codegen.MethodGen;
import jadx.core.codegen.NameGen;
import jadx.core.codegen.TypeGen;
import jadx.core.dex.attributes.AFlag;
import jadx.core.dex.attributes.AType;
import jadx.core.dex.attributes.FieldInitInsnAttr;
import jadx.core.dex.attributes.nodes.EnumClassAttr;
import jadx.core.dex.attributes.nodes.LineAttrNode;
import jadx.core.dex.attributes.nodes.MethodInlineAttr;
import jadx.core.dex.attributes.nodes.SkipMethodArgsAttr;
import jadx.core.dex.info.AccessInfo;
import jadx.core.dex.info.ClassInfo;
import jadx.core.dex.instructions.args.ArgType;
import jadx.core.dex.instructions.args.LiteralArg;
import jadx.core.dex.instructions.args.PrimitiveType;
import jadx.core.dex.instructions.mods.ConstructorInsn;
import jadx.core.dex.nodes.ClassNode;
import jadx.core.dex.nodes.FieldNode;
import jadx.core.dex.nodes.InsnNode;
import jadx.core.dex.nodes.MethodNode;
import jadx.core.dex.nodes.RootNode;
import jadx.core.utils.CodeGenUtils;
import jadx.core.utils.EncodedValueUtils;
import jadx.core.utils.Utils;
import jadx.core.utils.android.AndroidResourcesUtils;
import jadx.core.utils.exceptions.CodegenException;
import jadx.core.utils.exceptions.JadxRuntimeException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ClassGen {
    private final ClassNode cls;
    private final ClassGen parentGen;
    private final AnnotationGen annotationGen;
    private final boolean fallback;
    private final boolean useImports;
    private final boolean showInconsistentCode;
    private final Set<ClassInfo> imports = new HashSet<ClassInfo>();
    private int clsDeclOffset;
    private boolean bodyGenStarted;
    @Nullable
    private NameGen outerNameGen;

    public ClassGen(ClassNode cls, JadxArgs jadxArgs) {
        this(cls, null, jadxArgs.isUseImports(), jadxArgs.isFallbackMode(), jadxArgs.isShowInconsistentCode());
    }

    public ClassGen(ClassNode cls, ClassGen parentClsGen) {
        this(cls, parentClsGen, parentClsGen.useImports, parentClsGen.fallback, parentClsGen.showInconsistentCode);
    }

    public ClassGen(ClassNode cls, ClassGen parentClsGen, boolean useImports, boolean fallback, boolean showBadCode) {
        this.cls = cls;
        this.parentGen = parentClsGen;
        this.fallback = fallback;
        this.useImports = useImports;
        this.showInconsistentCode = showBadCode;
        this.annotationGen = new AnnotationGen(cls, this);
    }

    public ClassNode getClassNode() {
        return this.cls;
    }

    public ICodeInfo makeClass() throws CodegenException {
        int importsCount;
        ICodeWriter clsBody = this.cls.root().makeCodeWriter();
        this.addClassCode(clsBody);
        ICodeWriter clsCode = this.cls.root().makeCodeWriter();
        if (!"".equals(this.cls.getPackage())) {
            clsCode.add("package ").add(this.cls.getPackage()).add(';');
            clsCode.newLine();
        }
        if ((importsCount = this.imports.size()) != 0) {
            ArrayList<ClassInfo> sortedImports = new ArrayList<ClassInfo>(this.imports);
            sortedImports.sort(Comparator.comparing(ClassInfo::getAliasFullName));
            sortedImports.forEach(classInfo -> {
                clsCode.startLine("import ");
                ClassNode classNode = this.cls.root().resolveClass((ClassInfo)classInfo);
                if (classNode != null) {
                    clsCode.attachAnnotation(classNode);
                }
                clsCode.add(classInfo.getAliasFullName());
                clsCode.add(';');
            });
            clsCode.newLine();
            this.imports.clear();
        }
        clsCode.add(clsBody);
        return clsCode.finish();
    }

    public void addClassCode(ICodeWriter code) throws CodegenException {
        if (this.cls.contains(AFlag.DONT_GENERATE)) {
            return;
        }
        CodeGenUtils.addErrorsAndComments(code, this.cls);
        CodeGenUtils.addSourceFileInfo(code, this.cls);
        this.addClassDeclaration(code);
        this.addClassBody(code);
    }

    public void addClassDeclaration(ICodeWriter clsCode) {
        AccessInfo af = this.cls.getAccessFlags();
        if (af.isInterface()) {
            af = af.remove(1024).remove(8);
        } else if (af.isEnum()) {
            af = af.remove(16).remove(1024).remove(8);
        }
        if (!this.cls.getClassInfo().isInner()) {
            af = af.remove(8).remove(2);
        }
        this.annotationGen.addForClass(clsCode);
        this.insertRenameInfo(clsCode, this.cls);
        CodeGenUtils.addInputFileInfo(clsCode, this.cls);
        clsCode.startLineWithNum(this.cls.getSourceLine()).add(af.makeString(this.cls.checkCommentsLevel(CommentsLevel.INFO)));
        if (af.isInterface()) {
            if (af.isAnnotation()) {
                clsCode.add('@');
            }
            clsCode.add("interface ");
        } else if (af.isEnum()) {
            clsCode.add("enum ");
        } else {
            clsCode.add("class ");
        }
        clsCode.attachDefinition(this.cls);
        clsCode.add(this.cls.getClassInfo().getAliasShortName());
        this.addGenericTypeParameters(clsCode, this.cls.getGenericTypeParameters(), true);
        clsCode.add(' ');
        ArgType sup = this.cls.getSuperClass();
        if (sup != null && !sup.equals(ArgType.OBJECT) && !this.cls.contains(AFlag.REMOVE_SUPER_CLASS)) {
            clsCode.add("extends ");
            this.useClass(clsCode, sup);
            clsCode.add(' ');
        }
        if (!this.cls.getInterfaces().isEmpty() && !af.isAnnotation()) {
            if (this.cls.getAccessFlags().isInterface()) {
                clsCode.add("extends ");
            } else {
                clsCode.add("implements ");
            }
            Iterator<ArgType> it = this.cls.getInterfaces().iterator();
            while (it.hasNext()) {
                ArgType interf = it.next();
                this.useClass(clsCode, interf);
                if (!it.hasNext()) continue;
                clsCode.add(", ");
            }
            if (!this.cls.getInterfaces().isEmpty()) {
                clsCode.add(' ');
            }
        }
    }

    public boolean addGenericTypeParameters(ICodeWriter code, List<ArgType> generics, boolean classDeclaration) {
        if (generics == null || generics.isEmpty()) {
            return false;
        }
        code.add('<');
        int i = 0;
        for (ArgType genericInfo : generics) {
            if (i != 0) {
                code.add(", ");
            }
            if (genericInfo.isGenericType()) {
                code.add(genericInfo.getObject());
            } else {
                this.useClass(code, genericInfo);
            }
            List<ArgType> list = genericInfo.getExtendTypes();
            if (list != null && !list.isEmpty()) {
                code.add(" extends ");
                Iterator<ArgType> it = list.iterator();
                while (it.hasNext()) {
                    ArgType g = it.next();
                    if (g.isGenericType()) {
                        code.add(g.getObject());
                    } else {
                        this.useClass(code, g);
                        if (classDeclaration && !this.cls.getClassInfo().isInner() && this.cls.root().getArgs().isUseImports()) {
                            this.addImport(ClassInfo.fromType(this.cls.root(), g));
                        }
                    }
                    if (!it.hasNext()) continue;
                    code.add(" & ");
                }
            }
            ++i;
        }
        code.add('>');
        return true;
    }

    public void addClassBody(ICodeWriter clsCode) throws CodegenException {
        this.addClassBody(clsCode, false);
    }

    public void addClassBody(ICodeWriter clsCode, boolean printClassName) throws CodegenException {
        clsCode.add('{');
        if (printClassName && this.cls.checkCommentsLevel(CommentsLevel.INFO)) {
            clsCode.add(" // from class: " + this.cls.getClassInfo().getFullName());
        }
        this.setBodyGenStarted(true);
        this.clsDeclOffset = clsCode.getLength();
        clsCode.incIndent();
        this.addFields(clsCode);
        this.addInnerClsAndMethods(clsCode);
        clsCode.decIndent();
        clsCode.startLine('}');
        clsCode.attachAnnotation(NodeEnd.VALUE);
    }

    private void addInnerClsAndMethods(ICodeWriter clsCode) {
        Stream.of(this.cls.getInnerClasses(), this.cls.getMethods()).flatMap(Collection::stream).filter(node -> !node.contains(AFlag.DONT_GENERATE) || this.fallback).sorted(Comparator.comparingInt(rec$ -> ((LineAttrNode)rec$).getSourceLine())).forEach(node -> {
            if (node instanceof ClassNode) {
                this.addInnerClass(clsCode, (ClassNode)node);
            } else {
                this.addMethod(clsCode, (MethodNode)node);
            }
        });
    }

    private void addInnerClass(ICodeWriter code, ClassNode innerCls) {
        try {
            ClassGen inClGen = new ClassGen(innerCls, this.getParentGen());
            code.newLine();
            inClGen.addClassCode(code);
            this.imports.addAll(inClGen.getImports());
        }
        catch (Exception e) {
            innerCls.addError("Inner class code generation error", e);
        }
    }

    private boolean isInnerClassesPresents() {
        for (ClassNode innerCls : this.cls.getInnerClasses()) {
            if (innerCls.contains(AType.ANONYMOUS_CLASS)) continue;
            return true;
        }
        return false;
    }

    private void addMethod(ICodeWriter code, MethodNode mth) {
        if (this.skipMethod(mth)) {
            return;
        }
        if (code.getLength() != this.clsDeclOffset) {
            code.newLine();
        }
        int savedIndent = code.getIndent();
        try {
            this.addMethodCode(code, mth);
        }
        catch (Exception e) {
            if (mth.getParentClass().getTopParentClass().contains(AFlag.RESTART_CODEGEN)) {
                throw new JadxRuntimeException("Method generation error", e);
            }
            mth.addError("Method generation error", e);
            CodeGenUtils.addErrors(code, mth);
            code.setIndent(savedIndent);
        }
    }

    private boolean skipMethod(MethodNode mth) {
        MethodInlineAttr inlineAttr = mth.get(AType.METHOD_INLINE);
        if (inlineAttr == null || inlineAttr.notNeeded()) {
            return false;
        }
        try {
            if (mth.getUseIn().isEmpty()) {
                mth.add(AFlag.DONT_GENERATE);
                return true;
            }
            List useInCompleted = mth.getUseIn().stream().filter(m -> m.getTopParentClass().getState().isProcessComplete()).collect(Collectors.toList());
            if (useInCompleted.isEmpty()) {
                mth.add(AFlag.DONT_GENERATE);
                return true;
            }
            mth.addDebugComment("Method not inlined, still used in: " + useInCompleted);
            return false;
        }
        catch (Exception e) {
            mth.addWarnComment("Failed to check method usage", e);
            return false;
        }
    }

    private boolean isMethodsPresents() {
        for (MethodNode mth : this.cls.getMethods()) {
            if (mth.contains(AFlag.DONT_GENERATE)) continue;
            return true;
        }
        return false;
    }

    public void addMethodCode(ICodeWriter code, MethodNode mth) throws CodegenException {
        CodeGenUtils.addErrorsAndComments(code, mth);
        if (mth.isNoCode()) {
            MethodGen mthGen = new MethodGen(this, mth);
            mthGen.addDefinition(code);
            code.add(';');
        } else {
            MethodGen mthGen;
            boolean badCode = mth.contains(AFlag.INCONSISTENT_CODE);
            if (badCode && this.showInconsistentCode) {
                badCode = false;
            }
            if ((mthGen = badCode || this.fallback || mth.contains(AType.JADX_ERROR) ? MethodGen.getFallbackMethodGen(mth) : new MethodGen(this, mth)).addDefinition(code)) {
                code.add(' ');
            }
            code.add('{');
            code.incIndent();
            mthGen.addInstructions(code);
            code.decIndent();
            code.startLine('}');
            code.attachAnnotation(NodeEnd.VALUE);
        }
    }

    private void addFields(ICodeWriter code) throws CodegenException {
        this.addEnumFields(code);
        for (FieldNode f : this.cls.getFields()) {
            this.addField(code, f);
        }
    }

    public void addField(ICodeWriter code, FieldNode f) {
        if (f.contains(AFlag.DONT_GENERATE)) {
            return;
        }
        CodeGenUtils.addComments(code, f);
        this.annotationGen.addForField(code, f);
        boolean addInfoComments = f.checkCommentsLevel(CommentsLevel.INFO);
        if (f.getFieldInfo().isRenamed() && addInfoComments) {
            code.newLine();
            CodeGenUtils.addRenamedComment(code, f, f.getName());
        }
        code.startLine(f.getAccessFlags().makeString(addInfoComments));
        this.useType(code, f.getType());
        code.add(' ');
        code.attachDefinition(f);
        code.add(f.getAlias());
        FieldInitInsnAttr initInsnAttr = f.get(AType.FIELD_INIT_INSN);
        if (initInsnAttr != null) {
            InsnGen insnGen = this.makeInsnGen(initInsnAttr.getInsnMth());
            code.add(" = ");
            this.addInsnBody(insnGen, code, initInsnAttr.getInsn());
        } else {
            EncodedValue constVal = (EncodedValue)f.get(JadxAttrType.CONSTANT_VALUE);
            if (constVal != null) {
                code.add(" = ");
                if (constVal.getType() == EncodedType.ENCODED_NULL) {
                    code.add(TypeGen.literalToString(0L, f.getType(), this.cls, this.fallback));
                } else {
                    Object val = EncodedValueUtils.convertToConstValue(constVal);
                    if (val instanceof LiteralArg) {
                        long lit = ((LiteralArg)val).getLiteral();
                        if (!AndroidResourcesUtils.handleResourceFieldValue(this.cls, code, lit, f.getType())) {
                            code.add(TypeGen.literalToString(lit, f.getType(), this.cls, this.fallback));
                        }
                    } else {
                        this.annotationGen.encodeValue(this.cls.root(), code, constVal);
                    }
                }
            }
        }
        code.add(';');
    }

    private boolean isFieldsPresents() {
        for (FieldNode field : this.cls.getFields()) {
            if (field.contains(AFlag.DONT_GENERATE)) continue;
            return true;
        }
        return false;
    }

    private void addEnumFields(ICodeWriter code) throws CodegenException {
        EnumClassAttr enumFields = this.cls.get(AType.ENUM_CLASS);
        if (enumFields == null) {
            return;
        }
        InsnGen igen = null;
        Iterator<EnumClassAttr.EnumField> it = enumFields.getFields().iterator();
        while (it.hasNext()) {
            EnumClassAttr.EnumField f = it.next();
            CodeGenUtils.addComments(code, f.getField());
            code.startLine(f.getField().getAlias());
            ConstructorInsn constrInsn = f.getConstrInsn();
            MethodNode callMth = this.cls.root().resolveMethod(constrInsn.getCallMth());
            int skipCount = this.getEnumCtrSkipArgsCount(callMth);
            if (constrInsn.getArgsCount() > skipCount) {
                if (igen == null) {
                    igen = this.makeInsnGen(enumFields.getStaticMethod());
                }
                igen.generateMethodArguments(code, constrInsn, 0, callMth);
            }
            if (f.getCls() != null) {
                code.add(' ');
                new ClassGen(f.getCls(), this).addClassBody(code, true);
            }
            if (!it.hasNext()) continue;
            code.add(',');
        }
        if (this.isMethodsPresents() || this.isFieldsPresents() || this.isInnerClassesPresents()) {
            if (enumFields.getFields().isEmpty()) {
                code.startLine();
            }
            code.add(';');
            if (this.isFieldsPresents()) {
                code.startLine();
            }
        }
    }

    private int getEnumCtrSkipArgsCount(@Nullable MethodNode callMth) {
        SkipMethodArgsAttr skipArgsAttr;
        if (callMth != null && (skipArgsAttr = callMth.get(AType.SKIP_MTH_ARGS)) != null) {
            return skipArgsAttr.getSkipCount();
        }
        return 0;
    }

    private InsnGen makeInsnGen(MethodNode mth) {
        MethodGen mthGen = new MethodGen(this, mth);
        return new InsnGen(mthGen, false);
    }

    private void addInsnBody(InsnGen insnGen, ICodeWriter code, InsnNode insn) {
        try {
            insnGen.makeInsn(insn, code, InsnGen.Flags.BODY_ONLY_NOWRAP);
        }
        catch (Exception e) {
            this.cls.addError("Failed to generate init code", e);
        }
    }

    public void useType(ICodeWriter code, ArgType type) {
        PrimitiveType stype = type.getPrimitiveType();
        if (stype == null) {
            code.add(type.toString());
        } else if (stype == PrimitiveType.OBJECT) {
            if (type.isGenericType()) {
                code.add(type.getObject());
            } else {
                this.useClass(code, type);
            }
        } else if (stype == PrimitiveType.ARRAY) {
            this.useType(code, type.getArrayElement());
            code.add("[]");
        } else {
            code.add(stype.getLongName());
        }
    }

    public void useClass(ICodeWriter code, String rawCls) {
        this.useClass(code, ArgType.object(rawCls));
    }

    public void useClass(ICodeWriter code, ArgType type) {
        ArgType outerType = type.getOuterType();
        if (outerType != null) {
            this.useClass(code, outerType);
            code.add('.');
            this.addInnerType(code, type);
            return;
        }
        this.useClass(code, ClassInfo.fromType(this.cls.root(), type));
        this.addGenerics(code, type);
    }

    private void addInnerType(ICodeWriter code, ArgType baseType) {
        ArgType innerType = baseType.getInnerType();
        ArgType outerType = innerType.getOuterType();
        if (outerType != null) {
            this.useClassWithShortName(code, baseType, outerType);
            code.add('.');
            this.addInnerType(code, innerType);
            return;
        }
        this.useClassWithShortName(code, baseType, innerType);
    }

    private void useClassWithShortName(ICodeWriter code, ArgType baseType, ArgType type) {
        String fullNameObj = type.getObject().contains(".") ? type.getObject() : baseType.getObject();
        ClassInfo classInfo = ClassInfo.fromName(this.cls.root(), fullNameObj);
        ClassNode classNode = this.cls.root().resolveClass(classInfo);
        if (classNode != null) {
            code.attachAnnotation(classNode);
        }
        code.add(classInfo.getAliasShortName());
        this.addGenerics(code, type);
    }

    private void addGenerics(ICodeWriter code, ArgType type) {
        List<ArgType> generics = type.getGenericTypes();
        if (generics != null) {
            code.add('<');
            int len = generics.size();
            for (int i = 0; i < len; ++i) {
                ArgType gt;
                ArgType wt;
                if (i != 0) {
                    code.add(", ");
                }
                if ((wt = (gt = generics.get(i)).getWildcardType()) != null) {
                    ArgType.WildcardBound bound = gt.getWildcardBound();
                    code.add(bound.getStr());
                    if (bound == ArgType.WildcardBound.UNBOUND) continue;
                    this.useType(code, wt);
                    continue;
                }
                this.useType(code, gt);
            }
            code.add('>');
        }
    }

    public void useClass(ICodeWriter code, ClassInfo classInfo) {
        ClassNode classNode = this.cls.root().resolveClass(classInfo);
        if (classNode != null) {
            this.useClass(code, classNode);
        } else {
            this.addClsName(code, classInfo);
        }
    }

    public void useClass(ICodeWriter code, ClassNode classNode) {
        code.attachAnnotation(classNode);
        this.addClsName(code, classNode.getClassInfo());
    }

    public void addClsName(ICodeWriter code, ClassInfo classInfo) {
        String clsName = this.useClassInternal(this.cls.getClassInfo(), classInfo);
        code.add(clsName);
    }

    private String useClassInternal(ClassInfo useCls, ClassInfo extClsInfo) {
        String fullName = extClsInfo.getAliasFullName();
        if (this.fallback || !this.useImports) {
            return fullName;
        }
        String shortName = extClsInfo.getAliasShortName();
        if (useCls.equals(extClsInfo)) {
            return shortName;
        }
        if (ClassGen.isClassInnerFor(useCls, extClsInfo)) {
            return shortName;
        }
        if (extClsInfo.isInner()) {
            return this.expandInnerClassName(useCls, extClsInfo);
        }
        if (ClassGen.checkInnerCollision(this.cls.root(), useCls, extClsInfo) || ClassGen.checkInPackageCollision(this.cls.root(), useCls, extClsInfo)) {
            return fullName;
        }
        if (ClassGen.isBothClassesInOneTopClass(useCls, extClsInfo)) {
            return shortName;
        }
        if (extClsInfo.getPackage().equals("java.lang") && extClsInfo.getParentClass() == null) {
            return shortName;
        }
        if (extClsInfo.getPackage().equals(useCls.getPackage()) && !extClsInfo.isInner()) {
            return shortName;
        }
        if (extClsInfo.isDefaultPackage()) {
            return shortName;
        }
        if (extClsInfo.getAliasPkg().equals(useCls.getAliasPkg())) {
            fullName = extClsInfo.getAliasNameWithoutPackage();
        }
        for (ClassInfo importCls : this.getImports()) {
            if (importCls.equals(extClsInfo) || !importCls.getAliasShortName().equals(shortName)) continue;
            if (extClsInfo.isInner()) {
                String parent = this.useClassInternal(useCls, extClsInfo.getParentClass());
                return parent + '.' + shortName;
            }
            return fullName;
        }
        this.addImport(extClsInfo);
        return shortName;
    }

    private String expandInnerClassName(ClassInfo useCls, ClassInfo extClsInfo) {
        ArrayList<ClassInfo> clsList = new ArrayList<ClassInfo>();
        clsList.add(extClsInfo);
        boolean addImport = true;
        for (ClassInfo parentCls = extClsInfo.getParentClass(); parentCls != null; parentCls = parentCls.getParentClass()) {
            if (parentCls == useCls || ClassGen.isClassInnerFor(useCls, parentCls)) {
                addImport = false;
                break;
            }
            clsList.add(parentCls);
        }
        Collections.reverse(clsList);
        if (addImport) {
            this.addImport((ClassInfo)clsList.get(0));
        }
        return Utils.listToString(clsList, ".", ClassInfo::getAliasShortName);
    }

    private void addImport(ClassInfo classInfo) {
        if (this.parentGen != null) {
            this.parentGen.addImport(classInfo);
        } else {
            this.imports.add(classInfo);
        }
    }

    public Set<ClassInfo> getImports() {
        if (this.parentGen != null) {
            return this.parentGen.getImports();
        }
        return this.imports;
    }

    private static boolean isBothClassesInOneTopClass(ClassInfo useCls, ClassInfo extClsInfo) {
        ClassInfo a = useCls.getTopParentClass();
        ClassInfo b = extClsInfo.getTopParentClass();
        if (a != null) {
            return a.equals(b);
        }
        return useCls.equals(b);
    }

    private static boolean isClassInnerFor(ClassInfo inner, ClassInfo parent) {
        if (inner.isInner()) {
            ClassInfo p = inner.getParentClass();
            return Objects.equals(p, parent) || ClassGen.isClassInnerFor(p, parent);
        }
        return false;
    }

    private static boolean checkInnerCollision(RootNode root, @Nullable ClassInfo useCls, ClassInfo searchCls) {
        if (useCls == null) {
            return false;
        }
        String shortName = searchCls.getAliasShortName();
        if (useCls.getAliasShortName().equals(shortName)) {
            return true;
        }
        ClassNode classNode = root.resolveClass(useCls);
        if (classNode != null) {
            for (ClassNode inner : classNode.getInnerClasses()) {
                if (!inner.getShortName().equals(shortName) || inner.getFullName().equals(searchCls.getAliasFullName())) continue;
                return true;
            }
        }
        return ClassGen.checkInnerCollision(root, useCls.getParentClass(), searchCls);
    }

    private static boolean checkInPackageCollision(RootNode root, ClassInfo useCls, ClassInfo searchCls) {
        String currentPkg = useCls.getAliasPkg();
        if (currentPkg.equals(searchCls.getAliasPkg())) {
            return false;
        }
        String shortName = searchCls.getAliasShortName();
        return root.getClsp().isClsKnown(currentPkg + '.' + shortName);
    }

    private void insertRenameInfo(ICodeWriter code, ClassNode cls) {
        ClassInfo classInfo = cls.getClassInfo();
        if (classInfo.hasAlias() && cls.checkCommentsLevel(CommentsLevel.INFO)) {
            CodeGenUtils.addRenamedComment(code, cls, classInfo.getType().getObject());
        }
    }

    private static void addClassUsageInfo(ICodeWriter code, ClassNode cls) {
        List<ClassNode> deps = cls.getDependencies();
        code.startLine("// deps - ").add(Integer.toString(deps.size()));
        for (ClassNode classNode : deps) {
            code.startLine("//  ").add(classNode.getClassInfo().getFullName());
        }
        List<ClassNode> useIn = cls.getUseIn();
        code.startLine("// use in - ").add(Integer.toString(useIn.size()));
        for (ClassNode useCls : useIn) {
            code.startLine("//  ").add(useCls.getClassInfo().getFullName());
        }
        List<MethodNode> list = cls.getUseInMth();
        code.startLine("// use in methods - ").add(Integer.toString(list.size()));
        for (MethodNode useMth : list) {
            code.startLine("//  ").add(useMth.toString());
        }
    }

    static void addMthUsageInfo(ICodeWriter code, MethodNode mth) {
        List<MethodNode> useInMths = mth.getUseIn();
        code.startLine("// use in methods - ").add(Integer.toString(useInMths.size()));
        for (MethodNode useMth : useInMths) {
            code.startLine("//  ").add(useMth.toString());
        }
    }

    private static void addFieldUsageInfo(ICodeWriter code, FieldNode fieldNode) {
        List<MethodNode> useInMths = fieldNode.getUseIn();
        code.startLine("// use in methods - ").add(Integer.toString(useInMths.size()));
        for (MethodNode useMth : useInMths) {
            code.startLine("//  ").add(useMth.toString());
        }
    }

    public ClassGen getParentGen() {
        return this.parentGen == null ? this : this.parentGen;
    }

    public AnnotationGen getAnnotationGen() {
        return this.annotationGen;
    }

    public boolean isFallbackMode() {
        return this.fallback;
    }

    public boolean isBodyGenStarted() {
        return this.bodyGenStarted;
    }

    public void setBodyGenStarted(boolean bodyGenStarted) {
        this.bodyGenStarted = bodyGenStarted;
    }

    @Nullable
    public NameGen getOuterNameGen() {
        return this.outerNameGen;
    }

    public void setOuterNameGen(@NotNull NameGen outerNameGen) {
        this.outerNameGen = outerNameGen;
    }
}

