/*
 * Decompiled with CFR 0.152.
 */
package jadx.core.deobf;

import jadx.core.deobf.Deobfuscator;
import jadx.core.utils.exceptions.JadxRuntimeException;
import java.io.BufferedReader;
import java.io.InputStreamReader;
import java.util.HashSet;
import java.util.Set;

public class TldHelper {
    private static final Set<String> TLD_SET = TldHelper.loadTldFile();

    private static Set<String> loadTldFile() {
        HashSet<String> hashSet;
        HashSet<String> tldNames = new HashSet<String>();
        BufferedReader reader = new BufferedReader(new InputStreamReader(Deobfuscator.class.getResourceAsStream("tld_3.txt")));
        try {
            String line;
            while ((line = reader.readLine()) != null) {
                if ((line = line.trim()).startsWith("#") || line.isEmpty()) continue;
                tldNames.add(line);
            }
            hashSet = tldNames;
        }
        catch (Throwable throwable) {
            try {
                try {
                    reader.close();
                }
                catch (Throwable throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
            catch (Exception e) {
                throw new JadxRuntimeException("Failed to load top level domain list tld_3.txt", e);
            }
        }
        reader.close();
        return hashSet;
    }

    public static boolean contains(String name) {
        return TLD_SET.contains(name);
    }
}

