/*
 * Decompiled with CFR 0.152.
 */
package jadx.core.dex.visitors;

import jadx.api.plugins.input.data.attributes.IJadxAttribute;
import jadx.api.plugins.input.data.attributes.JadxAttrType;
import jadx.core.dex.attributes.AFlag;
import jadx.core.dex.attributes.AType;
import jadx.core.dex.attributes.FieldInitInsnAttr;
import jadx.core.dex.info.AccessInfo;
import jadx.core.dex.info.FieldInfo;
import jadx.core.dex.instructions.IndexInsnNode;
import jadx.core.dex.instructions.InsnType;
import jadx.core.dex.instructions.args.InsnArg;
import jadx.core.dex.instructions.args.InsnWrapArg;
import jadx.core.dex.instructions.args.RegisterArg;
import jadx.core.dex.nodes.BlockNode;
import jadx.core.dex.nodes.ClassNode;
import jadx.core.dex.nodes.FieldNode;
import jadx.core.dex.nodes.InsnNode;
import jadx.core.dex.nodes.MethodNode;
import jadx.core.dex.visitors.AbstractVisitor;
import jadx.core.dex.visitors.ClassModifier;
import jadx.core.dex.visitors.JadxVisitor;
import jadx.core.dex.visitors.ModVisitor;
import jadx.core.dex.visitors.shrink.CodeShrinkVisitor;
import jadx.core.utils.BlockUtils;
import jadx.core.utils.InsnRemover;
import jadx.core.utils.ListUtils;
import jadx.core.utils.Utils;
import jadx.core.utils.exceptions.JadxException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;

@JadxVisitor(name="ExtractFieldInit", desc="Move duplicated field initialization from constructors", runAfter={ModVisitor.class}, runBefore={ClassModifier.class})
public class ExtractFieldInit
extends AbstractVisitor {
    @Override
    public boolean visit(ClassNode cls) throws JadxException {
        for (ClassNode inner : cls.getInnerClasses()) {
            this.visit(inner);
        }
        if (!cls.getFields().isEmpty()) {
            ExtractFieldInit.moveStaticFieldsInit(cls);
            ExtractFieldInit.moveCommonFieldsInit(cls);
        }
        return false;
    }

    private static void moveStaticFieldsInit(ClassNode cls) {
        MethodNode classInitMth = cls.getClassInitMth();
        if (classInitMth == null || !classInitMth.getAccessFlags().isStatic() || classInitMth.isNoCode() || classInitMth.getBasicBlocks() == null) {
            return;
        }
        if (ListUtils.noneMatch(cls.getFields(), FieldNode::isStatic)) {
            return;
        }
        while (ExtractFieldInit.processStaticFields(cls, classInitMth)) {
            CodeShrinkVisitor.shrinkMethod(classInitMth);
        }
    }

    private static boolean processStaticFields(ClassNode cls, MethodNode classInitMth) {
        List<FieldInitInfo> inits = ExtractFieldInit.collectFieldsInit(cls, classInitMth, InsnType.SPUT);
        if (inits.isEmpty()) {
            return false;
        }
        for (FieldInitInfo fieldInit : inits) {
            FieldNode field = fieldInit.fieldNode;
            if (!field.getAccessFlags().isFinal()) continue;
            field.remove(JadxAttrType.CONSTANT_VALUE);
        }
        ExtractFieldInit.filterFieldsInit(inits);
        if (inits.isEmpty()) {
            return false;
        }
        for (FieldInitInfo fieldInit : inits) {
            IndexInsnNode insn = fieldInit.putInsn;
            InsnArg arg = insn.getArg(0);
            if (arg instanceof InsnWrapArg) {
                ((InsnWrapArg)arg).getWrapInsn().add(AFlag.DECLARE_VAR);
            }
            InsnRemover.remove(classInitMth, insn);
            ExtractFieldInit.addFieldInitAttr(classInitMth, fieldInit.fieldNode, insn);
        }
        ExtractFieldInit.fixFieldsOrder(cls, inits);
        return true;
    }

    private static void moveCommonFieldsInit(ClassNode cls) {
        if (ListUtils.noneMatch(cls.getFields(), FieldNode::isInstance)) {
            return;
        }
        List<MethodNode> constructors = ExtractFieldInit.getConstructorsList(cls);
        if (constructors.isEmpty()) {
            return;
        }
        ArrayList<ConstructorInitInfo> infoList = new ArrayList<ConstructorInitInfo>(constructors.size());
        for (MethodNode constructorMth : constructors) {
            List<FieldInitInfo> inits = ExtractFieldInit.collectFieldsInit(cls, constructorMth, InsnType.IPUT);
            ExtractFieldInit.filterFieldsInit(inits);
            if (inits.isEmpty()) {
                return;
            }
            infoList.add(new ConstructorInitInfo(constructorMth, inits));
        }
        ConstructorInitInfo common = null;
        for (ConstructorInitInfo info : infoList) {
            if (common == null) {
                common = info;
                continue;
            }
            if (ExtractFieldInit.compareFieldInits(common.fieldInits, info.fieldInits)) continue;
            return;
        }
        if (common == null) {
            return;
        }
        for (ConstructorInitInfo info : infoList) {
            for (FieldInitInfo fieldInit : info.fieldInits) {
                IndexInsnNode putInsn = fieldInit.putInsn;
                InsnArg arg = putInsn.getArg(0);
                if (arg instanceof InsnWrapArg) {
                    ((InsnWrapArg)arg).getWrapInsn().add(AFlag.DECLARE_VAR);
                }
                InsnRemover.remove(info.constructorMth, putInsn);
            }
        }
        for (FieldInitInfo fieldInit : common.fieldInits) {
            ExtractFieldInit.addFieldInitAttr(common.constructorMth, fieldInit.fieldNode, fieldInit.putInsn);
        }
        ExtractFieldInit.fixFieldsOrder(cls, common.fieldInits);
    }

    private static List<FieldInitInfo> collectFieldsInit(ClassNode cls, MethodNode mth, InsnType putType) {
        ArrayList<FieldInitInfo> fieldsInit = new ArrayList<FieldInitInfo>();
        HashSet singlePathBlocks = new HashSet();
        BlockUtils.visitSinglePath(mth.getEnterBlock(), singlePathBlocks::add);
        boolean canReorder = true;
        for (BlockNode block : mth.getBasicBlocks()) {
            for (InsnNode insn : block.getInstructions()) {
                FieldNode fn;
                IndexInsnNode putInsn;
                FieldInfo field;
                boolean fieldInsn = false;
                if (insn.getType() == putType && (field = (FieldInfo)(putInsn = (IndexInsnNode)insn).getIndex()).getDeclClass().equals(cls.getClassInfo()) && (fn = cls.searchField(field)) != null) {
                    boolean canMove = canReorder && singlePathBlocks.contains(block);
                    fieldsInit.add(new FieldInitInfo(fn, putInsn, canMove));
                    fieldInsn = true;
                }
                if (fieldInsn || !canReorder || insn.canReorder()) continue;
                canReorder = false;
            }
        }
        return fieldsInit;
    }

    private static void filterFieldsInit(List<FieldInitInfo> inits) {
        Set<FieldInfo> excludedFields = inits.stream().collect(Collectors.toMap(fi -> fi.fieldNode, fi -> 1, Integer::sum)).entrySet().stream().filter(v -> (Integer)v.getValue() > 1).map(v -> ((FieldNode)v.getKey()).getFieldInfo()).collect(Collectors.toSet());
        for (FieldInitInfo initInfo : inits) {
            if (ExtractFieldInit.checkInsn(initInfo)) continue;
            excludedFields.add(initInfo.fieldNode.getFieldInfo());
        }
        if (!excludedFields.isEmpty()) {
            boolean changed;
            do {
                changed = false;
                for (FieldInitInfo initInfo : inits) {
                    FieldInfo fieldInfo = initInfo.fieldNode.getFieldInfo();
                    if (excludedFields.contains(fieldInfo) || !ExtractFieldInit.insnUseExcludedField(initInfo, excludedFields)) continue;
                    excludedFields.add(fieldInfo);
                    changed = true;
                }
            } while (changed);
        }
        if (!excludedFields.isEmpty()) {
            inits.removeIf(fi -> excludedFields.contains(fi.fieldNode.getFieldInfo()));
        }
    }

    private static boolean checkInsn(FieldInitInfo initInfo) {
        if (!initInfo.canMove) {
            return false;
        }
        IndexInsnNode insn = initInfo.putInsn;
        InsnArg arg = insn.getArg(0);
        if (arg.isInsnWrap()) {
            InsnNode wrapInsn = ((InsnWrapArg)arg).getWrapInsn();
            if (!wrapInsn.canReorder() && insn.contains(AType.EXC_CATCH)) {
                return false;
            }
        } else {
            return arg.isLiteral() || arg.isThis();
        }
        HashSet<RegisterArg> regs = new HashSet<RegisterArg>();
        insn.getRegisterArgs(regs);
        if (!regs.isEmpty()) {
            for (RegisterArg reg : regs) {
                if (reg.isThis()) continue;
                return false;
            }
        }
        return true;
    }

    private static boolean insnUseExcludedField(FieldInitInfo initInfo, Set<FieldInfo> excludedFields) {
        if (excludedFields.isEmpty()) {
            return false;
        }
        IndexInsnNode insn = initInfo.putInsn;
        boolean staticField = insn.getType() == InsnType.SPUT;
        InsnType useType = staticField ? InsnType.SGET : InsnType.IGET;
        Boolean exclude = insn.visitInsns(innerInsn -> {
            FieldInfo fieldInfo;
            if (innerInsn.getType() == useType && excludedFields.contains(fieldInfo = (FieldInfo)((IndexInsnNode)innerInsn).getIndex())) {
                return true;
            }
            return null;
        });
        return Objects.equals(exclude, Boolean.TRUE);
    }

    private static void fixFieldsOrder(ClassNode cls, List<FieldInitInfo> inits) {
        List<FieldNode> orderedFields = ExtractFieldInit.processFieldsDependencies(cls, inits);
        ExtractFieldInit.applyFieldsOrder(cls, orderedFields);
    }

    private static List<FieldNode> processFieldsDependencies(ClassNode cls, List<FieldInitInfo> inits) {
        List<FieldNode> orderedFields = Utils.collectionMap(inits, v -> v.fieldNode);
        HashMap deps = new HashMap(inits.size());
        for (FieldInitInfo initInfo : inits) {
            IndexInsnNode insn = initInfo.putInsn;
            boolean staticField = insn.getType() == InsnType.SPUT;
            InsnType useType = staticField ? InsnType.SGET : InsnType.IGET;
            insn.visitInsns(subInsn -> {
                FieldNode depField;
                FieldInfo fieldInfo;
                if (subInsn.getType() == useType && (fieldInfo = (FieldInfo)((IndexInsnNode)subInsn).getIndex()).getDeclClass().equals(cls.getClassInfo()) && (depField = cls.searchField(fieldInfo)) != null) {
                    deps.computeIfAbsent(initInfo.fieldNode, k -> new ArrayList()).add(depField);
                }
            });
        }
        if (deps.isEmpty()) {
            return orderedFields;
        }
        ArrayList<FieldNode> result = new ArrayList<FieldNode>();
        for (FieldNode field : orderedFields) {
            int idx = result.indexOf(field);
            List fieldDeps = (List)deps.get(field);
            if (fieldDeps == null) {
                if (idx != -1) continue;
                result.add(field);
                continue;
            }
            if (idx == -1) {
                for (FieldNode depField : fieldDeps) {
                    if (result.contains(depField)) continue;
                    result.add(depField);
                }
                result.add(field);
                continue;
            }
            for (FieldNode depField : fieldDeps) {
                int depIdx = result.indexOf(depField);
                if (depIdx == -1) {
                    result.add(idx, depField);
                    continue;
                }
                if (depIdx <= idx) continue;
                result.remove(depIdx);
                result.add(idx, depField);
            }
        }
        return result;
    }

    private static void applyFieldsOrder(ClassNode cls, List<FieldNode> orderedFields) {
        boolean ordered;
        List<FieldNode> clsFields = cls.getFields();
        boolean bl = ordered = Collections.indexOfSubList(clsFields, orderedFields) != -1;
        if (!ordered) {
            clsFields.removeAll(orderedFields);
            clsFields.addAll(orderedFields);
        }
    }

    private static boolean compareFieldInits(List<FieldInitInfo> base, List<FieldInitInfo> other) {
        if (base.size() != other.size()) {
            return false;
        }
        int count = base.size();
        for (int i = 0; i < count; ++i) {
            IndexInsnNode baseInsn = base.get((int)i).putInsn;
            IndexInsnNode otherInsn = other.get((int)i).putInsn;
            if (((InsnNode)baseInsn).isSame(otherInsn)) continue;
            return false;
        }
        return true;
    }

    private static List<MethodNode> getConstructorsList(ClassNode cls) {
        ArrayList<MethodNode> list = new ArrayList<MethodNode>();
        for (MethodNode mth : cls.getMethods()) {
            AccessInfo accFlags = mth.getAccessFlags();
            if (accFlags.isStatic() || !accFlags.isConstructor()) continue;
            list.add(mth);
            if (!mth.isNoCode() && !BlockUtils.isAllBlocksEmpty(mth.getBasicBlocks())) continue;
            return Collections.emptyList();
        }
        return list;
    }

    private static void addFieldInitAttr(MethodNode mth, FieldNode field, IndexInsnNode putInsn) {
        InsnArg fldArg = putInsn.getArg(0);
        InsnNode assignInsn = fldArg.isInsnWrap() ? ((InsnWrapArg)fldArg).getWrapInsn() : InsnNode.wrapArg(fldArg);
        field.addAttr((IJadxAttribute)new FieldInitInsnAttr(mth, assignInsn));
    }

    private static final class FieldInitInfo {
        final FieldNode fieldNode;
        final IndexInsnNode putInsn;
        final boolean canMove;

        public FieldInitInfo(FieldNode fieldNode, IndexInsnNode putInsn, boolean canMove) {
            this.fieldNode = fieldNode;
            this.putInsn = putInsn;
            this.canMove = canMove;
        }
    }

    private static final class ConstructorInitInfo {
        final MethodNode constructorMth;
        final List<FieldInitInfo> fieldInits;

        private ConstructorInitInfo(MethodNode constructorMth, List<FieldInitInfo> fieldInits) {
            this.constructorMth = constructorMth;
            this.fieldInits = fieldInits;
        }
    }
}

