/*
 * Decompiled with CFR 0.152.
 */
package jadx.core.dex.visitors.regions;

import jadx.core.dex.attributes.AFlag;
import jadx.core.dex.instructions.InsnType;
import jadx.core.dex.nodes.IContainer;
import jadx.core.dex.nodes.IRegion;
import jadx.core.dex.nodes.InsnNode;
import jadx.core.dex.nodes.MethodNode;
import jadx.core.dex.regions.Region;
import jadx.core.dex.regions.conditions.IfCondition;
import jadx.core.dex.regions.conditions.IfRegion;
import jadx.core.dex.visitors.AbstractVisitor;
import jadx.core.dex.visitors.regions.AbstractRegionVisitor;
import jadx.core.dex.visitors.regions.DepthRegionTraversal;
import jadx.core.dex.visitors.regions.IRegionIterativeVisitor;
import jadx.core.dex.visitors.regions.TernaryMod;
import jadx.core.utils.RegionUtils;
import java.util.List;

public class IfRegionVisitor
extends AbstractVisitor {
    private static final ProcessIfRegionVisitor PROCESS_IF_REGION_VISITOR = new ProcessIfRegionVisitor();
    private static final RemoveRedundantElseVisitor REMOVE_REDUNDANT_ELSE_VISITOR = new RemoveRedundantElseVisitor();

    @Override
    public void visit(MethodNode mth) {
        if (mth.isNoCode()) {
            return;
        }
        IfRegionVisitor.process(mth);
    }

    public static void process(MethodNode mth) {
        TernaryMod.process(mth);
        DepthRegionTraversal.traverse(mth, PROCESS_IF_REGION_VISITOR);
        DepthRegionTraversal.traverseIterative(mth, REMOVE_REDUNDANT_ELSE_VISITOR);
    }

    private static void orderBranches(MethodNode mth, IfRegion ifRegion) {
        IfCondition condition;
        if (RegionUtils.isEmpty(ifRegion.getElseRegion())) {
            return;
        }
        if (RegionUtils.isEmpty(ifRegion.getThenRegion())) {
            IfRegionVisitor.invertIfRegion(ifRegion);
            return;
        }
        if (mth.contains(AFlag.USE_LINES_HINTS)) {
            int thenLine = RegionUtils.getFirstSourceLine(ifRegion.getThenRegion());
            int elseLine = RegionUtils.getFirstSourceLine(ifRegion.getElseRegion());
            if (thenLine != 0 && elseLine != 0) {
                if (thenLine > elseLine) {
                    IfRegionVisitor.invertIfRegion(ifRegion);
                }
                return;
            }
        }
        if (ifRegion.simplifyCondition() && (condition = ifRegion.getCondition()) != null && condition.getMode() == IfCondition.Mode.NOT) {
            IfRegionVisitor.invertIfRegion(ifRegion);
        }
        int thenSize = RegionUtils.insnsCount(ifRegion.getThenRegion());
        int elseSize = RegionUtils.insnsCount(ifRegion.getElseRegion());
        if (IfRegionVisitor.isSimpleExitBlock(mth, ifRegion.getElseRegion())) {
            if (IfRegionVisitor.isSimpleExitBlock(mth, ifRegion.getThenRegion()) && elseSize < thenSize) {
                IfRegionVisitor.invertIfRegion(ifRegion);
                return;
            }
            boolean lastRegion = RegionUtils.hasExitEdge(ifRegion);
            if (elseSize == 1 && lastRegion && mth.isVoidReturn()) {
                InsnNode lastElseInsn = RegionUtils.getLastInsn(ifRegion.getElseRegion());
                if (lastElseInsn != null && lastElseInsn.getType() == InsnType.THROW) {
                    IfRegionVisitor.invertIfRegion(ifRegion);
                }
                return;
            }
            if (!lastRegion) {
                IfRegionVisitor.invertIfRegion(ifRegion);
            }
            return;
        }
        boolean thenExit = RegionUtils.hasExitBlock(ifRegion.getThenRegion());
        boolean elseExit = RegionUtils.hasExitBlock(ifRegion.getElseRegion());
        if (elseExit && (!thenExit || elseSize < thenSize)) {
            IfRegionVisitor.invertIfRegion(ifRegion);
            return;
        }
        if (IfRegionVisitor.isIfRegion(ifRegion.getThenRegion()) && !IfRegionVisitor.isIfRegion(ifRegion.getElseRegion()) && !thenExit) {
            IfRegionVisitor.invertIfRegion(ifRegion);
            return;
        }
        if (RegionUtils.hasBreakInsn(ifRegion.getElseRegion())) {
            IfRegionVisitor.invertIfRegion(ifRegion);
            return;
        }
    }

    private static boolean isIfRegion(IContainer container) {
        if (container instanceof IfRegion) {
            return true;
        }
        if (container instanceof IRegion) {
            List<IContainer> subBlocks = ((IRegion)container).getSubBlocks();
            return subBlocks.size() == 1 && subBlocks.get(0) instanceof IfRegion;
        }
        return false;
    }

    private static void markElseIfChains(MethodNode mth, IfRegion ifRegion) {
        List<IContainer> subBlocks;
        if (IfRegionVisitor.isSimpleExitBlock(mth, ifRegion.getThenRegion())) {
            return;
        }
        IContainer elsRegion = ifRegion.getElseRegion();
        if (elsRegion instanceof Region && (subBlocks = ((Region)elsRegion).getSubBlocks()).size() == 1 && subBlocks.get(0) instanceof IfRegion) {
            subBlocks.get(0).add(AFlag.ELSE_IF_CHAIN);
            elsRegion.add(AFlag.ELSE_IF_CHAIN);
        }
    }

    private static boolean removeRedundantElseBlock(MethodNode mth, IfRegion ifRegion) {
        Region newRegion;
        if (ifRegion.getElseRegion() == null || ifRegion.contains(AFlag.ELSE_IF_CHAIN) || ifRegion.getElseRegion().contains(AFlag.ELSE_IF_CHAIN)) {
            return false;
        }
        if (!RegionUtils.hasExitBlock(ifRegion.getThenRegion())) {
            return false;
        }
        if (mth.isVoidReturn() && RegionUtils.insnsCount(ifRegion.getThenRegion()) == 2 && RegionUtils.insnsCount(ifRegion.getElseRegion()) == 2) {
            return false;
        }
        IRegion parent = ifRegion.getParent();
        if (parent.replaceSubBlock(ifRegion, newRegion = new Region(parent))) {
            newRegion.add(ifRegion);
            newRegion.add(ifRegion.getElseRegion());
            ifRegion.setElseRegion(null);
            return true;
        }
        return false;
    }

    private static void invertIfRegion(IfRegion ifRegion) {
        IContainer elseRegion = ifRegion.getElseRegion();
        if (elseRegion != null) {
            ifRegion.invert();
        }
    }

    private static boolean isSimpleExitBlock(MethodNode mth, IContainer container) {
        if (container == null) {
            return false;
        }
        if (container.contains(AFlag.RETURN) || RegionUtils.isExitBlock(mth, container)) {
            return true;
        }
        if (container instanceof IRegion) {
            List<IContainer> subBlocks = ((IRegion)container).getSubBlocks();
            return subBlocks.size() == 1 && RegionUtils.isExitBlock(mth, subBlocks.get(0));
        }
        return false;
    }

    private static class ProcessIfRegionVisitor
    extends AbstractRegionVisitor {
        private ProcessIfRegionVisitor() {
        }

        @Override
        public boolean enterRegion(MethodNode mth, IRegion region) {
            if (region instanceof IfRegion) {
                IfRegion ifRegion = (IfRegion)region;
                IfRegionVisitor.orderBranches(mth, ifRegion);
                IfRegionVisitor.markElseIfChains(mth, ifRegion);
            }
            return true;
        }
    }

    private static class RemoveRedundantElseVisitor
    implements IRegionIterativeVisitor {
        private RemoveRedundantElseVisitor() {
        }

        @Override
        public boolean visitRegion(MethodNode mth, IRegion region) {
            if (region instanceof IfRegion) {
                return IfRegionVisitor.removeRedundantElseBlock(mth, (IfRegion)region);
            }
            return false;
        }
    }
}

