/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.gui.oauth;

import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import javax.swing.BorderFactory;
import javax.swing.JCheckBox;
import javax.swing.JLabel;
import org.openstreetmap.josm.data.oauth.IOAuthParameters;
import org.openstreetmap.josm.data.oauth.OAuth20Parameters;
import org.openstreetmap.josm.data.oauth.OAuthParameters;
import org.openstreetmap.josm.data.oauth.OAuthVersion;
import org.openstreetmap.josm.gui.HelpAwareOptionPane;
import org.openstreetmap.josm.gui.help.HelpUtil;
import org.openstreetmap.josm.gui.widgets.JosmTextField;
import org.openstreetmap.josm.gui.widgets.SelectAllOnFocusGainedDecorator;
import org.openstreetmap.josm.gui.widgets.VerticallyScrollablePanel;
import org.openstreetmap.josm.spi.preferences.Config;
import org.openstreetmap.josm.tools.CheckParameterUtil;
import org.openstreetmap.josm.tools.I18n;
import org.openstreetmap.josm.tools.ImageProvider;

public class AdvancedOAuthPropertiesPanel
extends VerticallyScrollablePanel {
    private final JCheckBox cbUseDefaults = new JCheckBox(I18n.tr("Use default settings", new Object[0]));
    private final JosmTextField tfConsumerKey = new JosmTextField();
    private final JosmTextField tfConsumerSecret = new JosmTextField();
    private final JosmTextField tfRequestTokenURL = new JosmTextField();
    private final JosmTextField tfAccessTokenURL = new JosmTextField();
    private final JosmTextField tfAuthoriseURL = new JosmTextField();
    private final JosmTextField tfOsmLoginURL = new JosmTextField();
    private final JosmTextField tfOsmLogoutURL = new JosmTextField();
    private final OAuthVersion oauthVersion;
    private transient UseDefaultItemListener ilUseDefault;
    private String apiUrl;

    public AdvancedOAuthPropertiesPanel(OAuthVersion oauthVersion) {
        this.oauthVersion = oauthVersion;
        this.build();
    }

    protected final void build() {
        this.setLayout(new GridBagLayout());
        this.setBorder(BorderFactory.createEmptyBorder(3, 3, 3, 3));
        GridBagConstraints gc = new GridBagConstraints();
        gc.anchor = 18;
        gc.fill = 2;
        gc.weightx = 1.0;
        gc.insets = new Insets(0, 0, 3, 3);
        gc.gridwidth = 3;
        this.add((Component)this.cbUseDefaults, gc);
        gc.gridy = 1;
        gc.weightx = 0.0;
        gc.gridwidth = 1;
        if (this.oauthVersion == OAuthVersion.OAuth10a) {
            this.add((Component)new JLabel(I18n.tr("Consumer Key:", new Object[0])), gc);
        } else {
            this.add((Component)new JLabel(I18n.tr("Client ID:", new Object[0])), gc);
        }
        gc.gridx = 1;
        gc.weightx = 1.0;
        this.add((Component)this.tfConsumerKey, gc);
        SelectAllOnFocusGainedDecorator.decorate(this.tfConsumerKey);
        ++gc.gridy;
        gc.gridx = 0;
        gc.weightx = 0.0;
        if (this.oauthVersion == OAuthVersion.OAuth10a) {
            this.add((Component)new JLabel(I18n.tr("Consumer Secret:", new Object[0])), gc);
        } else {
            this.add((Component)new JLabel(I18n.tr("Client Secret:", new Object[0])), gc);
        }
        gc.gridx = 1;
        gc.weightx = 1.0;
        this.add((Component)this.tfConsumerSecret, gc);
        SelectAllOnFocusGainedDecorator.decorate(this.tfConsumerSecret);
        ++gc.gridy;
        gc.gridx = 0;
        gc.weightx = 0.0;
        if (this.oauthVersion == OAuthVersion.OAuth10a) {
            this.add((Component)new JLabel(I18n.tr("Request Token URL:", new Object[0])), gc);
        } else {
            this.add((Component)new JLabel(I18n.tr("Redirect URL:", new Object[0])), gc);
        }
        gc.gridx = 1;
        gc.weightx = 1.0;
        this.add((Component)this.tfRequestTokenURL, gc);
        SelectAllOnFocusGainedDecorator.decorate(this.tfRequestTokenURL);
        ++gc.gridy;
        gc.gridx = 0;
        gc.weightx = 0.0;
        this.add((Component)new JLabel(I18n.tr("Access Token URL:", new Object[0])), gc);
        gc.gridx = 1;
        gc.weightx = 1.0;
        this.add((Component)this.tfAccessTokenURL, gc);
        SelectAllOnFocusGainedDecorator.decorate(this.tfAccessTokenURL);
        ++gc.gridy;
        gc.gridx = 0;
        gc.weightx = 0.0;
        this.add((Component)new JLabel(I18n.tr("Authorize URL:", new Object[0])), gc);
        gc.gridx = 1;
        gc.weightx = 1.0;
        this.add((Component)this.tfAuthoriseURL, gc);
        SelectAllOnFocusGainedDecorator.decorate(this.tfAuthoriseURL);
        if (this.oauthVersion == OAuthVersion.OAuth10a) {
            ++gc.gridy;
            gc.gridx = 0;
            gc.weightx = 0.0;
            this.add((Component)new JLabel(I18n.tr("OSM login URL:", new Object[0])), gc);
            gc.gridx = 1;
            gc.weightx = 1.0;
            this.add((Component)this.tfOsmLoginURL, gc);
            SelectAllOnFocusGainedDecorator.decorate(this.tfOsmLoginURL);
            ++gc.gridy;
            gc.gridx = 0;
            gc.weightx = 0.0;
            this.add((Component)new JLabel(I18n.tr("OSM logout URL:", new Object[0])), gc);
            gc.gridx = 1;
            gc.weightx = 1.0;
            this.add((Component)this.tfOsmLogoutURL, gc);
            SelectAllOnFocusGainedDecorator.decorate(this.tfOsmLogoutURL);
        }
        this.ilUseDefault = new UseDefaultItemListener();
        this.cbUseDefaults.addItemListener(this.ilUseDefault);
    }

    protected boolean hasCustomSettings() {
        OAuthParameters params = OAuthParameters.createDefault(this.apiUrl);
        return !params.equals(this.getAdvancedParameters());
    }

    protected boolean confirmOverwriteCustomSettings() {
        HelpAwareOptionPane.ButtonSpec[] buttons = new HelpAwareOptionPane.ButtonSpec[]{new HelpAwareOptionPane.ButtonSpec(I18n.tr("Continue", new Object[0]), new ImageProvider("ok"), I18n.tr("Click to reset the OAuth settings to default values", new Object[0]), null), new HelpAwareOptionPane.ButtonSpec(I18n.tr("Cancel", new Object[0]), new ImageProvider("cancel"), I18n.tr("Click to abort resetting to the OAuth default values", new Object[0]), null)};
        return 0 == HelpAwareOptionPane.showOptionDialog(this, I18n.tr("<html>JOSM is about to reset the OAuth settings to default values.<br>The current custom settings are not saved.</html>", new Object[0]), I18n.tr("Overwrite custom OAuth settings?", new Object[0]), 2, null, buttons, buttons[0], HelpUtil.ht("/Dialog/OAuthAuthorisationWizard"));
    }

    protected void resetToDefaultSettings() {
        this.cbUseDefaults.setSelected(true);
        IOAuthParameters iParams = OAuthParameters.createDefault(this.apiUrl, this.oauthVersion);
        switch (this.oauthVersion) {
            case OAuth10a: {
                OAuthParameters params = (OAuthParameters)iParams;
                this.tfConsumerKey.setText(params.getConsumerKey());
                this.tfConsumerSecret.setText(params.getConsumerSecret());
                this.tfRequestTokenURL.setText(params.getRequestTokenUrl());
                this.tfAccessTokenURL.setText(params.getAccessTokenUrl());
                this.tfAuthoriseURL.setText(params.getAuthoriseUrl());
                this.tfOsmLoginURL.setText(params.getOsmLoginUrl());
                this.tfOsmLogoutURL.setText(params.getOsmLogoutUrl());
                break;
            }
            case OAuth20: 
            case OAuth21: {
                OAuth20Parameters params20 = (OAuth20Parameters)iParams;
                this.tfConsumerKey.setText(params20.getClientId());
                this.tfConsumerSecret.setText(params20.getClientSecret());
                this.tfAccessTokenURL.setText(params20.getAccessTokenUrl());
                this.tfAuthoriseURL.setText(params20.getAuthorizationUrl());
                this.tfRequestTokenURL.setText(params20.getRedirectUri());
            }
        }
        this.setChildComponentsEnabled(false);
    }

    protected void setChildComponentsEnabled(boolean enabled) {
        for (Component c : this.getComponents()) {
            if (!(c instanceof JosmTextField) && !(c instanceof JLabel)) continue;
            c.setEnabled(enabled);
        }
    }

    public IOAuthParameters getAdvancedParameters() {
        if (this.cbUseDefaults.isSelected()) {
            return OAuthParameters.createDefault(this.apiUrl, this.oauthVersion);
        }
        if (this.oauthVersion == OAuthVersion.OAuth10a) {
            return new OAuthParameters(this.tfConsumerKey.getText(), this.tfConsumerSecret.getText(), this.tfRequestTokenURL.getText(), this.tfAccessTokenURL.getText(), this.tfAuthoriseURL.getText(), this.tfOsmLoginURL.getText(), this.tfOsmLogoutURL.getText());
        }
        return new OAuth20Parameters(this.tfConsumerKey.getText(), this.tfConsumerSecret.getText(), this.tfAuthoriseURL.getText(), this.tfAccessTokenURL.getText(), this.tfRequestTokenURL.getText());
    }

    public void setAdvancedParameters(IOAuthParameters parameters) {
        CheckParameterUtil.ensureParameterNotNull(parameters, "parameters");
        if (parameters.equals(OAuthParameters.createDefault(this.apiUrl, parameters.getOAuthVersion()))) {
            this.cbUseDefaults.setSelected(true);
            this.setChildComponentsEnabled(false);
        } else {
            this.cbUseDefaults.setSelected(false);
            this.setChildComponentsEnabled(true);
            if (parameters instanceof OAuthParameters) {
                OAuthParameters parameters10 = (OAuthParameters)parameters;
                this.tfConsumerKey.setText(parameters10.getConsumerKey() == null ? "" : parameters10.getConsumerKey());
                this.tfConsumerSecret.setText(parameters10.getConsumerSecret() == null ? "" : parameters10.getConsumerSecret());
                this.tfRequestTokenURL.setText(parameters10.getRequestTokenUrl() == null ? "" : parameters10.getRequestTokenUrl());
                this.tfAccessTokenURL.setText(parameters10.getAccessTokenUrl() == null ? "" : parameters10.getAccessTokenUrl());
                this.tfAuthoriseURL.setText(parameters10.getAuthoriseUrl() == null ? "" : parameters10.getAuthoriseUrl());
                this.tfOsmLoginURL.setText(parameters10.getOsmLoginUrl() == null ? "" : parameters10.getOsmLoginUrl());
                this.tfOsmLogoutURL.setText(parameters10.getOsmLogoutUrl() == null ? "" : parameters10.getOsmLogoutUrl());
            } else if (parameters instanceof OAuth20Parameters) {
                OAuth20Parameters parameters20 = (OAuth20Parameters)parameters;
                this.tfConsumerKey.setText(parameters20.getClientId());
                this.tfConsumerSecret.setText(parameters20.getClientSecret());
                this.tfAccessTokenURL.setText(parameters20.getAccessTokenUrl());
                this.tfAuthoriseURL.setText(parameters20.getAuthorizationUrl());
                this.tfRequestTokenURL.setText(parameters20.getRedirectUri());
            }
        }
    }

    public void initialize(String paramApiUrl) {
        CheckParameterUtil.ensureParameterNotNull(paramApiUrl, "paramApiUrl");
        this.setApiUrl(paramApiUrl);
        boolean useDefault = Config.getPref().getBoolean("oauth.settings.use-default", true);
        this.ilUseDefault.setEnabled(false);
        if (useDefault) {
            this.resetToDefaultSettings();
        } else {
            this.setAdvancedParameters(OAuthParameters.createFromApiUrl(paramApiUrl));
        }
        this.ilUseDefault.setEnabled(true);
    }

    public void rememberPreferences() {
        Config.getPref().putBoolean("oauth.settings.use-default", this.cbUseDefaults.isSelected());
        if (this.cbUseDefaults.isSelected()) {
            new OAuthParameters(null, null, null, null, null, null, null).rememberPreferences();
        } else {
            this.getAdvancedParameters().rememberPreferences();
        }
    }

    public void setApiUrl(String apiUrl) {
        this.apiUrl = apiUrl;
        if (this.cbUseDefaults.isSelected()) {
            this.resetToDefaultSettings();
        }
    }

    class UseDefaultItemListener
    implements ItemListener {
        private boolean enabled;

        UseDefaultItemListener() {
        }

        @Override
        public void itemStateChanged(ItemEvent e) {
            if (!this.enabled) {
                return;
            }
            switch (e.getStateChange()) {
                case 1: {
                    if (AdvancedOAuthPropertiesPanel.this.hasCustomSettings() && !AdvancedOAuthPropertiesPanel.this.confirmOverwriteCustomSettings()) {
                        AdvancedOAuthPropertiesPanel.this.cbUseDefaults.setSelected(false);
                        return;
                    }
                    AdvancedOAuthPropertiesPanel.this.resetToDefaultSettings();
                    break;
                }
                case 2: {
                    AdvancedOAuthPropertiesPanel.this.setChildComponentsEnabled(true);
                    break;
                }
            }
        }

        public void setEnabled(boolean enabled) {
            this.enabled = enabled;
        }
    }
}

