/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.streams.kstream.internals;

import org.apache.kafka.common.metrics.Sensor;
import org.apache.kafka.streams.kstream.KeyValueMapper;
import org.apache.kafka.streams.kstream.ValueJoiner;
import org.apache.kafka.streams.kstream.internals.Change;
import org.apache.kafka.streams.kstream.internals.KTableImpl;
import org.apache.kafka.streams.kstream.internals.KTableKTableAbstractJoin;
import org.apache.kafka.streams.kstream.internals.KTableKTableAbstractJoinValueGetterSupplier;
import org.apache.kafka.streams.kstream.internals.KTableValueGetter;
import org.apache.kafka.streams.kstream.internals.KTableValueGetterSupplier;
import org.apache.kafka.streams.processor.api.ContextualProcessor;
import org.apache.kafka.streams.processor.api.Processor;
import org.apache.kafka.streams.processor.api.ProcessorContext;
import org.apache.kafka.streams.processor.api.Record;
import org.apache.kafka.streams.processor.api.RecordMetadata;
import org.apache.kafka.streams.processor.internals.metrics.StreamsMetricsImpl;
import org.apache.kafka.streams.processor.internals.metrics.TaskMetrics;
import org.apache.kafka.streams.state.ValueAndTimestamp;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class KTableKTableInnerJoin<K, V1, V2, VOut>
extends KTableKTableAbstractJoin<K, V1, V2, VOut> {
    private static final Logger LOG = LoggerFactory.getLogger(KTableKTableInnerJoin.class);
    private final KeyValueMapper<K, V1, K> keyValueMapper = (key, value) -> key;

    KTableKTableInnerJoin(KTableImpl<K, ?, V1> table1, KTableImpl<K, ?, V2> table2, ValueJoiner<? super V1, ? super V2, ? extends VOut> joiner) {
        super(table1, table2, joiner);
    }

    @Override
    public Processor<K, Change<V1>, K, Change<VOut>> get() {
        return new KTableKTableJoinProcessor(this.valueGetterSupplier2.get());
    }

    @Override
    public KTableValueGetterSupplier<K, VOut> view() {
        return new KTableKTableInnerJoinValueGetterSupplier(this.valueGetterSupplier1, this.valueGetterSupplier2);
    }

    private class KTableKTableJoinProcessor
    extends ContextualProcessor<K, Change<V1>, K, Change<VOut>> {
        private final KTableValueGetter<K, V2> valueGetter;
        private Sensor droppedRecordsSensor;

        KTableKTableJoinProcessor(KTableValueGetter<K, V2> valueGetter) {
            this.valueGetter = valueGetter;
        }

        @Override
        public void init(ProcessorContext<K, Change<VOut>> context) {
            super.init(context);
            this.droppedRecordsSensor = TaskMetrics.droppedRecordsSensor(Thread.currentThread().getName(), context.taskId().toString(), (StreamsMetricsImpl)context.metrics());
            this.valueGetter.init(context);
        }

        @Override
        public void process(Record<K, Change<V1>> record) {
            if (record.key() == null) {
                if (this.context().recordMetadata().isPresent()) {
                    RecordMetadata recordMetadata = this.context().recordMetadata().get();
                    LOG.warn("Skipping record due to null key. topic=[{}] partition=[{}] offset=[{}]", new Object[]{recordMetadata.topic(), recordMetadata.partition(), recordMetadata.offset()});
                } else {
                    LOG.warn("Skipping record due to null key. Topic, partition, and offset not known.");
                }
                this.droppedRecordsSensor.record();
                return;
            }
            if (KTableKTableInnerJoin.this.useVersionedSemantics && !record.value().isLatest) {
                LOG.info("Skipping out-of-order record from versioned table while performing table-table join.");
                this.droppedRecordsSensor.record();
                return;
            }
            Object newValue = null;
            Object oldValue = null;
            ValueAndTimestamp valueAndTimestampRight = this.valueGetter.get(record.key());
            Object valueRight = ValueAndTimestamp.getValueOrNull(valueAndTimestampRight);
            if (valueRight == null) {
                return;
            }
            long resultTimestamp = Math.max(record.timestamp(), valueAndTimestampRight.timestamp());
            if (record.value().newValue != null) {
                newValue = KTableKTableInnerJoin.this.joiner.apply(record.value().newValue, valueRight);
            }
            if (KTableKTableInnerJoin.this.sendOldValues && record.value().oldValue != null) {
                oldValue = KTableKTableInnerJoin.this.joiner.apply(record.value().oldValue, valueRight);
            }
            this.context().forward(record.withValue(new Change<Object>(newValue, oldValue, record.value().isLatest)).withTimestamp(resultTimestamp));
        }

        @Override
        public void close() {
            this.valueGetter.close();
        }
    }

    private class KTableKTableInnerJoinValueGetterSupplier
    extends KTableKTableAbstractJoinValueGetterSupplier<K, VOut, V1, V2> {
        KTableKTableInnerJoinValueGetterSupplier(KTableValueGetterSupplier<K, V1> valueGetterSupplier1, KTableValueGetterSupplier<K, V2> valueGetterSupplier2) {
            super(valueGetterSupplier1, valueGetterSupplier2);
        }

        @Override
        public KTableValueGetter<K, VOut> get() {
            return new KTableKTableInnerJoinValueGetter(this.valueGetterSupplier1.get(), this.valueGetterSupplier2.get());
        }
    }

    private class KTableKTableInnerJoinValueGetter
    implements KTableValueGetter<K, VOut> {
        private final KTableValueGetter<K, V1> valueGetter1;
        private final KTableValueGetter<K, V2> valueGetter2;

        KTableKTableInnerJoinValueGetter(KTableValueGetter<K, V1> valueGetter1, KTableValueGetter<K, V2> valueGetter2) {
            this.valueGetter1 = valueGetter1;
            this.valueGetter2 = valueGetter2;
        }

        @Override
        public void init(ProcessorContext<?, ?> context) {
            this.valueGetter1.init(context);
            this.valueGetter2.init(context);
        }

        @Override
        public ValueAndTimestamp<VOut> get(K key) {
            ValueAndTimestamp valueAndTimestamp1 = this.valueGetter1.get(key);
            Object value1 = ValueAndTimestamp.getValueOrNull(valueAndTimestamp1);
            if (value1 != null) {
                ValueAndTimestamp valueAndTimestamp2 = this.valueGetter2.get(KTableKTableInnerJoin.this.keyValueMapper.apply(key, value1));
                Object value2 = ValueAndTimestamp.getValueOrNull(valueAndTimestamp2);
                if (value2 != null) {
                    return ValueAndTimestamp.make(KTableKTableInnerJoin.this.joiner.apply(value1, value2), Math.max(valueAndTimestamp1.timestamp(), valueAndTimestamp2.timestamp()));
                }
                return null;
            }
            return null;
        }

        @Override
        public boolean isVersioned() {
            return false;
        }

        @Override
        public void close() {
            this.valueGetter1.close();
            this.valueGetter2.close();
        }
    }
}

